/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphTreeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.dialogs.TimeGraphLegend;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphScale;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphTooltipHandler;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Slider;

public class TimeGraphViewer
implements ITimeDataProvider,
SelectionListener {
    private long _minTimeInterval;
    private long _selectedTime;
    private ITimeGraphEntry _selectedEntry;
    private long _beginTime;
    private long _endTime;
    private long _time0;
    private long _time1;
    private long _time0_;
    private long _time1_;
    private long _time0_extSynch = 0L;
    private long _time1_extSynch = 0L;
    private boolean _timeRangeFixed;
    private int _nameWidthPref = 200;
    private int _minNameWidth = 6;
    private int _nameWidth;
    private Composite _dataViewer;
    private TimeGraphControl _stateCtrl;
    private TimeGraphScale _timeScaleCtrl;
    private Slider _verticalScrollBar;
    private TimeGraphTooltipHandler _threadTip;
    private TimeGraphColorScheme _colors;
    private ITimeGraphPresentationProvider fTimeGraphProvider;
    ArrayList<ITimeGraphSelectionListener> fSelectionListeners = new ArrayList();
    ArrayList<ITimeGraphTimeListener> fTimeListeners = new ArrayList();
    ArrayList<ITimeGraphRangeListener> fRangeListeners = new ArrayList();
    private boolean calendarTimeFormat = false;
    private int borderWidth = 0;
    private int timeScaleHeight = 22;
    private Action resetScale;
    private Action showLegendAction;
    private Action nextEventAction;
    private Action prevEventAction;
    private Action nextItemAction;
    private Action previousItemAction;
    private Action zoomInAction;
    private Action zoomOutAction;

    public TimeGraphViewer(Composite parent, int style) {
        this.createDataViewer(parent, style);
    }

    public void setTimeGraphProvider(ITimeGraphPresentationProvider timeGraphProvider) {
        this.fTimeGraphProvider = timeGraphProvider;
        this._stateCtrl.setTimeGraphProvider(timeGraphProvider);
        this._threadTip = new TimeGraphTooltipHandler(this._dataViewer.getShell(), this.fTimeGraphProvider, this);
        this._threadTip.activateHoverHelp((Control)this._stateCtrl);
    }

    public void setInput(ITimeGraphEntry[] input) {
        if (this._stateCtrl != null) {
            if (input == null) {
                input = new ITimeGraphEntry[]{};
            }
            this.setTimeRange(input);
            this._verticalScrollBar.setEnabled(true);
            this.setTopIndex(0);
            this._selectedTime = 0L;
            this.refreshAllData(input);
        }
    }

    public void refresh() {
        this.setInput(this._stateCtrl.getTraces());
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.resizeControls();
    }

    public void modelUpdate(ITimeGraphEntry[] traces, long start, long end, boolean updateTimeBounds) {
        if (this._stateCtrl != null) {
            this.updateInternalData(traces, start, end);
            if (updateTimeBounds) {
                this._timeRangeFixed = true;
                this.setStartFinishTime(this._time0_, this._time1_);
            } else {
                this._stateCtrl.redraw();
                this._timeScaleCtrl.redraw();
            }
        }
    }

    protected String getViewTypeStr() {
        return "viewoption.threads";
    }

    int getMarginWidth(int idx) {
        return 0;
    }

    int getMarginHeight(int idx) {
        return 0;
    }

    void loadOptions() {
        this._minTimeInterval = 1L;
        this._selectedTime = -1L;
        this._nameWidth = Utils.loadIntOption(this.getPreferenceString("namewidth"), this._nameWidthPref, this._minNameWidth, 1000);
    }

    void saveOptions() {
        Utils.saveIntOption(this.getPreferenceString("namewidth"), this._nameWidth);
    }

    protected Control createDataViewer(Composite parent, int style) {
        this.loadOptions();
        this._colors = new TimeGraphColorScheme();
        this._dataViewer = new Composite(parent, style){

            public void redraw() {
                TimeGraphViewer.this._timeScaleCtrl.redraw();
                TimeGraphViewer.this._stateCtrl.redraw();
                super.redraw();
            }
        };
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = this.borderWidth;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this._dataViewer.setLayout((Layout)gl);
        this._timeScaleCtrl = new TimeGraphScale(this._dataViewer, this._colors);
        this._timeScaleCtrl.setTimeProvider(this);
        this._timeScaleCtrl.setLayoutData(new GridData(4, -1, true, false));
        this._timeScaleCtrl.setHeight(this.timeScaleHeight);
        this._verticalScrollBar = new Slider(this._dataViewer, 524800);
        this._verticalScrollBar.setLayoutData((Object)new GridData(-1, 4, false, true, 1, 2));
        this._verticalScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeGraphViewer.this.setTopIndex(TimeGraphViewer.this._verticalScrollBar.getSelection());
            }
        });
        this._verticalScrollBar.setEnabled(false);
        this._stateCtrl = this.createTimeGraphControl();
        this._stateCtrl.setTimeProvider(this);
        this._stateCtrl.addSelectionListener(this);
        this._stateCtrl.setLayoutData(new GridData(4, 4, true, true, 1, 2));
        this._stateCtrl.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                TimeGraphViewer.this.adjustVerticalScrollBar();
            }
        });
        this._stateCtrl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TimeGraphViewer.this.adjustVerticalScrollBar();
            }
        });
        Composite filler = new Composite(this._dataViewer, 0);
        GridData gd = new GridData(-1, -1, false, false);
        gd.heightHint = this._stateCtrl.getHorizontalBar().getSize().y;
        filler.setLayoutData((Object)gd);
        filler.setLayout((Layout)new FillLayout());
        this._stateCtrl.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TimeGraphViewer.this.resizeControls();
            }
        });
        this.resizeControls();
        this._dataViewer.update();
        this.adjustVerticalScrollBar();
        return this._dataViewer;
    }

    public void dispose() {
        this.saveOptions();
        this._stateCtrl.dispose();
        this._dataViewer.dispose();
        this._colors.dispose();
    }

    protected TimeGraphControl createTimeGraphControl() {
        return new TimeGraphControl(this._dataViewer, this._colors);
    }

    public void resizeControls() {
        Rectangle r = this._dataViewer.getClientArea();
        if (r.isEmpty()) {
            return;
        }
        int width = r.width;
        if (this._nameWidth > width - this._minNameWidth) {
            this._nameWidth = width - this._minNameWidth;
        }
        if (this._nameWidth < this._minNameWidth) {
            this._nameWidth = this._minNameWidth;
        }
        this.adjustVerticalScrollBar();
    }

    public void setTimeRange(ITimeGraphEntry[] traces) {
        this._endTime = 0L;
        this._beginTime = -1L;
        int i = 0;
        while (i < traces.length) {
            ITimeGraphEntry entry = traces[i];
            if (entry.getEndTime() >= entry.getStartTime() && entry.getEndTime() > 0L) {
                if (this._beginTime < 0L || entry.getStartTime() < this._beginTime) {
                    this._beginTime = entry.getStartTime();
                }
                if (entry.getEndTime() > this._endTime) {
                    this._endTime = entry.getEndTime();
                }
            }
            ++i;
        }
        if (this._beginTime < 0L) {
            this._beginTime = 0L;
        }
    }

    public void setTimeBounds() {
        this._time0_ = this._beginTime;
        if (this._time0_ < 0L) {
            this._time0_ = 0L;
        }
        this._time1_ = this._endTime;
        if (!this._timeRangeFixed) {
            this._time0 = this._time0_;
            this._time1 = this._time1_;
        }
        if (this._time1 - this._time0 < this._minTimeInterval) {
            this._time1 = this._time0 + this._minTimeInterval;
        }
    }

    void updateInternalData(ITimeGraphEntry[] traces, long start, long end) {
        if (traces == null) {
            traces = new ITimeGraphEntry[]{};
        }
        if (start == 0L && end == 0L || start < 0L || end < 0L) {
            this.setTimeRange(traces);
        } else {
            this._beginTime = start;
            this._endTime = end;
        }
        this.refreshAllData(traces);
    }

    private void refreshAllData(ITimeGraphEntry[] traces) {
        this.setTimeBounds();
        if (this._selectedTime < this._beginTime) {
            this._selectedTime = this._beginTime;
        } else if (this._selectedTime > this._endTime) {
            this._selectedTime = this._endTime;
        }
        this._stateCtrl.refreshData(traces);
        this._timeScaleCtrl.redraw();
        this.adjustVerticalScrollBar();
    }

    public void setFocus() {
        if (this._stateCtrl != null) {
            this._stateCtrl.setFocus();
        }
    }

    public boolean isInFocus() {
        return this._stateCtrl.isInFocus();
    }

    public ITimeGraphEntry getSelection() {
        return this._stateCtrl.getSelectedTrace();
    }

    public int getSelectionIndex() {
        return this._stateCtrl.getSelectedIndex();
    }

    @Override
    public long getTime0() {
        return this._time0;
    }

    @Override
    public long getTime1() {
        return this._time1;
    }

    @Override
    public long getMinTimeInterval() {
        return this._minTimeInterval;
    }

    @Override
    public int getNameSpace() {
        return this._nameWidth;
    }

    @Override
    public void setNameSpace(int width) {
        this._nameWidth = width;
        width = this._stateCtrl.getClientArea().width;
        if (this._nameWidth > width - 6) {
            this._nameWidth = width - 6;
        }
        if (this._nameWidth < 6) {
            this._nameWidth = 6;
        }
        this._stateCtrl.adjustScrolls();
        this._stateCtrl.redraw();
        this._timeScaleCtrl.redraw();
    }

    @Override
    public int getTimeSpace() {
        int w = this._stateCtrl.getClientArea().width;
        return w - this._nameWidth;
    }

    @Override
    public long getSelectedTime() {
        return this._selectedTime;
    }

    @Override
    public long getBeginTime() {
        return this._beginTime;
    }

    @Override
    public long getEndTime() {
        return this._endTime;
    }

    @Override
    public long getMaxTime() {
        return this._time1_;
    }

    @Override
    public long getMinTime() {
        return this._time0_;
    }

    @Override
    public void setStartFinishTimeNotify(long time0, long time1) {
        this.setStartFinishTime(time0, time1);
        this.notifyRangeListeners(time0, time1);
    }

    @Override
    public void notifyStartFinishTime() {
        this.notifyRangeListeners(this._time0, this._time1);
    }

    @Override
    public void setStartFinishTime(long time0, long time1) {
        this._time0 = time0;
        if (this._time0 < this._time0_) {
            this._time0 = this._time0_;
        }
        if (this._time0 > this._time1_) {
            this._time0 = this._time1_;
        }
        this._time1 = time1;
        if (this._time1 < this._time0_) {
            this._time1 = this._time0_;
        }
        if (this._time1 > this._time1_) {
            this._time1 = this._time1_;
        }
        if (this._time1 - this._time0 < this._minTimeInterval) {
            this._time1 = Math.min(this._time1_, this._time0 + this._minTimeInterval);
        }
        this._timeRangeFixed = true;
        this._stateCtrl.adjustScrolls();
        this._stateCtrl.redraw();
        this._timeScaleCtrl.redraw();
    }

    public void setTimeBounds(long beginTime, long endTime) {
        this._beginTime = beginTime;
        this._endTime = endTime;
        this._time0_ = beginTime;
        this._time1_ = endTime;
        this._stateCtrl.adjustScrolls();
    }

    @Override
    public void resetStartFinishTime() {
        this.setStartFinishTimeNotify(this._time0_, this._time1_);
        this._timeRangeFixed = false;
    }

    @Override
    public void setSelectedTimeNotify(long time, boolean ensureVisible) {
        this.setSelectedTimeInt(time, ensureVisible, true);
    }

    @Override
    public void setSelectedTime(long time, boolean ensureVisible) {
        this.setSelectedTimeInt(time, ensureVisible, false);
    }

    private void setSelectedTimeInt(long time, boolean ensureVisible, boolean doNotify) {
        long time0 = this._time0;
        long time1 = this._time1;
        if (ensureVisible) {
            long timeSpace = (long)((double)(this._time1 - this._time0) * 0.02);
            long timeMid = (long)((double)(this._time1 - this._time0) * 0.5);
            if (time < this._time0 + timeSpace) {
                long dt = this._time0 - time + timeMid;
                this._time0 -= dt;
                this._time1 -= dt;
            } else if (time > this._time1 - timeSpace) {
                long dt = time - this._time1 + timeMid;
                this._time0 += dt;
                this._time1 += dt;
            }
            if (this._time0 < this._time0_) {
                this._time1 = Math.min(this._time1_, this._time1 + (this._time0_ - this._time0));
                this._time0 = this._time0_;
            } else if (this._time1 > this._time1_) {
                this._time0 = Math.max(this._time0_, this._time0 - (this._time1 - this._time1_));
                this._time1 = this._time1_;
            }
        }
        if (this._time1 - this._time0 < this._minTimeInterval) {
            this._time1 = this._time0 + this._minTimeInterval;
        }
        this._stateCtrl.adjustScrolls();
        this._stateCtrl.redraw();
        this._timeScaleCtrl.redraw();
        boolean notifySelectedTime = time != this._selectedTime;
        this._selectedTime = time;
        if (doNotify && (time0 != this._time0 || time1 != this._time1)) {
            this.notifyRangeListeners(this._time0, this._time1);
        }
        if (doNotify && notifySelectedTime) {
            this.notifyTimeListeners(this._selectedTime);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this._selectedEntry != this.getSelection()) {
            this._selectedEntry = this.getSelection();
            this.notifySelectionListeners(this._selectedEntry);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this._selectedEntry != this.getSelection()) {
            this._selectedEntry = this.getSelection();
            this.notifySelectionListeners(this._selectedEntry);
        }
    }

    public void selectNextEvent() {
        this._stateCtrl.selectNextEvent();
        this.adjustVerticalScrollBar();
    }

    public void selectPrevEvent() {
        this._stateCtrl.selectPrevEvent();
        this.adjustVerticalScrollBar();
    }

    public void selectNextItem() {
        this._stateCtrl.selectNextTrace();
        this.adjustVerticalScrollBar();
    }

    public void selectPrevItem() {
        this._stateCtrl.selectPrevTrace();
        this.adjustVerticalScrollBar();
    }

    public void showLegend() {
        if (this._dataViewer == null || this._dataViewer.isDisposed()) {
            return;
        }
        TimeGraphLegend.open(this._dataViewer.getShell(), this.fTimeGraphProvider);
    }

    public void zoomIn() {
        this._stateCtrl.zoomIn();
    }

    public void zoomOut() {
        this._stateCtrl.zoomOut();
    }

    private String getPreferenceString(String string) {
        return String.valueOf(this.getViewTypeStr()) + "." + string;
    }

    public void addSelectionListener(ITimeGraphSelectionListener listener) {
        this.fSelectionListeners.add(listener);
    }

    public void removeSelectionListener(ITimeGraphSelectionListener listener) {
        this.fSelectionListeners.remove(listener);
    }

    private void notifySelectionListeners(ITimeGraphEntry selection) {
        TimeGraphSelectionEvent event = new TimeGraphSelectionEvent(this, selection);
        for (ITimeGraphSelectionListener listener : this.fSelectionListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addTimeListener(ITimeGraphTimeListener listener) {
        this.fTimeListeners.add(listener);
    }

    public void removeTimeListener(ITimeGraphTimeListener listener) {
        this.fTimeListeners.remove(listener);
    }

    private void notifyTimeListeners(long time) {
        TimeGraphTimeEvent event = new TimeGraphTimeEvent(this, time);
        for (ITimeGraphTimeListener listener : this.fTimeListeners) {
            listener.timeSelected(event);
        }
    }

    public void addRangeListener(ITimeGraphRangeListener listener) {
        this.fRangeListeners.add(listener);
    }

    public void removeRangeListener(ITimeGraphRangeListener listener) {
        this.fRangeListeners.remove(listener);
    }

    private void notifyRangeListeners(long startTime, long endTime) {
        if (startTime != this._time0_extSynch || endTime != this._time1_extSynch) {
            TimeGraphRangeUpdateEvent event = new TimeGraphRangeUpdateEvent(this, startTime, endTime);
            for (ITimeGraphRangeListener listener : this.fRangeListeners) {
                listener.timeRangeUpdated(event);
            }
            this.updateExtSynchTimers();
        }
    }

    public void setSelectedEvent(ITimeEvent event, Object source) {
        if (event == null || source == this) {
            return;
        }
        this._selectedEntry = event.getEntry();
        this._stateCtrl.selectItem(this._selectedEntry, false);
        this.setSelectedTimeInt(event.getTime(), true, true);
        this.adjustVerticalScrollBar();
    }

    public void setSelectedTraceTime(ITimeGraphEntry trace, long time, Object source) {
        if (trace == null || source == this) {
            return;
        }
        this._selectedEntry = trace;
        this._stateCtrl.selectItem(trace, false);
        this.setSelectedTimeInt(time, true, true);
    }

    public void setSelection(ITimeGraphEntry trace) {
        this._selectedEntry = trace;
        this._stateCtrl.selectItem(trace, false);
        this.adjustVerticalScrollBar();
    }

    public void setSelectVisTimeWindow(long time0, long time1, Object source) {
        if (source == this) {
            return;
        }
        this.setStartFinishTime(time0, time1);
        this.updateExtSynchTimers();
    }

    private void updateExtSynchTimers() {
        this._time0_extSynch = this._time0;
        this._time1_extSynch = this._time1;
    }

    public void setTimeCalendarFormat(boolean toAbsoluteCaltime) {
        this.calendarTimeFormat = toAbsoluteCaltime;
    }

    @Override
    public boolean isCalendarFormat() {
        return this.calendarTimeFormat;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        if (borderWidth > -1) {
            this.borderWidth = borderWidth;
            GridLayout gl = (GridLayout)this._dataViewer.getLayout();
            gl.marginHeight = borderWidth;
        }
    }

    public int getHeaderHeight() {
        return this.timeScaleHeight;
    }

    public void setHeaderHeight(int headerHeight) {
        if (headerHeight > -1) {
            this.timeScaleHeight = headerHeight;
            this._timeScaleCtrl.setHeight(headerHeight);
        }
    }

    public int getItemHeight() {
        if (this._stateCtrl != null) {
            return this._stateCtrl.getItemHeight();
        }
        return 0;
    }

    public void setItemHeight(int rowHeight) {
        if (this._stateCtrl != null) {
            this._stateCtrl.setItemHeight(rowHeight);
        }
    }

    public void setMinimumItemWidth(int width) {
        if (this._stateCtrl != null) {
            this._stateCtrl.setMinimumItemWidth(width);
        }
    }

    public void setNameWidthPref(int width) {
        this._nameWidthPref = width;
        if (width == 0) {
            this._minNameWidth = 0;
            this._nameWidth = 0;
        }
    }

    public int getNameWidthPref(int width) {
        return this._nameWidthPref;
    }

    public Control getControl() {
        return this._dataViewer;
    }

    TimeGraphControl getTimeGraphControl() {
        return this._stateCtrl;
    }

    TimeGraphScale getTimeGraphScale() {
        return this._timeScaleCtrl;
    }

    public ISelectionProvider getSelectionProvider() {
        return this._stateCtrl;
    }

    public void waitCursor(boolean waitInd) {
        this._stateCtrl.waitCursor(waitInd);
    }

    public ScrollBar getHorizontalBar() {
        return this._stateCtrl.getHorizontalBar();
    }

    public Slider getVerticalBar() {
        return this._verticalScrollBar;
    }

    public void setTopIndex(int index) {
        this._stateCtrl.setTopIndex(index);
        this.adjustVerticalScrollBar();
    }

    public int getTopIndex() {
        return this._stateCtrl.getTopIndex();
    }

    public void setExpandedState(ITimeGraphEntry entry, boolean expanded) {
        this._stateCtrl.setExpandedState(entry, expanded);
        this.adjustVerticalScrollBar();
    }

    public int getExpandedElementCount() {
        return this._stateCtrl.getExpandedElementCount();
    }

    public ITimeGraphEntry[] getExpandedElements() {
        return this._stateCtrl.getExpandedElements();
    }

    public void addTreeListener(ITimeGraphTreeListener listener) {
        this._stateCtrl.addTreeListener(listener);
    }

    public void removeTreeListener(ITimeGraphTreeListener listener) {
        this._stateCtrl.removeTreeListener(listener);
    }

    public Action getResetScaleAction() {
        if (this.resetScale == null) {
            this.resetScale = new Action(){

                public void run() {
                    TimeGraphViewer.this.resetStartFinishTime();
                }
            };
            this.resetScale.setText(Messages.TmfTimeGraphViewer_ResetScaleActionNameText);
            this.resetScale.setToolTipText(Messages.TmfTimeGraphViewer_ResetScaleActionToolTipText);
            this.resetScale.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/home_nav.gif"));
        }
        return this.resetScale;
    }

    public Action getShowLegendAction() {
        if (this.showLegendAction == null) {
            this.showLegendAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.showLegend();
                }
            };
            this.showLegendAction.setText(Messages.TmfTimeGraphViewer_LegendActionNameText);
            this.showLegendAction.setToolTipText(Messages.TmfTimeGraphViewer_LegendActionToolTipText);
            this.showLegendAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/show_legend.gif"));
        }
        return this.showLegendAction;
    }

    public Action getNextEventAction() {
        if (this.nextEventAction == null) {
            this.nextEventAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.selectNextEvent();
                }
            };
            this.nextEventAction.setText(Messages.TmfTimeGraphViewer_NextEventActionNameText);
            this.nextEventAction.setToolTipText(Messages.TmfTimeGraphViewer_NextEventActionToolTipText);
            this.nextEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_event.gif"));
        }
        return this.nextEventAction;
    }

    public Action getPreviousEventAction() {
        if (this.prevEventAction == null) {
            this.prevEventAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.selectPrevEvent();
                }
            };
            this.prevEventAction.setText(Messages.TmfTimeGraphViewer_PreviousEventActionNameText);
            this.prevEventAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousEventActionToolTipText);
            this.prevEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_event.gif"));
        }
        return this.prevEventAction;
    }

    public Action getNextItemAction() {
        if (this.nextItemAction == null) {
            this.nextItemAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.selectNextItem();
                }
            };
            this.nextItemAction.setText(Messages.TmfTimeGraphViewer_NextItemActionNameText);
            this.nextItemAction.setToolTipText(Messages.TmfTimeGraphViewer_NextItemActionToolTipText);
            this.nextItemAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_menu.gif"));
        }
        return this.nextItemAction;
    }

    public Action getPreviousItemAction() {
        if (this.previousItemAction == null) {
            this.previousItemAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.selectPrevItem();
                }
            };
            this.previousItemAction.setText(Messages.TmfTimeGraphViewer_PreviousItemActionNameText);
            this.previousItemAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousItemActionToolTipText);
            this.previousItemAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_menu.gif"));
        }
        return this.previousItemAction;
    }

    public Action getZoomInAction() {
        if (this.zoomInAction == null) {
            this.zoomInAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.zoomIn();
                }
            };
            this.zoomInAction.setText(Messages.TmfTimeGraphViewer_ZoomInActionNameText);
            this.zoomInAction.setToolTipText(Messages.TmfTimeGraphViewer_ZoomInActionToolTipText);
            this.zoomInAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/zoomin_nav.gif"));
        }
        return this.zoomInAction;
    }

    public Action getZoomOutAction() {
        if (this.zoomOutAction == null) {
            this.zoomOutAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.zoomOut();
                }
            };
            this.zoomOutAction.setText(Messages.TmfTimeGraphViewer_ZoomOutActionNameText);
            this.zoomOutAction.setToolTipText(Messages.TmfTimeGraphViewer_ZoomOutActionToolTipText);
            this.zoomOutAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/zoomout_nav.gif"));
        }
        return this.zoomOutAction;
    }

    private void adjustVerticalScrollBar() {
        int expandedElementCount;
        int countPerPage;
        int topIndex = this._stateCtrl.getTopIndex();
        if (topIndex + (countPerPage = this._stateCtrl.countPerPage()) > (expandedElementCount = this._stateCtrl.getExpandedElementCount())) {
            this._stateCtrl.setTopIndex(Math.max(0, expandedElementCount - countPerPage));
        }
        int selection = this._stateCtrl.getTopIndex();
        int min = 0;
        int max = Math.max(1, expandedElementCount - 1);
        int thumb = Math.min(max, Math.max(1, countPerPage - 1));
        int increment = 1;
        int pageIncrement = Math.max(1, countPerPage);
        this._verticalScrollBar.setValues(selection, min, max, thumb, increment, pageIncrement);
    }
}

