/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import com.google.inject.Module;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.DependencyContext;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.DefaultSettingsProblem;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.settings.io.SettingsWriter;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.ILocalRepositoryListener;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenConfigurationChangeListener;
import org.eclipse.m2e.core.embedder.ISettingsChangeListener;
import org.eclipse.m2e.core.embedder.MavenConfigurationChangeEvent;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.ArtifactTransferListenerAdapter;
import org.eclipse.m2e.core.internal.embedder.ContextRepositorySystemSession;
import org.eclipse.m2e.core.internal.embedder.EclipseLoggerManager;
import org.eclipse.m2e.core.internal.embedder.ExtensionModule;
import org.eclipse.m2e.core.internal.embedder.MavenProjectMutableState;
import org.eclipse.m2e.core.internal.embedder.WagonTransferListenerAdapter;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.transfer.ArtifactNotFoundException;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.FilterRepositorySystemSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenImpl
implements IMaven,
IMavenConfigurationChangeListener {
    private static final Logger log = LoggerFactory.getLogger(MavenImpl.class);
    public static final String MAVEN_CORE_REALM_ID = "plexus.core";
    private DefaultPlexusContainer plexus;
    private final IMavenConfiguration mavenConfiguration;
    private final ConverterLookup converterLookup = new DefaultConverterLookup();
    private final ArrayList<ISettingsChangeListener> settingsListeners = new ArrayList();
    private final ArrayList<ILocalRepositoryListener> localRepositoryListeners = new ArrayList();
    private Settings settings;
    private long settings_length;
    private long settings_timestamp;
    private static final char PATH_SEPARATOR = '/';
    private static final char GROUP_SEPARATOR = '.';

    public MavenImpl(IMavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
        mavenConfiguration.addConfigurationChangeListener(this);
    }

    @Override
    public MavenExecutionRequest createExecutionRequest(IProgressMonitor monitor) throws CoreException {
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        if (this.mavenConfiguration.getGlobalSettingsFile() != null) {
            request.setGlobalSettingsFile(new File(this.mavenConfiguration.getGlobalSettingsFile()));
        }
        if (this.mavenConfiguration.getUserSettingsFile() != null) {
            request.setUserSettingsFile(new File(this.mavenConfiguration.getUserSettingsFile()));
        }
        try {
            this.lookup(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)request, this.getSettings());
        }
        catch (MavenExecutionRequestPopulationException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_no_exec_req, (Throwable)ex));
        }
        ArtifactRepository localRepository = this.getLocalRepository();
        request.setLocalRepository(localRepository);
        request.setLocalRepositoryPath(localRepository.getBasedir());
        request.setOffline(this.mavenConfiguration.isOffline());
        request.setTransferListener(this.createArtifactTransferListener(monitor));
        request.getUserProperties().put("m2e.version", MavenPluginActivator.getVersion());
        request.getUserProperties().put("aether.connector.userAgent", MavenPluginActivator.getUserAgent());
        EnvironmentUtils.addEnvVars((Properties)request.getSystemProperties());
        request.getSystemProperties().putAll((Map<?, ?>)System.getProperties());
        request.setCacheNotFound(true);
        request.setCacheTransferError(true);
        return request;
    }

    @Override
    public String getLocalRepositoryPath() {
        String path = null;
        try {
            Settings settings = this.getSettings();
            path = settings.getLocalRepository();
        }
        catch (CoreException coreException) {}
        if (path == null) {
            path = org.apache.maven.repository.RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        return path;
    }

    @Override
    public MavenExecutionResult execute(MavenExecutionRequest request, IProgressMonitor monitor) {
        DefaultMavenExecutionResult result;
        try {
            this.lookup(MavenExecutionRequestPopulator.class).populateDefaults(request);
            result = this.lookup(Maven.class).execute(request);
        }
        catch (MavenExecutionRequestPopulationException ex) {
            result = new DefaultMavenExecutionResult();
            result.addException((Throwable)ex);
        }
        catch (Exception e) {
            result = new DefaultMavenExecutionResult();
            result.addException((Throwable)e);
        }
        return result;
    }

    @Override
    public MavenSession createSession(MavenExecutionRequest request, MavenProject project) {
        RepositorySystemSession repoSession = this.createRepositorySession(request);
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        MavenSession mavenSession = new MavenSession((PlexusContainer)this.plexus, repoSession, request, (MavenExecutionResult)result);
        if (project != null) {
            mavenSession.setProjects(Collections.singletonList(project));
        }
        return mavenSession;
    }

    private RepositorySystemSession createRepositorySession(MavenExecutionRequest request) {
        try {
            Object session = ((DefaultMaven)this.lookup(Maven.class)).newRepositorySession(request);
            final String updatePolicy = this.mavenConfiguration.getGlobalUpdatePolicy();
            if (!request.isUpdateSnapshots() && updatePolicy != null) {
                session = new FilterRepositorySystemSession((RepositorySystemSession)session){

                    public String getUpdatePolicy() {
                        return updatePolicy;
                    }
                };
            }
            return session;
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException("Could not look up Maven embedder", ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(MavenSession session, MojoExecution execution, IProgressMonitor monitor) {
        block9: {
            block8: {
                artifacts = new HashMap<MavenProject, LinkedHashSet<E>>();
                snapshots = new HashMap<MavenProject, MavenProjectMutableState>();
                for (MavenProject project : session.getProjects()) {
                    artifacts.put(project, new LinkedHashSet<E>(project.getArtifacts()));
                    snapshots.put(project, MavenProjectMutableState.takeSnapshot(project));
                }
                try {
                    try {
                        mojoExecutor = this.lookup(MojoExecutor.class);
                        dependencyContext = mojoExecutor.newDependencyContext(session, Collections.singletonList(execution));
                        ensureDependenciesAreResolved = mojoExecutor.getClass().getDeclaredMethod("ensureDependenciesAreResolved", new Class[]{MojoDescriptor.class, MavenSession.class, DependencyContext.class});
                        ensureDependenciesAreResolved.setAccessible(true);
                        ensureDependenciesAreResolved.invoke((Object)mojoExecutor, new Object[]{execution.getMojoDescriptor(), session, dependencyContext});
                        this.lookup(BuildPluginManager.class).executeMojo(session, execution);
                        break block8;
                    }
                    catch (Exception ex) {
                        session.getResult().addException((Throwable)ex);
                        ** for (project : session.getProjects())
                    }
                }
                catch (Throwable var9_19) {
                    ** for (project : session.getProjects())
                }
lbl-1000:
                // 1 sources

                {
                    project.setArtifactFilter(null);
                    project.setResolvedArtifacts(null);
                    project.setArtifacts((Set)artifacts.get(project));
                    snapshot = (MavenProjectMutableState)snapshots.get(project);
                    if (snapshot == null) continue;
                    snapshot.restore(project);
                    continue;
lbl30:
                    // 1 sources

                    break block9;
                }
lbl-1000:
                // 1 sources

                {
                    project.setArtifactFilter(null);
                    project.setResolvedArtifacts(null);
                    project.setArtifacts((Set)artifacts.get(project));
                    snapshot = (MavenProjectMutableState)snapshots.get(project);
                    if (snapshot == null) continue;
                    snapshot.restore(project);
                    continue;
                }
lbl40:
                // 1 sources

                throw var9_19;
            }
            for (MavenProject project : session.getProjects()) {
                project.setArtifactFilter(null);
                project.setResolvedArtifacts(null);
                project.setArtifacts((Set)artifacts.get(project));
                snapshot = (MavenProjectMutableState)snapshots.get(project);
                if (snapshot == null) continue;
                snapshot.restore(project);
            }
        }
    }

    @Override
    public <T> T getConfiguredMojo(MavenSession session, MojoExecution mojoExecution, Class<T> clazz) throws CoreException {
        try {
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            this.lookup(BuildPluginManager.class).getPluginRealm(session, mojoDescriptor.getPluginDescriptor());
            return clazz.cast(this.lookup(MavenPluginManager.class).getConfiguredMojo(Mojo.class, session, mojoExecution));
        }
        catch (PluginContainerException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.MavenImpl_error_mojo, (Object)mojoExecution), (Throwable)ex));
        }
        catch (PluginConfigurationException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.MavenImpl_error_mojo, (Object)mojoExecution), (Throwable)ex));
        }
        catch (ClassCastException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.MavenImpl_error_mojo, (Object)mojoExecution), (Throwable)ex));
        }
        catch (PluginResolutionException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.MavenImpl_error_mojo, (Object)mojoExecution), (Throwable)ex));
        }
        catch (PluginManagerException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.MavenImpl_error_mojo, (Object)mojoExecution), (Throwable)ex));
        }
    }

    @Override
    public void releaseMojo(Object mojo, MojoExecution mojoExecution) throws CoreException {
        this.lookup(MavenPluginManager.class).releaseMojo(mojo, mojoExecution);
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session, MavenProject project, List<String> goals, boolean setup, IProgressMonitor monitor) throws CoreException {
        try {
            return this.lookup(LifecycleExecutor.class).calculateExecutionPlan(session, setup, goals.toArray(new String[goals.size()]));
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.MavenImpl_error_calc_build_plan, (Object)ex.getMessage()), (Throwable)ex));
        }
    }

    @Override
    public MojoExecution setupMojoExecution(MavenSession session, MavenProject project, MojoExecution execution) throws CoreException {
        MojoExecution clone = new MojoExecution(execution.getPlugin(), execution.getGoal(), execution.getExecutionId());
        clone.setMojoDescriptor(execution.getMojoDescriptor());
        if (execution.getConfiguration() != null) {
            clone.setConfiguration(new Xpp3Dom(execution.getConfiguration()));
        }
        clone.setLifecyclePhase(execution.getLifecyclePhase());
        LifecycleExecutionPlanCalculator executionPlanCalculator = this.lookup(LifecycleExecutionPlanCalculator.class);
        try {
            executionPlanCalculator.setupMojoExecution(session, project, clone);
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.MavenImpl_error_calc_build_plan, (Object)ex.getMessage()), (Throwable)ex));
        }
        return clone;
    }

    @Override
    public ArtifactRepository getLocalRepository() throws CoreException {
        try {
            String localRepositoryPath = this.getLocalRepositoryPath();
            if (localRepositoryPath != null) {
                return this.lookup(org.apache.maven.repository.RepositorySystem.class).createLocalRepository(new File(localRepositoryPath));
            }
            return this.lookup(org.apache.maven.repository.RepositorySystem.class).createLocalRepository(org.apache.maven.repository.RepositorySystem.defaultUserLocalRepository);
        }
        catch (InvalidRepositoryException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Settings getSettings() throws CoreException {
        return this.getSettings(false);
    }

    public synchronized Settings getSettings(boolean force_reload) throws CoreException {
        boolean reload;
        File userSettingsFile = null;
        if (this.mavenConfiguration.getUserSettingsFile() != null) {
            userSettingsFile = new File(this.mavenConfiguration.getUserSettingsFile());
        }
        boolean bl = reload = force_reload || this.settings == null;
        if (!reload && userSettingsFile != null) {
            boolean bl2 = reload = userSettingsFile.lastModified() != this.settings_timestamp || userSettingsFile.length() != this.settings_length;
        }
        if (reload) {
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setSystemProperties(System.getProperties());
            if (this.mavenConfiguration.getGlobalSettingsFile() != null) {
                request.setGlobalSettingsFile(new File(this.mavenConfiguration.getGlobalSettingsFile()));
            }
            if (userSettingsFile != null) {
                request.setUserSettingsFile(userSettingsFile);
            }
            try {
                this.settings = this.lookup(SettingsBuilder.class).build((SettingsBuildingRequest)request).getEffectiveSettings();
            }
            catch (SettingsBuildingException ex) {
                String msg = "Could not read settings.xml, assuming default values";
                log.error(msg, (Throwable)ex);
                this.settings = new Settings();
            }
            if (userSettingsFile != null) {
                this.settings_length = userSettingsFile.length();
                this.settings_timestamp = userSettingsFile.lastModified();
            }
        }
        return this.settings;
    }

    @Override
    public Settings buildSettings(String globalSettings, String userSettings) throws CoreException {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setGlobalSettingsFile(globalSettings != null ? new File(globalSettings) : null);
        request.setUserSettingsFile(userSettings != null ? new File(userSettings) : null);
        try {
            return this.lookup(SettingsBuilder.class).build((SettingsBuildingRequest)request).getEffectiveSettings();
        }
        catch (SettingsBuildingException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_read_settings, (Throwable)ex));
        }
    }

    @Override
    public void writeSettings(Settings settings, OutputStream out) throws CoreException {
        try {
            this.lookup(SettingsWriter.class).write(out, null, settings);
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_write_settings, (Throwable)ex));
        }
    }

    @Override
    public List<SettingsProblem> validateSettings(String settings) {
        ArrayList<SettingsProblem> problems = new ArrayList<SettingsProblem>();
        if (settings != null) {
            File settingsFile = new File(settings);
            if (settingsFile.canRead()) {
                DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
                request.setUserSettingsFile(settingsFile);
                try {
                    this.lookup(SettingsBuilder.class).build((SettingsBuildingRequest)request);
                }
                catch (SettingsBuildingException ex) {
                    problems.addAll(ex.getProblems());
                }
                catch (CoreException ex) {
                    problems.add((SettingsProblem)new DefaultSettingsProblem(ex.getMessage(), SettingsProblem.Severity.FATAL, settings, -1, -1, (Exception)((Object)ex)));
                }
            } else {
                problems.add((SettingsProblem)new DefaultSettingsProblem(NLS.bind((String)Messages.MavenImpl_error_read_settings2, (Object)settings), SettingsProblem.Severity.ERROR, settings, -1, -1, null));
            }
        }
        return problems;
    }

    @Override
    public void reloadSettings() throws CoreException {
        Settings settings = this.getSettings(true);
        for (ISettingsChangeListener listener : this.settingsListeners) {
            try {
                listener.settingsChanged(settings);
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Server decryptPassword(Server server) throws CoreException {
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
        SettingsDecryptionResult result = this.lookup(SettingsDecrypter.class).decrypt((SettingsDecryptionRequest)request);
        for (SettingsProblem problem : result.getProblems()) {
            log.warn(problem.getMessage(), (Throwable)problem.getException());
        }
        return result.getServer();
    }

    @Override
    public void mavenConfigurationChange(MavenConfigurationChangeEvent event) throws CoreException {
        if ("eclipse.m2.userSettingsFile".equals(event.getKey()) || "eclipse.m2.globalSettingsFile".equals(event.getKey())) {
            this.reloadSettings();
        }
    }

    @Override
    public Model readModel(InputStream in) throws CoreException {
        try {
            return this.lookup(ModelReader.class).read(in, null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_read_pom, (Throwable)e));
        }
    }

    @Override
    public Model readModel(File pomFile) throws CoreException {
        Model model;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(pomFile));
        try {
            model = this.readModel(is);
        }
        catch (Throwable throwable) {
            try {
                IOUtil.close((InputStream)is);
                throw throwable;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_read_pom, (Throwable)e));
            }
        }
        IOUtil.close((InputStream)is);
        return model;
    }

    @Override
    public void writeModel(Model model, OutputStream out) throws CoreException {
        try {
            this.lookup(ModelWriter.class).write(out, null, model);
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_write_pom, (Throwable)ex));
        }
    }

    @Override
    public MavenProject readProject(File pomFile, IProgressMonitor monitor) throws CoreException {
        try {
            MavenExecutionRequest request = this.createExecutionRequest(monitor);
            this.lookup(MavenExecutionRequestPopulator.class).populateDefaults(request);
            ProjectBuildingRequest configuration = request.getProjectBuildingRequest();
            configuration.setValidationLevel(0);
            configuration.setRepositorySession(this.createRepositorySession(request));
            return this.lookup(ProjectBuilder.class).build(pomFile, configuration).getProject();
        }
        catch (ProjectBuildingException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_read_project, (Throwable)ex));
        }
        catch (MavenExecutionRequestPopulationException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_read_project, (Throwable)ex));
        }
    }

    @Override
    public MavenExecutionResult readProject(MavenExecutionRequest request, IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        File pomFile = request.getPom();
        log.debug("Reading Maven project: {}", (Object)pomFile.getAbsoluteFile());
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            try {
                this.lookup(MavenExecutionRequestPopulator.class).populateDefaults(request);
                ProjectBuildingRequest configuration = request.getProjectBuildingRequest();
                configuration.setValidationLevel(0);
                configuration.setRepositorySession(this.createRepositorySession(request));
                ProjectBuildingResult projectBuildingResult = this.lookup(ProjectBuilder.class).build(pomFile, configuration);
                result.setProject(projectBuildingResult.getProject());
                result.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
            }
            catch (ProjectBuildingException ex) {
                if (ex.getResults() != null && ex.getResults().size() == 1) {
                    ProjectBuildingResult projectBuildingResult = (ProjectBuildingResult)ex.getResults().get(0);
                    result.setProject(projectBuildingResult.getProject());
                    result.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
                }
                result.addException((Throwable)ex);
                log.debug("Read Maven project: {} in {} ms", (Object)pomFile.getAbsoluteFile(), (Object)(System.currentTimeMillis() - start));
            }
            catch (MavenExecutionRequestPopulationException ex) {
                result.addException((Throwable)ex);
                log.debug("Read Maven project: {} in {} ms", (Object)pomFile.getAbsoluteFile(), (Object)(System.currentTimeMillis() - start));
            }
        }
        finally {
            log.debug("Read Maven project: {} in {} ms", (Object)pomFile.getAbsoluteFile(), (Object)(System.currentTimeMillis() - start));
        }
        return result;
    }

    @Override
    public void detachFromSession(MavenProject project) throws CoreException {
        project.getProjectBuildingRequest().setRepositorySession((RepositorySystemSession)this.lookup(ContextRepositorySystemSession.class));
    }

    @Override
    public MavenProject resolveParentProject(MavenExecutionRequest request, MavenProject child, IProgressMonitor monitor) throws CoreException {
        ProjectBuildingRequest configuration = request.getProjectBuildingRequest();
        configuration.setValidationLevel(0);
        configuration.setRepositorySession(this.createRepositorySession(request));
        try {
            configuration.setRemoteRepositories(child.getRemoteArtifactRepositories());
            File parentFile = child.getParentFile();
            if (parentFile != null) {
                return this.lookup(ProjectBuilder.class).build(parentFile, configuration).getProject();
            }
            Artifact parentArtifact = child.getParentArtifact();
            if (parentArtifact != null) {
                return this.lookup(ProjectBuilder.class).build(parentArtifact, configuration).getProject();
            }
        }
        catch (ProjectBuildingException ex) {
            log.error("Could not read parent project", (Throwable)ex);
        }
        return null;
    }

    @Override
    public Artifact resolve(String groupId, String artifactId, String version, String type, String classifier, List<ArtifactRepository> remoteRepositories, IProgressMonitor monitor) throws CoreException {
        Artifact artifact = this.lookup(org.apache.maven.repository.RepositorySystem.class).createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        return this.resolve(artifact, remoteRepositories, monitor);
    }

    public Artifact resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, IProgressMonitor monitor) throws CoreException {
        ArtifactResult result;
        if (remoteRepositories == null) {
            try {
                remoteRepositories = this.getArtifactRepositories();
            }
            catch (CoreException coreException) {
                remoteRepositories = Collections.emptyList();
            }
        }
        ArtifactRepository localRepository = this.getLocalRepository();
        RepositorySystem repoSystem = this.lookup(RepositorySystem.class);
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        session.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager(new LocalRepository(localRepository.getBasedir())));
        session.setTransferListener(this.createArtifactTransferListener(monitor));
        session.setConfigProperty("aether.connector.userAgent", (Object)MavenPluginActivator.getUserAgent());
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
        request.setRepositories(RepositoryUtils.toRepos(remoteRepositories));
        try {
            result = repoSystem.resolveArtifact((RepositorySystemSession)session, request);
        }
        catch (ArtifactResolutionException ex) {
            result = (ArtifactResult)ex.getResults().get(0);
        }
        this.setLastUpdated(localRepository, remoteRepositories, artifact);
        if (!result.isResolved()) {
            ArrayList<Status> members = new ArrayList<Status>();
            for (Exception e : result.getExceptions()) {
                if (e instanceof ArtifactNotFoundException) continue;
                members.add(new Status(4, "org.eclipse.m2e.core", -1, e.getMessage(), (Throwable)e));
            }
            if (members.isEmpty()) {
                members.add(new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.MavenImpl_error_missing, (Object)artifact), null));
            }
            IStatus[] newMembers = members.toArray(new IStatus[members.size()]);
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.m2e.core", -1, newMembers, NLS.bind((String)Messages.MavenImpl_error_resolve, (Object)artifact.toString()), null));
        }
        artifact.selectVersion(result.getArtifact().getVersion());
        artifact.setFile(result.getArtifact().getFile());
        artifact.setResolved(true);
        return artifact;
    }

    public Artifact resolvePluginArtifact(Plugin plugin, List<ArtifactRepository> remoteRepositories, IProgressMonitor monitor) throws CoreException {
        Artifact artifact = this.lookup(org.apache.maven.repository.RepositorySystem.class).createPluginArtifact(plugin);
        return this.resolve(artifact, remoteRepositories, monitor);
    }

    @Override
    public String getArtifactPath(ArtifactRepository repository, String groupId, String artifactId, String version, String type, String classifier) throws CoreException {
        Artifact artifact = this.lookup(org.apache.maven.repository.RepositorySystem.class).createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        return repository.pathOf(artifact);
    }

    private void setLastUpdated(ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, Artifact artifact) throws CoreException {
        Properties lastUpdated = this.loadLastUpdated(localRepository, artifact);
        String timestamp = Long.toString(System.currentTimeMillis());
        for (ArtifactRepository repository : remoteRepositories) {
            lastUpdated.setProperty(this.getLastUpdatedKey(repository, artifact), timestamp);
        }
        File lastUpdatedFile = this.getLastUpdatedFile(localRepository, artifact);
        try {
            lastUpdatedFile.getParentFile().mkdirs();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(lastUpdatedFile));
            try {
                lastUpdated.store(os, null);
            }
            finally {
                IOUtil.close((OutputStream)os);
            }
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_write_lastUpdated, (Throwable)ex));
        }
    }

    @Override
    public boolean isUnavailable(String groupId, String artifactId, String version, String type, String classifier, List<ArtifactRepository> remoteRepositories) throws CoreException {
        Artifact artifact = this.lookup(org.apache.maven.repository.RepositorySystem.class).createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        ArtifactRepository localRepository = this.getLocalRepository();
        File artifactFile = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
        if (artifactFile.canRead()) {
            return false;
        }
        if (remoteRepositories == null || remoteRepositories.isEmpty()) {
            return true;
        }
        Properties lastUpdated = this.loadLastUpdated(localRepository, artifact);
        for (ArtifactRepository repository : remoteRepositories) {
            String timestamp = lastUpdated.getProperty(this.getLastUpdatedKey(repository, artifact));
            if (timestamp != null) continue;
            return false;
        }
        return true;
    }

    private String getLastUpdatedKey(ArtifactRepository repository, Artifact artifact) {
        StringBuilder key = new StringBuilder();
        key.append(repository.getId());
        if (repository.getAuthentication() != null) {
            key.append('|').append(repository.getAuthentication().getUsername());
        }
        key.append('|').append(repository.getUrl());
        key.append('|').append(artifact.getClassifier());
        return key.toString();
    }

    private Properties loadLastUpdated(ArtifactRepository localRepository, Artifact artifact) throws CoreException {
        Properties lastUpdated = new Properties();
        File lastUpdatedFile = this.getLastUpdatedFile(localRepository, artifact);
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(lastUpdatedFile));
            try {
                lastUpdated.load(is);
            }
            finally {
                IOUtil.close((InputStream)is);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_read_lastUpdated, (Throwable)ex));
        }
        return lastUpdated;
    }

    private File getLastUpdatedFile(ArtifactRepository localRepository, Artifact artifact) {
        return new File(localRepository.getBasedir(), String.valueOf(this.basePathOf(localRepository, artifact)) + "/" + "m2e-lastUpdated.properties");
    }

    private String basePathOf(ArtifactRepository repository, Artifact artifact) {
        StringBuilder path = new StringBuilder(128);
        path.append(this.formatAsDirectory(artifact.getGroupId())).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getBaseVersion()).append('/');
        return path.toString();
    }

    private String formatAsDirectory(String directory) {
        return directory.replace('.', '/');
    }

    @Override
    public <T> T getMojoParameterValue(MavenSession session, MojoExecution mojoExecution, String parameter, Class<T> asType) throws CoreException {
        PlexusConfiguration configuration;
        ConfigurationConverter typeConverter;
        PluginParameterExpressionEvaluator expressionEvaluator;
        ClassRealm pluginRealm;
        MojoDescriptor mojoDescriptor;
        block5: {
            Xpp3Dom dom;
            block4: {
                try {
                    mojoDescriptor = mojoExecution.getMojoDescriptor();
                    pluginRealm = this.lookup(BuildPluginManager.class).getPluginRealm(session, mojoDescriptor.getPluginDescriptor());
                    expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
                    typeConverter = this.converterLookup.lookupConverterForType(asType);
                    dom = mojoExecution.getConfiguration();
                    if (dom != null) break block4;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.MavenImpl_error_param_for_execution, (Object)parameter, (Object)mojoExecution.getExecutionId()), (Throwable)e));
                }
                return null;
            }
            XmlPlexusConfiguration pomConfiguration = new XmlPlexusConfiguration(dom);
            configuration = pomConfiguration.getChild(parameter);
            if (configuration != null) break block5;
            return null;
        }
        Object value = typeConverter.fromConfiguration(this.converterLookup, configuration, asType, mojoDescriptor.getImplementationClass(), (ClassLoader)pluginRealm, (ExpressionEvaluator)expressionEvaluator, null);
        return asType.cast(value);
    }

    @Override
    public <T> T getMojoParameterValue(String parameter, Class<T> type, MavenSession session, Plugin plugin, ConfigurationContainer configuration, String goal) throws CoreException {
        Xpp3Dom config = (Xpp3Dom)configuration.getConfiguration();
        config = config != null ? config.getChild(parameter) : null;
        XmlPlexusConfiguration paramConfig = null;
        if (config == null) {
            MojoDescriptor mojoDescriptor;
            try {
                mojoDescriptor = this.lookup(BuildPluginManager.class).getMojoDescriptor(plugin, goal, session.getCurrentProject().getRemotePluginRepositories(), session.getRepositorySession());
            }
            catch (PluginNotFoundException ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_param, (Throwable)ex));
            }
            catch (PluginResolutionException ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_param, (Throwable)ex));
            }
            catch (PluginDescriptorParsingException ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_param, (Throwable)ex));
            }
            catch (MojoNotFoundException ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_param, (Throwable)ex));
            }
            catch (InvalidPluginDescriptorException ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_param, (Throwable)ex));
            }
            PlexusConfiguration defaultConfig = mojoDescriptor.getMojoConfiguration();
            if (defaultConfig != null) {
                paramConfig = defaultConfig.getChild(parameter, false);
            }
        } else {
            paramConfig = new XmlPlexusConfiguration(config);
        }
        if (paramConfig == null) {
            return null;
        }
        try {
            MojoExecution mojoExecution = new MojoExecution(plugin, goal, "default");
            PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
            ConfigurationConverter typeConverter = this.converterLookup.lookupConverterForType(type);
            Object value = typeConverter.fromConfiguration(this.converterLookup, (PlexusConfiguration)paramConfig, type, Object.class, (ClassLoader)this.plexus.getContainerRealm(), (ExpressionEvaluator)expressionEvaluator, null);
            return type.cast(value);
        }
        catch (ComponentConfigurationException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_param, (Throwable)ex));
        }
        catch (ClassCastException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_param, (Throwable)ex));
        }
    }

    public void releaseExtensionsRealm(MavenProject project) {
        ClassRealm realm = project.getClassRealm();
        if (realm != null && realm != this.plexus.getContainerRealm()) {
            ClassWorld world = this.plexus.getClassWorld();
            try {
                world.disposeRealm(realm.getId());
            }
            catch (NoSuchRealmException ex) {
                log.error("Could not dispose of project extensions class realm", (Throwable)ex);
            }
        }
    }

    @Override
    public ArtifactRepository createArtifactRepository(String id, String url) throws CoreException {
        ArtifactRepository repo;
        Repository repository = new Repository();
        repository.setId(id);
        repository.setUrl(url);
        repository.setLayout("default");
        try {
            repo = this.lookup(org.apache.maven.repository.RepositorySystem.class).buildArtifactRepository(repository);
            ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>(Arrays.asList(repo));
            this.injectSettings(repos);
        }
        catch (InvalidRepositoryException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_create_repo, (Throwable)ex));
        }
        return repo;
    }

    @Override
    public List<ArtifactRepository> getArtifactRepositories() throws CoreException {
        return this.getArtifactRepositories(true);
    }

    @Override
    public List<ArtifactRepository> getArtifactRepositories(boolean injectSettings) throws CoreException {
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        for (org.apache.maven.model.Profile profile : this.getActiveProfiles()) {
            this.addArtifactRepositories(repositories, profile.getRepositories());
        }
        this.addDefaultRepository(repositories);
        if (injectSettings) {
            this.injectSettings(repositories);
        }
        return this.removeDuplicateRepositories(repositories);
    }

    private List<ArtifactRepository> removeDuplicateRepositories(ArrayList<ArtifactRepository> repositories) {
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        HashSet<String> keys = new HashSet<String>();
        for (ArtifactRepository repository : repositories) {
            StringBuilder key = new StringBuilder();
            if (repository.getId() != null) {
                key.append(repository.getId());
            }
            key.append(':').append(repository.getUrl()).append(':');
            if (repository.getAuthentication() != null && repository.getAuthentication().getUsername() != null) {
                key.append(repository.getAuthentication().getUsername());
            }
            if (!keys.add(key.toString())) continue;
            result.add(repository);
        }
        return result;
    }

    private void injectSettings(ArrayList<ArtifactRepository> repositories) throws CoreException {
        Settings settings = this.getSettings();
        this.lookup(org.apache.maven.repository.RepositorySystem.class).injectMirror(repositories, this.getMirrors());
        this.lookup(org.apache.maven.repository.RepositorySystem.class).injectProxy(repositories, settings.getProxies());
        this.lookup(org.apache.maven.repository.RepositorySystem.class).injectAuthentication(repositories, settings.getServers());
    }

    private void addDefaultRepository(ArrayList<ArtifactRepository> repositories) throws CoreException {
        for (ArtifactRepository repository : repositories) {
            if (!"central".equals(repository.getId())) continue;
            return;
        }
        try {
            repositories.add(0, this.lookup(org.apache.maven.repository.RepositorySystem.class).createDefaultRemoteRepository());
        }
        catch (InvalidRepositoryException ex) {
            log.error("Unexpected exception", (Throwable)ex);
        }
    }

    private void addArtifactRepositories(ArrayList<ArtifactRepository> artifactRepositories, List<Repository> repositories) throws CoreException {
        for (Repository repository : repositories) {
            try {
                ArtifactRepository artifactRepository = this.lookup(org.apache.maven.repository.RepositorySystem.class).buildArtifactRepository(repository);
                artifactRepositories.add(artifactRepository);
            }
            catch (InvalidRepositoryException ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_read_settings, (Throwable)ex));
            }
        }
    }

    private List<org.apache.maven.model.Profile> getActiveProfiles() throws CoreException {
        Settings settings = this.getSettings();
        List activeProfilesIds = settings.getActiveProfiles();
        ArrayList<org.apache.maven.model.Profile> activeProfiles = new ArrayList<org.apache.maven.model.Profile>();
        for (Profile settingsProfile : settings.getProfiles()) {
            if ((settingsProfile.getActivation() == null || !settingsProfile.getActivation().isActiveByDefault()) && !activeProfilesIds.contains(settingsProfile.getId())) continue;
            org.apache.maven.model.Profile profile = SettingsUtils.convertFromSettingsProfile((Profile)settingsProfile);
            activeProfiles.add(profile);
        }
        return activeProfiles;
    }

    @Override
    public List<ArtifactRepository> getPluginArtifactRepositories() throws CoreException {
        return this.getPluginArtifactRepositories(true);
    }

    @Override
    public List<ArtifactRepository> getPluginArtifactRepositories(boolean injectSettings) throws CoreException {
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        for (org.apache.maven.model.Profile profile : this.getActiveProfiles()) {
            this.addArtifactRepositories(repositories, profile.getPluginRepositories());
        }
        this.addDefaultRepository(repositories);
        if (injectSettings) {
            this.injectSettings(repositories);
        }
        return this.removeDuplicateRepositories(repositories);
    }

    @Override
    public Mirror getMirror(ArtifactRepository repo) throws CoreException {
        MavenExecutionRequest request = this.createExecutionRequest((IProgressMonitor)new NullProgressMonitor());
        this.populateDefaults(request);
        return this.lookup(org.apache.maven.repository.RepositorySystem.class).getMirror(repo, request.getMirrors());
    }

    @Override
    public void populateDefaults(MavenExecutionRequest request) throws CoreException {
        try {
            this.lookup(MavenExecutionRequestPopulator.class).populateDefaults(request);
        }
        catch (MavenExecutionRequestPopulationException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_read_config, (Throwable)ex));
        }
    }

    @Override
    public List<Mirror> getMirrors() throws CoreException {
        MavenExecutionRequest request = this.createExecutionRequest(null);
        this.populateDefaults(request);
        return request.getMirrors();
    }

    @Override
    public void addSettingsChangeListener(ISettingsChangeListener listener) {
        this.settingsListeners.add(listener);
    }

    @Override
    public void removeSettingsChangeListener(ISettingsChangeListener listener) {
        this.settingsListeners.remove(listener);
    }

    @Override
    public void addLocalRepositoryListener(ILocalRepositoryListener listener) {
        this.localRepositoryListeners.add(listener);
    }

    @Override
    public void removeLocalRepositoryListener(ILocalRepositoryListener listener) {
        this.localRepositoryListeners.remove(listener);
    }

    public List<ILocalRepositoryListener> getLocalRepositoryListeners() {
        return this.localRepositoryListeners;
    }

    @Override
    public WagonTransferListenerAdapter createTransferListener(IProgressMonitor monitor) {
        return new WagonTransferListenerAdapter(this, monitor);
    }

    public TransferListener createArtifactTransferListener(IProgressMonitor monitor) {
        return new ArtifactTransferListenerAdapter(this, monitor);
    }

    public synchronized PlexusContainer getPlexusContainer() throws CoreException {
        if (this.plexus == null) {
            try {
                this.plexus = MavenImpl.newPlexusContainer();
                this.plexus.setLoggerManager((LoggerManager)new EclipseLoggerManager(this.mavenConfiguration));
            }
            catch (PlexusContainerException ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_init_maven, (Throwable)ex));
            }
        }
        return this.plexus;
    }

    @Override
    public ProxyInfo getProxyInfo(String protocol) throws CoreException {
        Settings settings = this.getSettings();
        for (Proxy proxy : settings.getProxies()) {
            if (!proxy.isActive() || !protocol.equalsIgnoreCase(proxy.getProtocol())) continue;
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setType(proxy.getProtocol());
            proxyInfo.setHost(proxy.getHost());
            proxyInfo.setPort(proxy.getPort());
            proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
            proxyInfo.setUserName(proxy.getUsername());
            proxyInfo.setPassword(proxy.getPassword());
            return proxyInfo;
        }
        return null;
    }

    @Override
    public List<MavenProject> getSortedProjects(List<MavenProject> projects) throws CoreException {
        try {
            ProjectSorter rm = new ProjectSorter(projects);
            return rm.getSortedProjects();
        }
        catch (CycleDetectedException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", Messages.MavenImpl_error_sort, (Throwable)ex));
        }
        catch (DuplicateProjectException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", Messages.MavenImpl_error_sort, (Throwable)ex));
        }
    }

    @Override
    public String resolvePluginVersion(String groupId, String artifactId, MavenSession session) throws CoreException {
        Plugin plugin = new Plugin();
        plugin.setGroupId(groupId);
        plugin.setArtifactId(artifactId);
        DefaultPluginVersionRequest request = new DefaultPluginVersionRequest(plugin, session);
        try {
            return this.lookup(PluginVersionResolver.class).resolve((PluginVersionRequest)request).getVersion();
        }
        catch (PluginVersionResolutionException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, ex.getMessage(), (Throwable)ex));
        }
    }

    private <T> T lookup(Class<T> clazz) throws CoreException {
        try {
            return (T)this.getPlexusContainer().lookup(clazz);
        }
        catch (ComponentLookupException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_lookup, (Throwable)ex));
        }
    }

    private static DefaultPlexusContainer newPlexusContainer() throws PlexusContainerException {
        ContainerConfiguration mavenCoreCC = new DefaultContainerConfiguration().setClassWorld(new ClassWorld(MAVEN_CORE_REALM_ID, ClassWorld.class.getClassLoader())).setName("mavenCore");
        mavenCoreCC.setAutoWiring(true);
        return new DefaultPlexusContainer(mavenCoreCC, new Module[]{new ExtensionModule()});
    }

    public synchronized void disposeContainer() {
        if (this.plexus != null) {
            this.plexus.dispose();
        }
    }

    @Override
    public ClassLoader getProjectRealm(MavenProject project) {
        ClassRealm classLoader = project.getClassRealm();
        if (classLoader == null) {
            classLoader = this.plexus.getContainerRealm();
        }
        return classLoader;
    }

    public void interpolateModel(MavenProject project, Model model) throws CoreException {
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setUserProperties(project.getProperties());
        ModelProblemCollector problems = new ModelProblemCollector(){

            public void add(ModelProblem.Severity severity, String message, InputLocation location, Exception cause) {
            }
        };
        this.lookup(ModelInterpolator.class).interpolateModel(model, project.getBasedir(), (ModelBuildingRequest)request, problems);
    }
}

