/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project.configurator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.builder.InternalBuildParticipant;
import org.eclipse.m2e.core.internal.builder.MavenBuilderImpl;
import org.eclipse.m2e.core.internal.embedder.MavenProjectMutableState;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant2;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;

public abstract class AbstractLifecycleMapping
implements ILifecycleMapping {
    private String name;
    protected String id;
    private static final MavenBuilderImpl builder = new MavenBuilderImpl(){

        protected boolean isApplicable(InternalBuildParticipant participant, int kind, IResourceDelta delta) {
            return true;
        }
    };

    public void configure(ProjectConfigurationRequest request, IProgressMonitor mon) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)5);
        try {
            IFolder container;
            String directory;
            MavenPlugin.getProjectConfigurationManager().addMavenBuilder(request.getProject(), null, (IProgressMonitor)monitor.newChild(1));
            IMavenProjectFacade projectFacade = request.getMavenProjectFacade();
            MavenProject mavenProject = request.getMavenProject();
            Build build = mavenProject.getBuild();
            if (build != null && (directory = build.getDirectory()) != null && (container = projectFacade.getProject().getFolder(projectFacade.getProjectRelativePath(directory))) != null) {
                if (!container.exists() && container instanceof IFolder) {
                    M2EUtils.createFolder(container, true, (IProgressMonitor)monitor.newChild(1));
                } else {
                    container.setDerived(true, (IProgressMonitor)monitor.newChild(1));
                }
            }
            MavenProjectMutableState snapshot = MavenProjectMutableState.takeSnapshot(mavenProject);
            try {
                LinkedHashMap<MojoExecutionKey, List<AbstractBuildParticipant>> participants = new LinkedHashMap<MojoExecutionKey, List<AbstractBuildParticipant>>();
                for (Map.Entry<MojoExecutionKey, List<AbstractBuildParticipant>> entry : this.getBuildParticipants(projectFacade, (IProgressMonitor)monitor).entrySet()) {
                    ArrayList<AbstractBuildParticipant> participants2 = new ArrayList<AbstractBuildParticipant>();
                    for (AbstractBuildParticipant participant : entry.getValue()) {
                        if (!(participant instanceof AbstractBuildParticipant2)) continue;
                        participants2.add(participant);
                    }
                    if (participants2.isEmpty()) continue;
                    participants.put(entry.getKey(), participants2);
                }
                builder.build(request.getMavenSession(), projectFacade, 65536, Collections.<String, String>emptyMap(), participants, (IProgressMonitor)monitor);
                for (AbstractProjectConfigurator configurator : this.getProjectConfigurators(projectFacade, (IProgressMonitor)monitor.newChild(1))) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    configurator.configure(request, (IProgressMonitor)monitor.newChild(1));
                }
            }
            finally {
                snapshot.restore(mavenProject);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void unconfigure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade projectFacade = request.getMavenProjectFacade();
        for (AbstractProjectConfigurator configurator : this.getProjectConfigurators(projectFacade, monitor)) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            configurator.unconfigure(request, monitor);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public abstract boolean hasLifecycleMappingChanged(IMavenProjectFacade var1, ILifecycleMappingConfiguration var2, IProgressMonitor var3);
}

