/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.app;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.app.SocketUtil;
import org.eclipse.m2m.qvt.oml.debug.core.app.VMProvider;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTOVirtualMachineShell;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMTerminateEvent;

class VMEventDispatcher {
    private VMProvider fVMProvider;
    private Thread fDispatchThread;
    private DispatchJob fDispatchJob;
    private TerminationListener fTerminationListener;

    VMEventDispatcher(VMProvider vmProvider, int port, TerminationListener listener) {
        this.fDispatchJob = new DispatchJob(port);
        this.fTerminationListener = listener;
        this.fVMProvider = vmProvider;
    }

    protected void terminated() {
        if (this.fTerminationListener != null) {
            try {
                this.fTerminationListener.terminated();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        VMEventDispatcher vMEventDispatcher = this;
        synchronized (vMEventDispatcher) {
            if (this.fDispatchThread != null) {
                throw new IllegalStateException("Dispatcher already started");
            }
            this.fDispatchThread = new Thread((Runnable)this.fDispatchJob, "QVTO Srv-VMEvent dispatch");
        }
        this.fDispatchThread.setDaemon(true);
        this.fDispatchThread.start();
        this.fDispatchJob.waitToReachAccept();
        QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "VM Server Event dispatcher ready");
    }

    boolean joinTermination(long timeOut) {
        try {
            this.fDispatchThread.join(timeOut);
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        return !this.fDispatchThread.isAlive();
    }

    private final class DispatchJob
    implements Runnable {
        private final Object startLock = new Object();
        private final int fPort;
        private boolean fReady;
        private boolean fRunning;

        DispatchJob(int port) {
            this.fPort = port;
            this.fReady = false;
            this.fRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block17: {
                QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "VM Server Event Dispatcher started");
                ObjectOutputStream eventStream = null;
                ServerSocket serverSocket = null;
                Socket eventSocket = null;
                try {
                    try {
                        Object object = this.startLock;
                        synchronized (object) {
                            this.fReady = true;
                            this.startLock.notify();
                        }
                        serverSocket = new ServerSocket(this.fPort);
                        eventSocket = serverSocket.accept();
                        QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "VM Server Event Dispatcher accepted connection");
                        eventStream = new ObjectOutputStream(eventSocket.getOutputStream());
                        this.doRun(eventStream);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        QVTODebugCore.log(e);
                        if (eventStream != null) {
                            SocketUtil.close(eventStream);
                        }
                        if (eventSocket != null) {
                            SocketUtil.close(eventSocket);
                        }
                        if (serverSocket != null) {
                            SocketUtil.close(serverSocket);
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (eventStream != null) {
                        SocketUtil.close(eventStream);
                    }
                    if (eventSocket != null) {
                        SocketUtil.close(eventSocket);
                    }
                    if (serverSocket != null) {
                        SocketUtil.close(serverSocket);
                    }
                    throw throwable;
                }
                if (eventStream != null) {
                    SocketUtil.close(eventStream);
                }
                if (eventSocket != null) {
                    SocketUtil.close(eventSocket);
                }
                if (serverSocket != null) {
                    SocketUtil.close(serverSocket);
                }
            }
        }

        private void doRun(ObjectOutputStream eventStream) {
            IQVTOVirtualMachineShell vm;
            try {
                vm = VMEventDispatcher.this.fVMProvider.getVM();
            }
            catch (CoreException coreException) {
                QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "VM Server Event dispatcher exiting, VM failed not available");
                return;
            }
            this.fRunning = true;
            while (this.fRunning) {
                VMEvent event = null;
                try {
                    event = vm.readVMEvent();
                }
                catch (IOException iOException) {
                    QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "VM Server Event dispatcher interrupted");
                }
                if (event != null) {
                    QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "VM Server - sending VM event: " + event);
                    try {
                        eventStream.writeObject(event);
                        eventStream.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (event != null && !(event instanceof VMTerminateEvent)) continue;
                this.fRunning = false;
                this.fReady = false;
                VMEventDispatcher.this.terminated();
            }
            QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "VM Server Event dispather terminated");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitToReachAccept() {
            Object object = this.startLock;
            synchronized (object) {
                while (true) {
                    if (this.fReady) {
                        return;
                    }
                    try {
                        this.startLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    static interface TerminationListener {
        public void terminated();
    }
}

