/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.launch.impl;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.facet.util.emf.core.serialization.ISerializationRegistry;
import org.eclipse.emf.facet.util.emf.core.serialization.ISerializer;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.Activator;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.launch.LaunchFactory;
import org.eclipse.modisco.infra.discovery.launch.LaunchPackage;
import org.eclipse.modisco.infra.discovery.launch.ParameterValue;
import org.eclipse.modisco.infra.discovery.launch.impl.LaunchConfigurationImpl;
import org.eclipse.modisco.infra.discovery.launch.impl.ParameterValueImpl;

public class LaunchFactoryImpl
extends EFactoryImpl
implements LaunchFactory {
    public static LaunchFactory init() {
        try {
            LaunchFactory theLaunchFactory = (LaunchFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/MoDisco/Discovery/0.1.incubation/discovery/launch");
            if (theLaunchFactory != null) {
                return theLaunchFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new LaunchFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createLaunchConfiguration();
            }
            case 1: {
                return this.createParameterValue();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public LaunchConfiguration createLaunchConfiguration() {
        LaunchConfigurationImpl launchConfiguration = new LaunchConfigurationImpl();
        return launchConfiguration;
    }

    public ParameterValue createParameterValue() {
        ParameterValueImpl parameterValue = new ParameterValueImpl();
        return parameterValue;
    }

    public Object createValueDataTypeFromString(EDataType eDataType, String initialValue) {
        block5: {
            if (!"null".equals(initialValue)) break block5;
            return null;
        }
        try {
            int colonPos = initialValue.indexOf(58);
            if (colonPos == -1) {
                throw new IllegalArgumentException("invalid serialization format");
            }
            String type = initialValue.substring(0, colonPos);
            String strValue = initialValue.substring(colonPos + 1);
            ISerializer serializer = ISerializationRegistry.INSTANCE.getSerializerFor(type);
            if (serializer != null) {
                Object value = serializer.deserialize(strValue);
                return value;
            }
            MoDiscoLogger.logError((String)("deserialization of type " + type + " is not implemented."), (Plugin)Activator.getDefault());
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)("Error deserializing: " + initialValue), (Plugin)Activator.getDefault());
        }
        return null;
    }

    public String convertValueDataTypeToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return "null";
        }
        ISerializer serializer = ISerializationRegistry.INSTANCE.getSerializerFor(instanceValue.getClass());
        if (serializer != null) {
            return String.valueOf(serializer.getType().getName()) + ":" + serializer.serialize(instanceValue);
        }
        MoDiscoLogger.logError((String)("serialization of type " + instanceValue.getClass().getName() + " is not implemented."), (Plugin)Activator.getDefault());
        return "null";
    }

    public LaunchPackage getLaunchPackage() {
        return (LaunchPackage)this.getEPackage();
    }

    @Deprecated
    public static LaunchPackage getPackage() {
        return LaunchPackage.eINSTANCE;
    }
}

