/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.http.core;

import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationException;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.commons.repositories.http.core.HttpUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonHttpOperation<T> {
    private final CommonHttpClient client;

    public CommonHttpOperation(CommonHttpClient client) {
        this.client = client;
    }

    public CommonHttpOperation(CommonHttpClient client, HttpRequestBase request) {
        this.client = client;
    }

    protected void authenticate(IOperationMonitor monitor) throws IOException {
        this.client.authenticate(monitor);
    }

    protected HttpGet createGetRequest(String requestPath) {
        return new HttpGet(requestPath);
    }

    protected HttpHead createHeadRequest(String requestPath) {
        return new HttpHead(requestPath);
    }

    protected HttpPost createPostRequest(String requestPath) {
        return new HttpPost(requestPath);
    }

    public CommonHttpResponse execute(HttpRequestBase request, IOperationMonitor monitor) throws IOException {
        monitor = OperationUtil.convert((IProgressMonitor)monitor);
        try {
            return this.executeOnce(request, monitor);
        }
        catch (AuthenticationException e) {
            boolean requestCredentials = !e.shouldRetry();
            this.handleAuthenticationError(request, e, monitor, requestCredentials);
            try {
                return this.executeOnce(request, monitor);
            }
            catch (AuthenticationException e2) {
                if (requestCredentials) {
                    this.invalidateAuthentication(e2, monitor);
                    throw e2;
                }
                this.handleAuthenticationError(request, e2, monitor, true);
                return this.executeOnce(request, monitor);
            }
        }
    }

    private void handleAuthenticationError(HttpRequestBase request, AuthenticationException e, IOperationMonitor monitor, boolean requestCredentials) throws AuthenticationException {
        this.invalidateAuthentication(e, monitor);
        if (!this.isRepeatable()) {
            throw e;
        }
        if (requestCredentials) {
            try {
                this.requestCredentials(e.getRequest(), monitor);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw e;
            }
        }
    }

    protected boolean isRepeatable() {
        return true;
    }

    protected CommonHttpResponse executeOnce(HttpRequestBase request, IOperationMonitor monitor) throws IOException {
        if (this.needsAuthentication()) {
            this.authenticate(monitor);
        }
        HttpResponse response = this.client.execute(request, monitor);
        try {
            this.validate(response, monitor);
            return new CommonHttpResponse((HttpRequest)request, response);
        }
        catch (IOException e) {
            HttpUtil.release((HttpRequest)request, response, (IProgressMonitor)monitor);
            throw e;
        }
        catch (RuntimeException e) {
            HttpUtil.release((HttpRequest)request, response, (IProgressMonitor)monitor);
            throw e;
        }
    }

    protected final CommonHttpClient getClient() {
        return this.client;
    }

    protected boolean needsAuthentication() {
        return this.client.needsAuthentication();
    }

    protected <T extends AuthenticationCredentials> T requestCredentials(AuthenticationRequest<AuthenticationType<T>> request, IOperationMonitor monitor) {
        return this.client.requestCredentials(request, (IProgressMonitor)monitor);
    }

    protected void invalidateAuthentication(AuthenticationException e, IOperationMonitor monitor) {
        this.client.setAuthenticated(false);
    }

    protected void validate(HttpResponse response, IOperationMonitor monitor) throws AuthenticationException {
        this.client.validate(response, (IProgressMonitor)monitor);
    }
}

