/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.http.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.net.AuthenticatedProxy;
import org.eclipse.mylyn.commons.core.net.NetUtil;
import org.eclipse.mylyn.commons.core.operations.MonitoredOperation;
import org.eclipse.mylyn.commons.core.operations.Operation;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.internal.commons.repositories.http.core.IdleConnectionMonitorThread;
import org.eclipse.mylyn.internal.commons.repositories.http.core.PollingProtocolSocketFactory;
import org.eclipse.mylyn.internal.commons.repositories.http.core.PollingSslProtocolSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtil {
    private static final int BUFFER_SIZE = 4096;
    private static final long CLOSE_TIMEOUT = -1L;
    private static final int CONNECTION_TIMEOUT_INTERVAL = 30000;
    private static final int CONNNECT_TIMEOUT = 60000;
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static final int POLL_INTERVAL = 500;
    private static final int SOCKET_TIMEOUT = 180000;
    private static final int POLL_ATTEMPTS = 360;
    private static SchemeSocketFactory socketFactory;
    private static SchemeSocketFactory sslSocketFactory;
    static final String ID_PLUGIN = "org.eclipse.mylyn.commons.repositories.http";
    private static ThreadSafeClientConnManager connectionManager;

    static {
        CoreUtil.initializeLoggingSettings();
        socketFactory = new PollingProtocolSocketFactory();
        sslSocketFactory = new PollingSslProtocolSocketFactory();
    }

    public static void configureClient(AbstractHttpClient client, String userAgent) {
        HttpClientParams.setCookiePolicy((HttpParams)client.getParams(), (String)"best-match");
        HttpProtocolParams.setUserAgent((HttpParams)client.getParams(), (String)userAgent);
        HttpProtocolParams.setUseExpectContinue((HttpParams)client.getParams(), (boolean)true);
        client.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", true);
        HttpConnectionParams.setConnectionTimeout((HttpParams)client.getParams(), (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)client.getParams(), (int)180000);
    }

    public static void configureAuthentication(AbstractHttpClient client, RepositoryLocation location) {
        UserCredentials credentials = (UserCredentials)location.getCredentials(AuthenticationType.HTTP);
        if (credentials != null) {
            HttpUtil.configureAuthentication(client, location, credentials);
        }
    }

    public static void configureAuthentication(AbstractHttpClient client, RepositoryLocation location, UserCredentials credentials) {
        Assert.isNotNull((Object)client);
        Assert.isNotNull((Object)location);
        Assert.isNotNull((Object)credentials);
        String url = location.getUrl();
        Assert.isNotNull((Object)url, (String)"The location url must not be null");
        String host = NetUtil.getHost((String)url);
        int port = NetUtil.getPort((String)url);
        NTCredentials ntlmCredentials = HttpUtil.getNtCredentials(credentials, null);
        if (ntlmCredentials != null) {
            AuthScope authScopeNtlm = new AuthScope(host, port, AuthScope.ANY_REALM, "NTLM");
            client.getCredentialsProvider().setCredentials(authScopeNtlm, (Credentials)ntlmCredentials);
        }
        UsernamePasswordCredentials usernamePasswordCredentials = HttpUtil.getUserNamePasswordCredentials(credentials);
        AuthScope authScopeAny = new AuthScope(host, port, AuthScope.ANY_REALM);
        client.getCredentialsProvider().setCredentials(authScopeAny, (Credentials)usernamePasswordCredentials);
    }

    public static HttpHost createHost(HttpRequestBase method) {
        URI uri = method.getURI();
        return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }

    public static HttpResponse execute(AbstractHttpClient client, HttpContext context, HttpRequestBase method, IProgressMonitor monitor) throws IOException {
        return HttpUtil.execute(client, HttpUtil.createHost(method), context, method, monitor);
    }

    public static HttpResponse execute(final AbstractHttpClient client, final HttpHost host, final HttpContext context, final HttpRequestBase method, IProgressMonitor monitor) throws IOException {
        Assert.isNotNull((Object)client);
        Assert.isNotNull((Object)method);
        monitor = OperationUtil.convert((IProgressMonitor)monitor);
        MonitoredOperation<HttpResponse> executor = new MonitoredOperation<HttpResponse>(monitor){

            public void abort() {
                super.abort();
                method.abort();
            }

            public HttpResponse execute() throws Exception {
                return client.execute(host, (HttpRequest)method, context);
            }
        };
        return (HttpResponse)HttpUtil.executeInternal(monitor, executor);
    }

    public static NTCredentials getNtCredentials(UserCredentials credentials, String workstation) {
        String username = credentials.getUserName();
        int i = username.indexOf("\\");
        if (i > 0 && i < username.length() - 1) {
            return new NTCredentials(username.substring(i + 1), credentials.getPassword(), workstation, username.substring(0, i));
        }
        return null;
    }

    public static UsernamePasswordCredentials getUserNamePasswordCredentials(UserCredentials credentials) {
        return new UsernamePasswordCredentials(credentials.getUserName(), credentials.getPassword());
    }

    public static InputStream getResponseBodyAsStream(HttpEntity entity, IProgressMonitor monitor) throws IOException {
        monitor = OperationUtil.convert((IProgressMonitor)monitor);
        return entity.getContent();
    }

    public static SchemeRegistry getSchemeRegistry() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, socketFactory));
        schemeRegistry.register(new Scheme("https", 443, sslSocketFactory));
        return schemeRegistry;
    }

    public static void configureProxy(AbstractHttpClient client, RepositoryLocation location) {
        Assert.isNotNull((Object)client);
        Assert.isNotNull((Object)location);
        String url = location.getUrl();
        Assert.isNotNull((Object)url, (String)"The location url must not be null");
        String host = NetUtil.getHost((String)url);
        Proxy proxy = NetUtil.isUrlHttps((String)url) ? location.getProxyForHost(host, "HTTPS") : location.getProxyForHost(host, "HTTP");
        if (proxy != null && !Proxy.NO_PROXY.equals(proxy)) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            client.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(address.getHostName(), address.getPort()));
            if (proxy instanceof AuthenticatedProxy) {
                AuthenticatedProxy authProxy = (AuthenticatedProxy)proxy;
                Credentials credentials = HttpUtil.getCredentials(authProxy.getUserName(), authProxy.getPassword(), address.getAddress(), false);
                if (credentials instanceof NTCredentials) {
                    AuthScope proxyAuthScopeNTLM = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM, "NTLM");
                    client.getCredentialsProvider().setCredentials(proxyAuthScopeNTLM, credentials);
                    AuthScope proxyAuthScopeAny = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                    Credentials usernamePasswordCredentials = HttpUtil.getCredentials(authProxy.getUserName(), authProxy.getPassword(), address.getAddress(), true);
                    client.getCredentialsProvider().setCredentials(proxyAuthScopeAny, usernamePasswordCredentials);
                } else {
                    AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                    client.getCredentialsProvider().setCredentials(proxyAuthScope, credentials);
                }
            }
        } else {
            client.getParams().setParameter("http.route.default-proxy", null);
        }
    }

    private static <T> T executeInternal(IProgressMonitor monitor, Operation<?> request) throws IOException {
        try {
            return (T)OperationUtil.execute((IProgressMonitor)monitor, request);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static Credentials getCredentials(String username, String password, InetAddress address, boolean forceUserNamePassword) {
        int i = username.indexOf("\\");
        if (i > 0 && i < username.length() - 1 && address != null && !forceUserNamePassword) {
            String hostName = address.getHostName();
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                if (localHost != null) {
                    hostName = localHost.getHostName();
                }
            }
            catch (UnknownHostException e) {
                StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Unable to get hostname.  Defaulting to servers host.", (Throwable)e));
            }
            if (hostName == null) {
                hostName = address.getHostName();
            }
            return new NTCredentials(username.substring(i + 1), password, hostName, username.substring(0, i));
        }
        return new UsernamePasswordCredentials(username, password);
    }

    public static synchronized ThreadSafeClientConnManager getConnectionManager() {
        if (connectionManager == null) {
            connectionManager = new ThreadSafeClientConnManager(HttpUtil.getSchemeRegistry());
            if (CoreUtil.TEST_MODE) {
                connectionManager.setDefaultMaxPerRoute(2);
            } else {
                connectionManager.setDefaultMaxPerRoute(100);
                connectionManager.setMaxTotal(1000);
            }
            IdleConnectionMonitorThread thread = new IdleConnectionMonitorThread(30000L);
            thread.setTimeout(60000L);
            thread.addConnectionManager((ClientConnectionManager)connectionManager);
            thread.start();
        }
        return connectionManager;
    }

    public static String getStatusText(int statusCode) {
        return EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, Locale.getDefault());
    }

    public static void release(HttpRequest request, HttpResponse response, IProgressMonitor monitor) {
        Assert.isNotNull((Object)request);
        Assert.isNotNull((Object)response);
        if (monitor != null && monitor.isCanceled() && request instanceof HttpUriRequest) {
            try {
                ((HttpUriRequest)request).abort();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {
                }
                catch (NullPointerException nullPointerException) {}
            }
        } else {
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {}
        }
    }
}

