/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;

public class ManagedTestSuite
extends TestSuite {
    public static final long DELAY = 600000L;
    private final Listener listener = new Listener();

    public ManagedTestSuite() {
    }

    public ManagedTestSuite(String name) {
        super(name);
    }

    public void run(TestResult result) {
        result.addListener((TestListener)this.listener);
        CommonTestUtil.fixProxyConfiguration();
        CommonTestUtil.dumpSystemInfo(System.err);
        super.run(result);
        this.listener.dumpResults(result);
        this.listener.startTest(new Test(){

            public int countTestCases() {
                return 1;
            }

            public void run(TestResult result) {
            }

            public String toString() {
                return "ShutdownWatchdog";
            }
        }, true);
    }

    private class DumpThreadTask
    extends TimerTask {
        private final Test test;
        private final Thread testThread;

        public DumpThreadTask(Test test) {
            this.test = test;
            this.testThread = Thread.currentThread();
        }

        public void run() {
            StringBuffer sb = new StringBuffer();
            sb.append(MessageFormat.format("Test {0} is taking too long:\n", this.test.toString()));
            Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : traces.entrySet()) {
                sb.append(entry.getKey().toString());
                sb.append("\n");
                StackTraceElement[] stackTraceElementArray = entry.getValue();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    sb.append("  ");
                    sb.append(element.toString());
                    sb.append("\n");
                    ++n2;
                }
                sb.append("\n");
            }
            System.err.println(sb.toString());
            System.err.println("Sending interrupt to thread: " + this.testThread.toString());
            this.testThread.interrupt();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements TestListener {
        private final ConcurrentHashMap<Test, DumpThreadTask> taskByTest = new ConcurrentHashMap();
        private final Timer timer = new Timer(true);

        private Listener() {
        }

        public void addError(Test test, Throwable t) {
            System.err.println("[ERROR]");
        }

        public void addFailure(Test test, AssertionFailedError t) {
            System.err.println("[FAILURE]");
        }

        private void dumpList(String header, Enumeration<TestFailure> failures) {
            System.err.println(header);
            while (failures.hasMoreElements()) {
                TestFailure failure = failures.nextElement();
                System.err.print("  ");
                System.err.println(failure.toString());
            }
        }

        public void dumpResults(TestResult result) {
            if (result.failureCount() > 0) {
                System.err.println();
                this.dumpList("Failures: ", result.failures());
            }
            if (result.errorCount() > 0) {
                System.err.println();
                this.dumpList("Errors: ", result.errors());
            }
            int failedCount = result.errorCount() + result.failureCount();
            System.err.println();
            System.err.println(MessageFormat.format("{0} out of {1} tests failed", failedCount, result.runCount()));
        }

        public void endTest(Test test) {
            DumpThreadTask task = this.taskByTest.remove(test);
            if (task != null) {
                task.cancel();
            }
        }

        public void startTest(Test test) {
            this.startTest(test, false);
        }

        public void startTest(Test test, boolean silent) {
            if (!silent) {
                System.err.println("Running " + test.toString());
            }
            DumpThreadTask task = new DumpThreadTask(test);
            this.taskByTest.put(test, task);
            this.timer.schedule((TimerTask)task, 600000L);
        }
    }
}

