/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import java.util.EnumSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;

public class TestConfiguration {
    public static TestConfiguration defaultConfiguration;
    private static final String SERVER;
    private final EnumSet<TestKind> kinds;
    private boolean localOnly;
    private boolean defaultOnly;
    private boolean headless;

    static {
        SERVER = System.getProperty("mylyn.test.server", "mylyn.org");
    }

    public static TestConfiguration getDefault() {
        if (defaultConfiguration == null) {
            defaultConfiguration = new TestConfiguration(TestKind.UNIT, new TestKind[0]);
            defaultConfiguration.setDefaultOnly(CommonTestUtil.runHeartbeatTestsOnly());
        }
        return defaultConfiguration;
    }

    public static String getRepositoryUrl(String service) {
        return TestConfiguration.getDefault().getUrl(service);
    }

    public static String getRepositoryUrl(String service, boolean secure) {
        return TestConfiguration.getDefault().getUrl(service, secure);
    }

    public static void setDefault(TestConfiguration defaultConfiguration) {
        TestConfiguration.defaultConfiguration = defaultConfiguration;
    }

    public TestConfiguration(TestKind firstKind, TestKind ... moreKinds) {
        Assert.isNotNull((Object)((Object)firstKind));
        this.kinds = EnumSet.of(firstKind, moreKinds);
    }

    public String getUrl(String service) {
        return this.getUrl(service, false);
    }

    public String getUrl(String service, boolean secure) {
        return String.valueOf(secure ? "https://" : "http://") + SERVER + "/" + service;
    }

    public boolean hasKind(TestKind kind) {
        return this.kinds.contains((Object)kind);
    }

    public boolean isDefaultOnly() {
        return this.defaultOnly;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public void setDefaultOnly(boolean heartbeat) {
        this.defaultOnly = heartbeat;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public void setLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestKind {
        UNIT,
        COMPONENT,
        INTEGRATION,
        SYSTEM;

    }
}

