/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import com.google.gerrit.reviewdb.Patch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.gerrit.core.GerritOperationFactory;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.SaveDraftRequest;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.ITopic;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.ITask;

public class GerritReviewBehavior
extends ReviewBehavior {
    public GerritReviewBehavior(ITask task) {
        super(task);
    }

    public GerritOperationFactory getOperationFactory() {
        return GerritUiPlugin.getDefault().getOperationFactory();
    }

    public IStatus addTopic(IReviewItem item, ITopic topic, IProgressMonitor monitor) {
        short side = 1;
        String id = item.getId();
        if (id.startsWith("base-")) {
            id = id.substring(5);
            side = 0;
        }
        Patch.Key key = Patch.Key.parse((String)id);
        SaveDraftRequest request = new SaveDraftRequest(key, ((ILineLocation)topic.getLocation()).getTotalMin(), side);
        request.setMessage(topic.getDescription());
        GerritOperation operation = this.getOperationFactory().createSaveDraftOperation(this.getTask(), request);
        return operation.run(monitor);
    }
}

