/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.PatchSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.ReviewItemCache;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritPatchSetContent;
import org.eclipse.mylyn.internal.gerrit.ui.GerritReviewBehavior;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewItemSetCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class OpenPatchSetJob
extends Job {
    private final TaskRepository repository;
    private final ChangeDetail changeDetail;
    private final PatchSet base;
    private final PatchSet target;
    private final ITask task;
    private final ReviewItemCache cache;

    public OpenPatchSetJob(TaskRepository repository, ITask task, ChangeDetail changeDetail, PatchSet base, PatchSet target, ReviewItemCache cache) {
        super("Opening Patch Set");
        this.repository = repository;
        this.task = task;
        this.changeDetail = changeDetail;
        this.base = base;
        this.target = target;
        this.cache = cache;
    }

    protected IStatus run(IProgressMonitor monitor) {
        GerritConnector connector = (GerritConnector)TasksUi.getRepositoryConnector((String)this.repository.getConnectorKind());
        GerritClient client = connector.getClient(this.repository);
        try {
            PatchSetDetail targetDetail = client.getPatchSetDetail(this.base != null ? this.base.getId() : null, this.target.getId(), monitor);
            int reviewId = targetDetail.getInfo().getKey().getParentKey().get();
            GerritPatchSetContent patchSetContent = client.getPatchSetContent(String.valueOf(reviewId), this.base, targetDetail, monitor);
            final IReviewItemSet items = GerritUtil.createInput((ChangeDetail)this.changeDetail, (GerritPatchSetContent)patchSetContent, (ReviewItemCache)this.cache);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OpenPatchSetJob.this.doOpen(items);
                }
            });
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (GerritException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.ui", "Review retrieval failed", (Throwable)e), 1);
        }
        return Status.OK_STATUS;
    }

    private void doOpen(IReviewItemSet items) {
        CompareConfiguration configuration = new CompareConfiguration();
        CompareUI.openCompareEditor((CompareEditorInput)new ReviewItemSetCompareEditorInput(configuration, items, null, (ReviewBehavior)new GerritReviewBehavior(this.task)));
    }
}

