/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.github.ui.AvatarStore;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AvatarLabel
implements AvatarStore.IAvatarCallback {
    public static final int AVATAR_SIZE = 42;
    private Composite displayArea;
    private Composite avatarImage;
    private AvatarStore store;
    private IRepositoryPerson person;
    private TaskAttribute attribute;

    public AvatarLabel(AvatarStore store, IRepositoryPerson person, TaskAttribute attribute) {
        this.store = store;
        this.person = person;
        this.attribute = attribute;
    }

    public AvatarLabel setVisible(boolean visible) {
        if (!this.displayArea.isDisposed()) {
            this.displayArea.setVisible(visible);
        }
        return this;
    }

    public AvatarLabel layout() {
        if (!this.displayArea.isDisposed()) {
            this.displayArea.getParent().getParent().layout(true, true);
        }
        return this;
    }

    public Composite getControl() {
        return this.displayArea;
    }

    public AvatarLabel create(Composite parent, FormToolkit toolkit) {
        this.displayArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(2, 2).spacing(1, 1).applyTo(this.displayArea);
        GridDataFactory.fillDefaults().span(1, 2).grab(false, false).applyTo((Control)this.displayArea);
        toolkit.adapt((Control)this.displayArea, false, false);
        this.avatarImage = new Composite(this.displayArea, 0);
        if (this.person != null) {
            this.avatarImage.setToolTipText(this.person.getPersonId());
        }
        GridDataFactory.swtDefaults().grab(false, false).align(0x1000000, 0x1000000).hint(42, 42).applyTo((Control)this.avatarImage);
        Label label = toolkit.createLabel(this.displayArea, this.attribute.getMetaData().getLabel());
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setToolTipText(this.avatarImage.getToolTipText());
        ImageData data = this.store.getAvatar(this.attribute.getValue());
        if (data != null) {
            this.setImage(this.store.getScaledImage(42, data));
        } else {
            this.store.loadAvatar(this.attribute.getValue(), this);
            this.setVisible(false);
        }
        return this;
    }

    private AvatarLabel setImage(final Image image) {
        if (!this.avatarImage.isDisposed()) {
            this.avatarImage.setBackgroundImage(image);
            this.avatarImage.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    image.dispose();
                }
            });
        }
        return this;
    }

    public void loaded(final ImageData data, final AvatarStore store) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Image image = store.getScaledImage(42, data);
                AvatarLabel.this.setImage(image).setVisible(true).layout();
            }
        });
    }
}

