/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.trac.core.Messages;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.UnsubmittedTaskAttachment;

public class TracAttachmentHandler
extends AbstractTaskAttachmentHandler {
    private final TracRepositoryConnector connector;

    public TracAttachmentHandler(TracRepositoryConnector connector) {
        this.connector = connector;
    }

    public InputStream getContent(TaskRepository repository, ITask task, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        TaskAttachmentMapper mapper = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
        String filename = mapper.getFileName();
        if (filename == null || filename.length() == 0) {
            throw new CoreException((IStatus)new RepositoryStatus(repository.getRepositoryUrl(), 4, "org.eclipse.mylyn.trac.core", 1, "Attachment download from " + repository.getRepositoryUrl() + " failed, missing attachment filename."));
        }
        try {
            ITracClient client = this.connector.getClientManager().getTracClient(repository);
            int id = Integer.parseInt(task.getTaskId());
            return client.getAttachmentData(id, filename, monitor);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(TracCorePlugin.toStatus(e, repository));
        }
    }

    public void postContent(TaskRepository repository, ITask task, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        if (!TracRepositoryConnector.hasAttachmentSupport(repository, task)) {
            throw new CoreException((IStatus)new RepositoryStatus(repository.getRepositoryUrl(), 1, "org.eclipse.mylyn.trac.core", 1, "Attachments are not supported by this repository access type"));
        }
        UnsubmittedTaskAttachment attachment = new UnsubmittedTaskAttachment(source, attachmentAttribute);
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(Messages.TracAttachmentHandler_Uploading_attachment, -1);
            try {
                ITracClient client = this.connector.getClientManager().getTracClient(repository);
                int id = Integer.parseInt(task.getTaskId());
                client.putAttachmentData(id, attachment.getFileName(), attachment.getDescription(), attachment.createInputStream(monitor), monitor, attachment.getReplaceExisting());
                if (comment != null && comment.length() > 0) {
                    TracTicket ticket = new TracTicket(id);
                    client.updateTicket(ticket, comment, monitor);
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException(TracCorePlugin.toStatus(e, repository));
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean canGetContent(TaskRepository repository, ITask task) {
        return TracRepositoryConnector.hasAttachmentSupport(repository, task);
    }

    public boolean canPostContent(TaskRepository repository, ITask task) {
        return TracRepositoryConnector.hasAttachmentSupport(repository, task);
    }
}

