/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.core.validation.ValidationRule;

public class TestMarkupValidationRule
extends ValidationRule {
    private static final Pattern pattern = Pattern.compile("(ERROR|WARNING)", 8);

    public ValidationProblem findProblem(String markup, int offset, int length) {
        Matcher matcher = pattern.matcher(markup);
        if (offset > 0 || length != markup.length()) {
            matcher.region(offset, offset + length);
        }
        if (matcher.find()) {
            String group = matcher.group(1);
            ValidationProblem.Severity severity = "ERROR".equals(group) ? ValidationProblem.Severity.ERROR : ValidationProblem.Severity.WARNING;
            return new ValidationProblem(severity, "test error", matcher.start(1), matcher.end(1) - matcher.start(1));
        }
        return null;
    }
}

