/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.ConfigurationBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.core.parser.markup.block.EclipseErrorDetailsBlock;
import org.eclipse.mylyn.wikitext.core.parser.markup.block.JavaStackTraceBlock;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBuilderTest
extends TestCase {
    public void testRepositorySettings() {
        MarkupLanguageConfiguration configuration = ConfigurationBuilder.create().repositorySettings().configuration();
        ConfigurationBuilderTest.assertFalse((boolean)configuration.isEnableUnwrappedParagraphs());
        ConfigurationBuilderTest.assertTrue((boolean)configuration.isEscapingHtmlAndXml());
        ConfigurationBuilderTest.assertTrue((boolean)configuration.isNewlinesMustCauseLineBreak());
        ConfigurationBuilderTest.assertTrue((boolean)configuration.isOptimizeForRepositoryUsage());
        this.assertHasInstance(configuration.getBlocks(), EclipseErrorDetailsBlock.class);
        this.assertHasInstance(configuration.getBlocks(), JavaStackTraceBlock.class);
    }

    private void assertHasInstance(List<Block> blocks, Class<? extends Block> clazz) {
        for (Block block : blocks) {
            if (!clazz.isAssignableFrom(block.getClass())) continue;
            return;
        }
        Assert.fail((String)("Expected instance of " + clazz.getName() + " but instead got " + blocks));
    }
}

