/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.eclipse.internal.net4j.buffer.BufferUtil;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.internal.tcp.messages.Messages;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.ISynchronizer;
import org.eclipse.net4j.util.concurrent.SynchronizingCorrelator;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlChannel
extends Channel {
    public static final short CONTROL_CHANNEL_INDEX = 0;
    public static final byte OPCODE_NEGOTIATION = 1;
    public static final byte OPCODE_REGISTRATION = 2;
    public static final byte OPCODE_REGISTRATION_ACK = 3;
    public static final byte OPCODE_DEREGISTRATION = 4;
    public static final byte SUCCESS = 1;
    public static final byte FAILURE = 0;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, ControlChannel.class);
    private SynchronizingCorrelator<Short, Boolean> acknowledgements = new SynchronizingCorrelator();

    public ControlChannel(TCPConnector connector) {
        this.setID((short)0);
        this.setMultiplexer((IChannelMultiplexer)connector);
        this.setReceiveExecutor(connector.getConfig().getReceiveExecutor());
        this.setUserID(connector.getUserID());
    }

    public TCPConnector getConnector() {
        return (TCPConnector)this.getMultiplexer();
    }

    public boolean registerChannel(short channelID, long timeout, IProtocol<?> protocol) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering channel {0} with protocol {1}", new Object[]{channelID, protocol});
        }
        this.assertValidChannelID(channelID);
        ISynchronizer acknowledgement = this.acknowledgements.correlate((Object)channelID);
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)0);
        byteBuffer.put((byte)2);
        byteBuffer.putShort(channelID);
        BufferUtil.putUTF8((ByteBuffer)byteBuffer, (String)(protocol == null ? null : protocol.getType()));
        this.handleBuffer(buffer);
        Boolean acknowledged = (Boolean)acknowledgement.get(timeout);
        if (acknowledged == null) {
            throw new TimeoutRuntimeException(MessageFormat.format(Messages.getString("ControlChannel_0"), timeout));
        }
        return acknowledged;
    }

    public void deregisterChannel(short channelID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Deregistering channel {0}", new Object[]{channelID});
        }
        this.assertValidChannelID(channelID);
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)0);
        byteBuffer.put((byte)4);
        byteBuffer.putShort(channelID);
        this.handleBuffer(buffer);
    }

    /*
     * Unable to fully structure code
     */
    public void handleBufferFromMultiplexer(IBuffer buffer) {
        try {
            byteBuffer = buffer.getByteBuffer();
            opcode = byteBuffer.get();
            switch (opcode) {
                case 1: {
                    this.assertNegotiating();
                    negotiationContext = this.getConnector().getNegotiationContext();
                    while (negotiationContext == null) {
                        ConcurrencyUtil.sleep((long)20L);
                        negotiationContext = this.getConnector().getNegotiationContext();
                    }
                    receiver = negotiationContext.getReceiver();
                    receiver.receiveBuffer(negotiationContext, byteBuffer);
                    break;
                }
                case 2: {
                    this.assertConnected();
                    channelID = byteBuffer.getShort();
                    this.assertValidChannelID(channelID);
                    success = true;
                    try {
                        handlerFactoryUTF8 = BufferUtil.getByteArray((ByteBuffer)byteBuffer);
                        protocolID = BufferUtil.fromUTF8((byte[])handlerFactoryUTF8);
                        channel = this.getConnector().inverseOpenChannel(channelID, protocolID);
                        if (channel == null) {
                            throw new ConnectorException(Messages.getString("ControlChannel_4"));
                        }
                    }
                    catch (Exception ex) {
                        success = false;
                        if (!ControlChannel.TRACER.isEnabled()) ** GOTO lbl31
                        ControlChannel.TRACER.trace("Problem during channel registration", (Throwable)ex);
                    }
lbl31:
                    // 3 sources

                    this.sendStatus((byte)3, channelID, success);
                    break;
                }
                case 4: {
                    this.assertConnected();
                    channelID = byteBuffer.getShort();
                    if (channelID == 0) {
                        throw new ImplementationError();
                    }
                    try {
                        this.getConnector().inverseCloseChannel(channelID);
                    }
                    catch (Exception ex) {
                        if (ControlChannel.TRACER.isEnabled()) {
                            ControlChannel.TRACER.trace("Problem during channel deregistration", (Throwable)ex);
                        }
                        break;
                    }
                }
                case 3: {
                    this.assertConnected();
                    channelID = byteBuffer.getShort();
                    success = byteBuffer.get() == 1;
                    this.acknowledgements.put((Object)channelID, (Object)success);
                    break;
                }
                default: {
                    OM.LOG.error("Invalid opcode: " + opcode);
                    this.getConnector().deactivate();
                    break;
                }
            }
        }
        finally {
            buffer.release();
        }
    }

    public String toString() {
        return MessageFormat.format("Channel[Control, {0}]", this.getLocation());
    }

    protected void unregisterFromMultiplexer() {
    }

    private void sendStatus(byte opcode, short channelID, boolean status) {
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)0);
        byteBuffer.put(opcode);
        byteBuffer.putShort(channelID);
        byteBuffer.put(status ? (byte)1 : 0);
        this.handleBuffer(buffer);
    }

    private void assertNegotiating() {
        if (!this.getConnector().isNegotiating()) {
            this.getConnector().deactivate();
            throw new IllegalStateException("Connector is not negotiating");
        }
    }

    private void assertConnected() {
        if (!this.getConnector().isConnected()) {
            throw new IllegalStateException("Connector is not connected");
        }
    }

    private void assertValidChannelID(short channelID) {
        if (channelID == 0) {
            throw new IllegalArgumentException("Bad channelID");
        }
    }
}

