/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedIOUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, ExtendedIOUtil.class);
    private static final int UTF_HEADER_SIZE = 2;
    private static final int MAX_16_BIT = 65535;
    private static final int MAX_UTF_LENGTH = 65533;
    private static final int MAX_UTF_CHARS = 21844;
    private static final int MAX_ENUM_LITERALS = 255;
    private static final byte NO_ENUM_LITERAL = -128;

    private ExtendedIOUtil() {
    }

    public static void writeByteArray(DataOutput out, byte[] b) throws IOException {
        if (b != null) {
            out.writeInt(b.length);
            out.write(b);
        } else {
            out.writeInt(-1);
        }
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        byte[] b;
        int length = in.readInt();
        if (length < 0) {
            return null;
        }
        try {
            b = new byte[length];
        }
        catch (Throwable t) {
            throw new IOException("Unable to allocate " + length + " bytes");
        }
        in.readFully(b);
        return b;
    }

    public static void writeObject(final DataOutput out, Object object) throws IOException {
        ObjectOutput wrapper = null;
        wrapper = out instanceof ObjectOutput ? (ObjectOutput)out : new ObjectOutputStream(new OutputStream(){

            public void write(int b) throws IOException {
                out.writeByte((b & 0xFF) + -128);
            }
        });
        wrapper.writeObject(object);
    }

    public static Object readObject(DataInput in) throws IOException {
        return ExtendedIOUtil.readObject(in, null);
    }

    public static Object readObject(DataInput in, ClassLoader classLoader) throws IOException {
        return ExtendedIOUtil.readObject(in, new ClassLoaderClassResolver(classLoader));
    }

    public static Object readObject(final DataInput in, final ClassResolver classResolver) throws IOException {
        ObjectInput wrapper = null;
        wrapper = in instanceof ObjectInput ? (ObjectInput)in : new ObjectInputStream(new InputStream(){

            public int read() throws IOException {
                return in.readByte() - -128;
            }
        }){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                if (classResolver != null) {
                    Class<?> c;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Deserializing class {0}", desc.getName());
                    }
                    if ((c = classResolver.resolveClass(desc)) != null) {
                        return c;
                    }
                }
                return super.resolveClass(desc);
            }
        };
        try {
            return wrapper.readObject();
        }
        catch (ClassNotFoundException ex) {
            OM.LOG.error(ex);
            throw WrappedException.wrap(ex);
        }
    }

    public static void writeString(DataOutput out, String str) throws IOException {
        if (str != null) {
            int chunk;
            int size = str.length();
            int start = 0;
            do {
                out.writeBoolean(true);
                chunk = Math.min(size, 21844);
                int end = start + chunk;
                out.writeUTF(str.substring(start, end));
                start = end;
            } while ((size -= chunk) > 0);
        }
        out.writeBoolean(false);
    }

    public static String readString(DataInput in) throws IOException {
        boolean more = in.readBoolean();
        if (!more) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        do {
            String chunk = in.readUTF();
            builder.append(chunk);
        } while (more = in.readBoolean());
        return builder.toString();
    }

    public static void writeEnum(DataOutput out, Enum<?> literal) throws IOException {
        if (literal == null) {
            out.writeByte(-128);
        } else {
            ExtendedIOUtil.getEnumLiterals(literal.getDeclaringClass());
            int ordinal = literal.ordinal();
            out.writeByte(ordinal + -128 + 1);
        }
    }

    public static <T extends Enum<?>> T readEnum(DataInput in, Class<T> type) throws IOException {
        Enum[] literals = (Enum[])ExtendedIOUtil.getEnumLiterals(type);
        byte ordinal = in.readByte();
        if (ordinal == -128) {
            return null;
        }
        return (T)literals[ordinal - -128 - 1];
    }

    private static <T> T[] getEnumLiterals(Class<T> type) {
        T[] literals = type.getEnumConstants();
        int size = literals.length;
        if (size > 255) {
            throw new AssertionError((Object)("Enum too large: " + size + " literals"));
        }
        return literals;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassLoaderClassResolver
    implements ClassResolver {
        private static final String STACK_TRACE_ELEMENT = StackTraceElement[].class.getName();
        private ClassLoader classLoader;

        public ClassLoaderClassResolver(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass v) throws ClassNotFoundException {
            String className = v.getName();
            try {
                return this.classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                if (!STACK_TRACE_ELEMENT.equals(className)) {
                    OM.LOG.error(ex);
                }
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ClassResolver {
        public Class<?> resolveClass(ObjectStreamClass var1) throws ClassNotFoundException;
    }
}

