/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;

public class CallinMarkerRemover {
    public static void removeCallinMarker(IMember member, IResource resource) {
        if (resource.exists()) {
            try {
                IMarker marker;
                if (member.getElementType() == 9 && (marker = CallinMarkerRemover.getCallinMarker(member, "org.eclipse.objectteams.otdt.ui.callinMarker", resource)) != null) {
                    marker.delete();
                }
                if ((marker = CallinMarkerRemover.getCallinMarker(member, "org.eclipse.objectteams.otdt.ui.calloutMarker", resource)) != null) {
                    marker.delete();
                }
            }
            catch (ResourceException resourceException) {
            }
            catch (CoreException ex) {
                OTDTUIPlugin.logException("Problems removing callin marker", ex);
            }
        }
    }

    private static IMarker getCallinMarker(IMember baseElement, String markerKind, IResource resource) throws JavaModelException, CoreException {
        IMarker[] markers = resource.findMarkers(markerKind, true, 2);
        String methodId = baseElement.getHandleIdentifier();
        int i = 0;
        while (i < markers.length) {
            if (methodId.equals(markers[i].getAttribute("org.eclipse.objectteams.otdt.ui.markerAttr.BaseElement", null))) {
                return markers[i];
            }
            ++i;
        }
        return null;
    }
}

