/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.types;

import org.eclipse.ocl.examples.domain.elements.DomainClassifierType;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.types.AbstractSpecializedType;

public class AbstractClassifierType
extends AbstractSpecializedType
implements DomainClassifierType {
    protected final DomainType instanceType;
    protected DomainType metaType = null;
    private DomainType normalizedInstanceType = null;
    private int hashCode;

    public AbstractClassifierType(DomainStandardLibrary standardLibrary, DomainType containerType, DomainType instanceType) {
        super(standardLibrary, containerType.getName(), containerType);
        this.instanceType = instanceType;
    }

    public boolean conformsTo(DomainStandardLibrary standardLibrary, DomainType type) {
        if (this == type) {
            return true;
        }
        DomainType thisMetaType = this.getMetaType();
        DomainType thatMetaType = type;
        return thisMetaType != null ? thisMetaType.conformsTo(standardLibrary, thatMetaType) : false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DomainClassifierType)) {
            return false;
        }
        DomainType thisInstanceType = this.getNormalizedInstanceType();
        DomainType thatInstanceType = ((DomainClassifierType)obj).getInstanceType().getNormalizedType(this.standardLibrary);
        return thisInstanceType.isEqualTo(this.standardLibrary, thatInstanceType);
    }

    public DomainType getCommonType(DomainStandardLibrary standardLibrary, DomainType type) {
        if (!(type instanceof DomainClassifierType)) {
            return standardLibrary.getOclAnyType();
        }
        DomainType thatInstanceType = ((DomainClassifierType)type).getInstanceType();
        DomainType commonInstanceType = this.instanceType.getCommonType(standardLibrary, thatInstanceType);
        if (commonInstanceType == this.instanceType) {
            return this;
        }
        if (commonInstanceType == thatInstanceType) {
            return type;
        }
        return standardLibrary.getClassifierType(commonInstanceType);
    }

    public DomainType getInstanceType() {
        return this.instanceType;
    }

    protected DomainType getMetaType() {
        String metaTypeName = this.instanceType.getMetaTypeName();
        if (metaTypeName != null) {
            this.metaType = this.standardLibrary.getOclType(metaTypeName);
        }
        return this.metaType;
    }

    protected DomainType getNormalizedInstanceType() {
        if (this.normalizedInstanceType == null) {
            this.normalizedInstanceType = this.instanceType.getNormalizedType(this.standardLibrary);
            this.hashCode = this.normalizedInstanceType.hashCode();
        }
        return this.normalizedInstanceType;
    }

    public int hashCode() {
        if (this.normalizedInstanceType == null) {
            this.getNormalizedInstanceType();
        }
        return this.hashCode;
    }

    public boolean isEqualTo(DomainStandardLibrary standardLibrary, DomainType type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof DomainClassifierType)) {
            return false;
        }
        DomainType thisInstanceType = this.getNormalizedInstanceType();
        DomainType thatInstanceType = ((DomainClassifierType)type).getInstanceType().getNormalizedType(standardLibrary);
        return thisInstanceType.isEqualTo(standardLibrary, thatInstanceType);
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.containerType)) + "(" + String.valueOf(this.instanceType) + ")";
    }
}

