/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CollectionValue
extends Value,
Iterable<Value> {
    public Collection<Value> asCollection();

    public List<Value> asList();

    public IntegerValue count(Value var1) throws InvalidValueException;

    public BooleanValue excludes(Value var1) throws InvalidValueException;

    public BooleanValue excludesAll(CollectionValue var1) throws InvalidValueException;

    public CollectionValue excluding(Value var1) throws InvalidValueException;

    public CollectionValue flatten() throws InvalidValueException;

    public boolean flatten(Collection<Value> var1) throws InvalidValueException;

    public DomainCollectionType getCollectionType();

    public String getKind();

    public BooleanValue includes(Value var1) throws InvalidValueException;

    public BooleanValue includesAll(CollectionValue var1) throws InvalidValueException;

    public CollectionValue including(Value var1) throws InvalidValueException;

    public int intSize();

    public CollectionValue intersection(CollectionValue var1) throws InvalidValueException;

    public BooleanValue isEmpty() throws InvalidValueException;

    @Override
    public Iterator<Value> iterator();

    public Value maxMin(DomainEvaluator var1, DomainType var2, LibraryBinaryOperation var3) throws InvalidValueException;

    public BooleanValue notEmpty() throws InvalidValueException;

    public Set<TupleValue> product(CollectionValue var1, DomainTupleType var2) throws InvalidValueException;

    public CollectionValue selectByKind(DomainType var1) throws InvalidValueException;

    public CollectionValue selectByType(DomainType var1) throws InvalidValueException;

    public IntegerValue size() throws InvalidValueException;

    public SequenceValue sort(Comparator<Value> var1) throws InvalidValueException;

    public Value sum(DomainEvaluator var1, DomainType var2, LibraryBinaryOperation var3, Value var4) throws InvalidValueException;

    public SequenceValue toSequenceValue() throws InvalidValueException;

    public CollectionValue union(CollectionValue var1) throws InvalidValueException;

    public static interface Accumulator
    extends CollectionValue {
        public boolean add(Value var1);
    }
}

