/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractCollectionValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequenceValue<L extends List<Value>>
extends AbstractCollectionValue<L>
implements SequenceValue {
    public AbstractSequenceValue(ValueFactory valueFactory, DomainCollectionType type, L elements) {
        super(valueFactory, type, elements);
    }

    @Override
    public List<Value> asList() {
        return (List)this.elements;
    }

    @Override
    public SequenceValue asSequenceValue() {
        return this;
    }

    @Override
    public SequenceValue append(Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "append");
        }
        ArrayList<Value> result = new ArrayList<Value>(this.elements);
        result.add(object);
        return this.valueFactory.createSequenceValue(this.getCollectionType(), (List<? extends Value>)result);
    }

    @Override
    public Value at(int index) throws InvalidValueException {
        if (--index < 0 || ((List)this.elements).size() <= index) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        return (Value)((List)this.elements).get(index);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NullValue) {
            return false;
        }
        if (obj instanceof SequenceValue) {
            SequenceValue that = (SequenceValue)obj;
            int i = 0;
            for (Value thisValue : this) {
                try {
                    Value thatValue = that.at(i++);
                    if (thisValue.equals(thatValue)) continue;
                    return false;
                }
                catch (InvalidValueException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public SequenceValue excluding(Value value) {
        ArrayList<Value> result = new ArrayList<Value>();
        for (Value element : (List)this.elements) {
            if (element.equals(value)) continue;
            result.add(element);
        }
        if (result.size() < ((List)this.elements).size()) {
            return this.valueFactory.createSequenceValue(this.getCollectionType(), (List<? extends Value>)result);
        }
        return this;
    }

    @Override
    public Value first() throws InvalidValueException {
        if (((List)this.elements).size() <= 0) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.EmptyCollection, "Sequence", "first");
        }
        return (Value)((List)this.elements).get(0);
    }

    @Override
    public SequenceValue flatten() throws InvalidValueException {
        ArrayList<Value> flattened = new ArrayList<Value>();
        if (this.flatten(flattened)) {
            return this.valueFactory.createSequenceValue(this.getCollectionType(), (List<? extends Value>)flattened);
        }
        return this;
    }

    @Override
    public String getKind() {
        return "Sequence";
    }

    @Override
    public SequenceValue including(Value value) throws InvalidValueException {
        if (value.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "including");
        }
        ArrayList<Value> result = new ArrayList<Value>(this.elements);
        result.add(value);
        return this.valueFactory.createSequenceValue(this.getCollectionType(), (List<? extends Value>)result);
    }

    @Override
    public IntegerValue indexOf(Value object) throws InvalidValueException {
        int index = ((List)this.elements).indexOf(object);
        if (index < 0) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.MissingValue, "indexOf");
        }
        return this.valueFactory.integerValueOf(index + 1);
    }

    @Override
    public SequenceValue insertAt(int index, Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "insertAt");
        }
        if (--index < 0 || index > ((List)this.elements).size()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        ArrayList<Value> result = new ArrayList<Value>(this.elements);
        result.add(index, object);
        return this.valueFactory.createSequenceValue(this.getCollectionType(), (List<? extends Value>)result);
    }

    @Override
    public Value last() throws InvalidValueException {
        int size = ((List)this.elements).size();
        if (size <= 0) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.EmptyCollection, "Sequence", "last");
        }
        return (Value)((List)this.elements).get(size - 1);
    }

    @Override
    public SequenceValue prepend(Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "prepend");
        }
        ArrayList<Value> result = new ArrayList<Value>();
        result.add(object);
        result.addAll(this.elements);
        return this.valueFactory.createSequenceValue(this.getCollectionType(), (List<? extends Value>)result);
    }

    @Override
    public SequenceValue reverse() throws InvalidValueException {
        ArrayList elements = new ArrayList(this.elements);
        Collections.reverse(elements);
        return this.valueFactory.createSequenceValue(this.getCollectionType(), elements);
    }

    @Override
    public SequenceValue sort(Comparator<Value> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return this.valueFactory.createSequenceValue(this.getCollectionType(), values);
    }

    @Override
    public SequenceValue subSequence(int lower, int upper) {
        --upper;
        if (--lower < 0) {
            throw new IndexOutOfBoundsException("lower: " + (lower + 1));
        }
        if (upper >= ((List)this.elements).size()) {
            throw new IndexOutOfBoundsException("upper: " + (upper + 1) + ", size: " + this.size());
        }
        if (upper < lower) {
            throw new IllegalArgumentException("lower: " + (lower + 1) + ", upper: " + (upper + 1));
        }
        ArrayList<Value> result = new ArrayList<Value>();
        int curr = 0;
        for (Value object : this) {
            if (curr >= lower && curr <= upper) {
                result.add(object);
            }
            ++curr;
        }
        return this.valueFactory.createSequenceValue(this.getCollectionType(), (List<? extends Value>)result);
    }

    @Override
    public SequenceValue toSequenceValue() {
        return this;
    }

    @Override
    public void toString(StringBuilder s, int lengthLimit) {
        s.append("Sequence");
        super.toString(s, lengthLimit);
    }
}

