/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.NumericValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractIntegerValue;
import org.eclipse.ocl.examples.domain.values.impl.IntegerLongValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.RealValueImpl;

public class IntegerIntValueImpl
extends AbstractIntegerValue {
    private final int value;
    private BigInteger bigValue = null;

    public IntegerIntValueImpl(ValueFactory valueFactory, int value) {
        super(valueFactory);
        this.value = value;
    }

    public IntegerValue abs() {
        if (this.value >= 0) {
            return this;
        }
        if (this.value > Integer.MIN_VALUE) {
            return this.valueFactory.integerValueOf(-this.value);
        }
        return this.valueFactory.integerValueOf(0x80000000L);
    }

    public IntegerValue add(IntegerValue right) {
        if (right instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)right).intValue();
            int sum = this.value + thatValue;
            if (this.value >= 0 ? thatValue >= 0 && sum >= 0 : thatValue <= 0 && sum <= 0) {
                return this.valueFactory.integerValueOf(sum);
            }
            return this.valueFactory.integerValueOf((long)this.value + (long)thatValue);
        }
        if (right instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)right).longValue();
            return this.valueFactory.integerValueOf((long)this.value + thatValue);
        }
        return this.valueFactory.integerValueOf(this.bigIntegerValue().add(right.bigIntegerValue()));
    }

    public Double asDouble() {
        return this.value;
    }

    public Integer asInteger() {
        return this.value;
    }

    public Object asObject() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    public BigInteger bigIntegerValue() {
        if (this.bigValue == null) {
            this.bigValue = BigInteger.valueOf(this.value);
        }
        return this.bigValue;
    }

    public int compareTo(NumericValue o) {
        if (o instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)o).intValue();
            return this.value < thatValue ? -1 : (this.value == thatValue ? 0 : 1);
        }
        if (o instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)o).longValue();
            return (long)this.value < thatValue ? -1 : ((long)this.value == thatValue ? 0 : 1);
        }
        if (o instanceof IntegerValue) {
            return this.bigIntegerValue().compareTo(((IntegerValue)o).bigIntegerValue());
        }
        return Double.compare(this.doubleValue(), o.doubleValue());
    }

    public IntegerValue div(IntegerValue right) throws InvalidValueException {
        if (right.bigIntegerValue().signum() == 0) {
            return null;
        }
        return this.valueFactory.integerValueOf(this.bigIntegerValue().divide(right.bigIntegerValue()));
    }

    public RealValue divide(IntegerValue right) throws InvalidValueException {
        BigDecimal bigLeft = this.bigDecimalValue();
        BigDecimal bigRight = right.bigDecimalValue();
        return RealValueImpl.divideBigDecimal(this.valueFactory, bigLeft, bigRight);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)obj).intValue();
            return this.value == thatValue;
        }
        if (obj instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)obj).longValue();
            return (long)this.value == thatValue;
        }
        if (obj instanceof IntegerValue) {
            BigInteger bigIntegerValue = ((IntegerValue)obj).bigIntegerValue();
            return bigIntegerValue != null && this.bigIntegerValue().compareTo(bigIntegerValue) == 0;
        }
        if (obj instanceof RealValue) {
            BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
            return bigDecimalValue != null && this.bigDecimalValue().compareTo(bigDecimalValue) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public boolean isUnlimitedNatural() {
        return this.value >= 0;
    }

    public IntegerValue max(IntegerValue right) throws InvalidValueException {
        if (right instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)right).intValue();
            return this.value >= thatValue ? this : right;
        }
        if (right instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)right).longValue();
            return (long)this.value >= thatValue ? this : right;
        }
        return this.bigIntegerValue().compareTo(right.bigIntegerValue()) >= 0 ? this : right;
    }

    public IntegerValue min(IntegerValue right) throws InvalidValueException {
        if (right instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)right).intValue();
            return this.value <= thatValue ? this : right;
        }
        if (right instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)right).longValue();
            return (long)this.value <= thatValue ? this : right;
        }
        return this.bigIntegerValue().compareTo(right.bigIntegerValue()) <= 0 ? this : right;
    }

    public IntegerValue mod(IntegerValue right) throws InvalidValueException {
        if (right.bigIntegerValue().signum() == 0) {
            return null;
        }
        if (right instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)right).intValue();
            return this.valueFactory.integerValueOf(this.value % thatValue);
        }
        if (right instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)right).longValue();
            return this.valueFactory.integerValueOf((long)this.value % thatValue);
        }
        return this.valueFactory.integerValueOf(this.bigIntegerValue().remainder(right.bigIntegerValue()));
    }

    public IntegerValue multiply(IntegerValue right) throws InvalidValueException {
        if (right instanceof IntegerIntValueImpl) {
            long thatValue = ((IntegerIntValueImpl)right).intValue();
            return this.valueFactory.integerValueOf((long)this.value * thatValue);
        }
        return this.valueFactory.integerValueOf(this.bigIntegerValue().multiply(right.bigIntegerValue()));
    }

    public IntegerValue negate() {
        if (this.value > Integer.MIN_VALUE) {
            return this.valueFactory.integerValueOf(-this.value);
        }
        return this.valueFactory.integerValueOf(0x80000000L);
    }

    public int signum() {
        return Integer.signum(this.value);
    }

    public IntegerValue subtract(IntegerValue right) throws InvalidValueException {
        if (right instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)right).intValue();
            int diff = this.value - thatValue;
            if (this.value >= 0 ? thatValue <= 0 && diff >= 0 : thatValue >= 0 && diff <= 0) {
                return this.valueFactory.integerValueOf(diff);
            }
            return this.valueFactory.integerValueOf((long)this.value - (long)thatValue);
        }
        if (right instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)right).longValue();
            return this.valueFactory.integerValueOf((long)this.value - thatValue);
        }
        return this.valueFactory.integerValueOf(this.bigIntegerValue().subtract(right.bigIntegerValue()));
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

