/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.classifier;

import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractUnaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class ClassifierOclContentsOperation
extends AbstractUnaryOperation {
    public static final ClassifierOclContentsOperation INSTANCE = new ClassifierOclContentsOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        ObjectValue objectVal = sourceValue.asObjectValue();
        Object object = objectVal.getObject();
        if (object instanceof EObject) {
            HashSet<Value> collection = new HashSet<Value>();
            for (Object eContent : ((EObject)object).eContents()) {
                collection.add(valueFactory.valueOf(eContent));
            }
            return valueFactory.createSetValue((DomainCollectionType)returnType, collection);
        }
        if (object instanceof DomainElement) {
            HashSet collection = new HashSet();
            return valueFactory.createSetValue((DomainCollectionType)returnType, collection);
        }
        return valueFactory.throwInvalidValueException(EvaluatorMessages.EObjectRequired, new Object[]{object.getClass().getName()});
    }
}

