/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.classifier;

import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.values.TypeValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class OclTypeConformsToOperation
extends AbstractBinaryOperation {
    public static final OclTypeConformsToOperation INSTANCE = new OclTypeConformsToOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceVal, Value argVal) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        DomainStandardLibrary standardLibrary = valueFactory.getStandardLibrary();
        TypeValue thisVal = sourceVal.asTypeValue();
        TypeValue thatVal = argVal.asTypeValue();
        DomainType thisType = thisVal.getInstanceType();
        DomainType thatType = thatVal.getInstanceType();
        return valueFactory.booleanValueOf(thisType.conformsTo(standardLibrary, thatType));
    }
}

