/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluationEnvironment;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluationVisitor;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.LibraryUnaryOperation;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.osgi.util.NLS;

public abstract class ExecutorManager
implements DomainEvaluator {
    protected final ValueFactory valueFactory;
    private boolean isCanceled = false;

    public ExecutorManager(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public Value evaluateIteration(DomainType returnType, CollectionValue sourceVal, DomainTypedElement accumulator, DomainExpression body, DomainTypedElement[] iterators) {
        throw new UnsupportedOperationException();
    }

    public ValueFactory getValueFactory() {
        if (this.isCanceled) {
            throw new EvaluationHaltedException("Canceled");
        }
        return this.valueFactory;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public DomainType typeOf(Value value, Value ... values) {
        DomainType type = value.getType();
        Value[] valueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Value anotherValue = valueArray[n2];
            DomainType anotherType = anotherValue.getType();
            type = type.getCommonType(this.valueFactory.getStandardLibrary(), anotherType);
            ++n2;
        }
        return type;
    }

    public Value evaluate(DomainExpression body) {
        try {
            return ((LibraryUnaryOperation)body).evaluate((DomainEvaluator)this, null, null);
        }
        catch (InvalidValueException e) {
            return this.throwInvalidEvaluation(e);
        }
    }

    public DomainEvaluationEnvironment getEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    public DomainEvaluationVisitor getEvaluationVisitor() {
        throw new UnsupportedOperationException();
    }

    public DomainModelManager getModelManager() {
        throw new UnsupportedOperationException();
    }

    public NullValue throwInvalidEvaluation(InvalidValueException e) throws InvalidEvaluationException {
        throw new InvalidEvaluationException(null, e);
    }

    public NullValue throwInvalidEvaluation(Throwable e, DomainExpression expression, Object context, String message, Object ... bindings) throws InvalidEvaluationException {
        throw new InvalidEvaluationException(null, NLS.bind((String)message, (Object[])bindings), e, expression, context);
    }
}

