/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.examples.domain.elements.DomainClassifierType;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.types.AbstractClassifierType;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorManager;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorPackage;
import org.eclipse.ocl.examples.library.executor.DomainReflectivePackage;
import org.eclipse.ocl.examples.library.executor.ExecutableStandardLibrary;
import org.eclipse.ocl.examples.library.executor.ExecutorType;
import org.eclipse.ocl.examples.library.oclstdlib.OCLstdlibTables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorStandardLibrary
extends ExecutableStandardLibrary {
    public static final ExecutorStandardLibrary INSTANCE = new ExecutorStandardLibrary(new EcoreExecutorPackage[0]);
    private Map<String, EcoreExecutorPackage> ePackageMap = new HashMap<String, EcoreExecutorPackage>();
    private Map<DomainPackage, DomainReflectivePackage> domainPackageMap = null;
    private Map<EClassifier, ExecutorType> typeMap = new HashMap<EClassifier, ExecutorType>();

    public ExecutorStandardLibrary(EcoreExecutorPackage ... execPackages) {
        OCLstdlibTables.PACKAGE.getClass();
        EcoreExecutorPackage[] ecoreExecutorPackageArray = execPackages;
        int n = execPackages.length;
        int n2 = 0;
        while (n2 < n) {
            EcoreExecutorPackage execPackage = ecoreExecutorPackageArray[n2];
            this.addPackage(execPackage);
            ++n2;
        }
    }

    public void addPackage(EcoreExecutorPackage execPackage) {
        EcoreExecutorPackage oldExecPackage = this.ePackageMap.put(execPackage.getNsURI(), execPackage);
    }

    @Override
    protected DomainClassifierType createClassifierType(DomainType classType) {
        DomainType anyClassifierType = this.getAnyClassifierType();
        AbstractClassifierType classifierType = new AbstractClassifierType((DomainStandardLibrary)this, anyClassifierType, classType);
        return classifierType;
    }

    @Override
    public DomainEvaluator createEvaluator(EObject contextObject, Map<Object, Object> contextMap) {
        return new EcoreExecutorManager(contextObject, contextMap, (DomainStandardLibrary)this);
    }

    public DomainInheritance getInheritance(DomainType type) {
        DomainReflectivePackage domainExecutorPackage;
        ExecutorType executorType;
        DomainType containerType;
        if (type instanceof DomainInheritance) {
            return (DomainInheritance)type;
        }
        if (type instanceof DomainClassifierType) {
            DomainType instanceType = ((DomainClassifierType)type).getInstanceType();
            DomainClassifierType classifierType = this.getClassifierType(instanceType);
            DomainType containerType2 = classifierType.getContainerType();
            return containerType2.getInheritance((DomainStandardLibrary)this);
        }
        if (type instanceof DomainCollectionType && (containerType = ((DomainCollectionType)type).getContainerType()) != null && containerType != type) {
            return containerType.getInheritance((DomainStandardLibrary)this);
        }
        DomainPackage domainPackage = type.getPackage();
        EcoreExecutorPackage ecoreExecutorPackage = this.ePackageMap.get(domainPackage.getNsURI());
        if (ecoreExecutorPackage != null && (executorType = ecoreExecutorPackage.getType(type.getName())) != null) {
            return executorType;
        }
        if (this.domainPackageMap == null) {
            this.domainPackageMap = new HashMap<DomainPackage, DomainReflectivePackage>();
        }
        if ((domainExecutorPackage = this.domainPackageMap.get(domainPackage)) == null) {
            domainExecutorPackage = new DomainReflectivePackage((DomainStandardLibrary)this, domainPackage);
            this.domainPackageMap.put(domainPackage, domainExecutorPackage);
        }
        return domainExecutorPackage.getInheritance(type);
    }

    public EcoreExecutorPackage getPackage(EPackage ePackage) {
        return this.ePackageMap.get(ePackage.getNsURI());
    }

    public ExecutorType getOclType(String typeName) {
        for (EcoreExecutorPackage dPackage : this.ePackageMap.values()) {
            ExecutorType type = dPackage.getType(typeName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public ExecutorType getType(EClassifier eClassifier) {
        EcoreExecutorPackage execPackage;
        ExecutorType type = this.typeMap.get(eClassifier);
        if (type == null && (execPackage = this.getPackage(eClassifier.getEPackage())) != null) {
            type = execPackage.getType(eClassifier.getName());
            this.typeMap.put(eClassifier, type);
        }
        return type;
    }
}

