/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.numeric;

import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.library.numeric.AbstractNumericBinaryOperation;

public class NumericMaxOperation
extends AbstractNumericBinaryOperation {
    public static final NumericMaxOperation INSTANCE = new NumericMaxOperation();

    protected IntegerValue evaluateInteger(DomainEvaluator evaluator, IntegerValue left, IntegerValue right) throws InvalidValueException {
        return left.max(right);
    }

    protected RealValue evaluateReal(DomainEvaluator evaluator, RealValue left, RealValue right) throws InvalidValueException {
        return left.max(right);
    }

    protected Value evaluateUnlimited(DomainEvaluator evaluator, Value left, Value right) {
        if (!left.isUnlimitedNatural() || !right.isUnlimitedNatural()) {
            return null;
        }
        return left.isUnlimited() ? left : right;
    }
}

