/**
 * <copyright>
 *
 * Copyright (c) 2011 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *
 * </copyright>
 *
 * $Id: UnimplementedOperation.java,v 1.2 2011/05/07 16:41:20 ewillink Exp $
 */
package org.eclipse.ocl.examples.pivot.library;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractUnaryOperation;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

/**
 * The static instance of UnimplementedOperation supports evaluation of
 * an operation that has not been implemented.
 */
public class UnimplementedOperation extends AbstractUnaryOperation //implements LibraryBinaryOperation
{
	public static final UnimplementedOperation INSTANCE = new UnimplementedOperation();

	public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue) throws InvalidValueException {
		ValueFactory valueFactory = evaluator.getValueFactory();
		return valueFactory.throwInvalidValueException("No implementation");
	}

//	public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue, Value argumentValue) throws InvalidValueException {
//		ValueFactory valueFactory = evaluator.getValueFactory();
//		return valueFactory.throwInvalidValueException("No implementation");
//	}
}