/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import org.eclipse.ocl.examples.pivot.AbstractBasicEnvironment;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ProblemHandler;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.options.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnvironment
extends AbstractBasicEnvironment
implements Environment.Internal {
    private Package contextPackage;
    private Operation contextOperation;
    private Property contextProperty;
    private Variable selfVariable;

    protected AbstractEnvironment() {
        super(null);
    }

    protected AbstractEnvironment(Environment.Internal parent) {
        super(parent);
    }

    protected AbstractEnvironment(AbstractEnvironment parent) {
        super(parent);
    }

    @Override
    public Environment.Internal getInternalParent() {
        return (Environment.Internal)super.getParent();
    }

    @Override
    @Deprecated
    public AbstractEnvironment getParent() {
        return (AbstractEnvironment)super.getParent();
    }

    @Override
    public void setInternalParent(Environment.Internal parent) {
        super.setParent(parent);
    }

    protected void setParent(AbstractEnvironment parent) {
        super.setParent(parent);
    }

    @Override
    public Package getContextPackage() {
        if (this.contextPackage != null) {
            return this.contextPackage;
        }
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getContextPackage();
        }
        return null;
    }

    protected void setContextPackage(Package contextPackage) {
        this.contextPackage = contextPackage;
    }

    @Override
    public Type getContextClassifier() {
        Variable selfVariable = this.getSelfVariable();
        return selfVariable != null ? selfVariable.getType() : null;
    }

    @Override
    public Operation getContextOperation() {
        if (this.contextOperation != null) {
            return this.contextOperation;
        }
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getContextOperation();
        }
        return null;
    }

    protected void setContextOperation(Operation contextOperation) {
        this.contextOperation = contextOperation;
    }

    @Override
    public Property getContextProperty() {
        if (this.contextProperty != null) {
            return this.contextProperty;
        }
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getContextProperty();
        }
        return null;
    }

    protected void setContextProperty(Property contextProperty) {
        this.contextProperty = contextProperty;
    }

    @Override
    public boolean addElement(String name, Variable elem, boolean isExplicit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelfVariable(Variable var) {
        Type contextClassifier;
        this.selfVariable = var;
        if (this.getContextPackage() == null && (contextClassifier = this.getContextClassifier()) != null) {
            this.setContextPackage(contextClassifier.getPackage());
        }
    }

    @Override
    public Variable getSelfVariable() {
        Variable result = this.selfVariable;
        if (result == null && this.getInternalParent() != null) {
            result = this.getInternalParent().getSelfVariable();
        }
        return result;
    }

    public boolean notOK(Option<ProblemHandler.Severity> option) {
        ProblemHandler.Severity sev = this.getValue(option);
        return sev != null && !sev.isOK();
    }

    @Override
    public void dispose() {
    }

    protected final class VariableEntry {
        final String name;
        final Variable variable;
        final boolean isExplicit;

        VariableEntry(String name, Variable variable, boolean isExplicit) {
            this.name = name;
            this.variable = variable;
            this.isExplicit = isExplicit;
        }

        public String toString() {
            return "VariableEntry[" + this.name + ", " + (this.isExplicit ? "explicit, " : "implicit, ") + this.variable + "]";
        }
    }
}

