/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.Base2PivotConversion;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBase2PivotConversion
extends AbstractConversion
implements Base2PivotConversion {
    private HashSet<TypedElement> underspecifiedTypedElements = null;

    protected AbstractBase2PivotConversion(MetaModelManager metaModelManager) {
        super(metaModelManager);
    }

    protected void addUnderspecifiedTypedElement(TypedElement pivotElement) {
        if (this.underspecifiedTypedElements == null) {
            this.underspecifiedTypedElements = new HashSet();
        }
        this.underspecifiedTypedElements.add(pivotElement);
    }

    public void refreshName(NamedElement pivotNamedElement, String newName) {
        String oldName = pivotNamedElement.getName();
        if (!(newName == oldName || newName != null && newName.equals(oldName))) {
            pivotNamedElement.setName(newName);
        }
    }

    protected void resolveUnderspecifiedTypes() {
        if (this.underspecifiedTypedElements != null) {
            for (TypedElement underspecifiedTypedElement : this.underspecifiedTypedElements) {
                Type underspecifiedType = underspecifiedTypedElement.getType();
                Type resolvedType = this.resolveUnderspecifiedType(underspecifiedType);
                underspecifiedTypedElement.setType(resolvedType);
            }
        }
    }

    protected Type resolveUnderspecifiedType(Type type) {
        if (type instanceof UnspecifiedType) {
            return ((UnspecifiedType)type).getLowerBound();
        }
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            Type resolvedElementType = this.resolveUnderspecifiedType(collectionType.getElementType());
            return this.metaModelManager.getCollectionType(collectionType.getName(), resolvedElementType);
        }
        if (type instanceof PrimitiveType) {
            return type;
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            ArrayList<Property> resolvedProperties = new ArrayList<Property>();
            for (Property part : ((TupleType)type).getOwnedAttribute()) {
                if (this.metaModelManager.isUnderspecified(part.getType())) {
                    Property prop = PivotFactory.eINSTANCE.createProperty();
                    prop.setName(part.getName());
                    prop.setType(this.resolveUnderspecifiedType(part.getType()));
                    resolvedProperties.add(part);
                    continue;
                }
                resolvedProperties.add(part);
            }
            return this.metaModelManager.getTupleType(tupleType.getName(), resolvedProperties, null);
        }
        if (type instanceof ClassifierType) {
            ClassifierType classifierType = (ClassifierType)type;
            Type resolvedElementType = this.resolveUnderspecifiedType(classifierType.getInstanceType());
            return this.metaModelManager.getClassifierType(resolvedElementType);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContextVariable(ExpressionInOCL pivotSpecification, String selfVariableName, Type contextType) {
        Variable contextVariable = pivotSpecification.getContextVariable();
        if (contextVariable == null) {
            contextVariable = PivotFactory.eINSTANCE.createVariable();
            pivotSpecification.setContextVariable(contextVariable);
        }
        this.refreshName(contextVariable, selfVariableName);
        this.setType(contextVariable, contextType);
    }

    @Override
    public void setClassifierContext(ExpressionInOCL pivotSpecification, Type contextType) {
        Variable contextVariable = pivotSpecification.getContextVariable();
        if (contextType.eIsProxy()) {
            contextType = null;
        }
        this.setType(contextVariable, contextType);
    }

    public void setOperationContext(ExpressionInOCL pivotSpecification, Operation contextOperation, String resultName) {
        Variable contextVariable = pivotSpecification.getContextVariable();
        if (contextOperation != null && !contextOperation.eIsProxy()) {
            this.setType(contextVariable, contextOperation.getOwningType());
            this.setParameterVariables(pivotSpecification, (List<Parameter>)contextOperation.getOwnedParameter());
        }
        if (resultName != null) {
            this.setResultVariable(pivotSpecification, contextOperation, resultName);
        }
    }

    @Override
    public void setParameterVariables(ExpressionInOCL pivotSpecification, List<Parameter> parameters) {
        ArrayList<Variable> oldVariables = new ArrayList<Variable>((Collection<Variable>)pivotSpecification.getParameterVariable());
        ArrayList<Variable> newVariables = new ArrayList<Variable>();
        for (Parameter parameter : parameters) {
            String name = parameter.getName();
            Variable param = PivotUtil.getNamedElement(oldVariables, name);
            if (param != null) {
                oldVariables.remove(param);
            } else {
                param = PivotFactory.eINSTANCE.createVariable();
                param.setName(name);
            }
            this.setTypeWithMultiplicity(param, parameter);
            param.setRepresentedParameter(parameter);
            newVariables.add(param);
        }
        this.refreshList(pivotSpecification.getParameterVariable(), newVariables);
    }

    @Override
    public void setParameterVariables(ExpressionInOCL pivotSpecification, Map<String, Type> parameters) {
        ArrayList<Variable> oldVariables = new ArrayList<Variable>((Collection<Variable>)pivotSpecification.getParameterVariable());
        ArrayList<Variable> newVariables = new ArrayList<Variable>();
        for (String name : parameters.keySet()) {
            Type type = parameters.get(name);
            Variable param = PivotUtil.getNamedElement(oldVariables, name);
            if (param != null) {
                oldVariables.remove(param);
            } else {
                param = PivotFactory.eINSTANCE.createVariable();
                param.setName(name);
            }
            this.setType(param, type);
            newVariables.add(param);
        }
        this.refreshList(pivotSpecification.getParameterVariable(), newVariables);
    }

    public void setPropertyContext(ExpressionInOCL pivotSpecification, Property contextProperty) {
        Variable contextVariable = pivotSpecification.getContextVariable();
        if (contextProperty != null && !contextProperty.eIsProxy()) {
            this.setType(contextVariable, contextProperty.getOwningType());
        }
    }

    @Override
    public void setResultVariable(ExpressionInOCL pivotSpecification, Operation contextOperation, String resultName) {
        Variable resultVariable = pivotSpecification.getResultVariable();
        if (resultVariable == null) {
            resultVariable = PivotFactory.eINSTANCE.createVariable();
        }
        resultVariable.setName(resultName);
        this.setTypeWithMultiplicity(resultVariable, contextOperation);
        pivotSpecification.setResultVariable(resultVariable);
    }

    public void setType(TypedElement pivotElement, Type type) {
        if (type != pivotElement.getType()) {
            pivotElement.setType(type);
            if (this.metaModelManager.isUnderspecified(type)) {
                this.addUnderspecifiedTypedElement(pivotElement);
            }
        }
        if (type != null) {
            PivotUtil.debugWellContainedness(type);
        }
    }

    public void setTypeWithMultiplicity(TypedElement typedElement, TypedMultiplicityElement typedMultiplicityElement) {
        Type type;
        if (typedMultiplicityElement != null && !typedMultiplicityElement.eIsProxy() && (type = this.metaModelManager.getTypeWithMultiplicity(typedMultiplicityElement)) != null && !type.eIsProxy()) {
            this.setType(typedElement, type);
            return;
        }
        this.setType(typedElement, null);
    }
}

