/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInvocationDelegate;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainException;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Query;
import org.eclipse.ocl.examples.pivot.delegate.InvocationBehavior;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLInvocationDelegate
extends BasicInvocationDelegate {
    protected final OCLDelegateDomain delegateDomain;
    private Operation operation;
    private ExpressionInOCL specification;

    public OCLInvocationDelegate(OCLDelegateDomain delegateDomain, EOperation operation) {
        super(operation);
        this.delegateDomain = delegateDomain;
    }

    public Object dynamicInvoke(InternalEObject target, EList<?> arguments) throws InvocationTargetException {
        try {
            OCL ocl = this.delegateDomain.getOCL();
            MetaModelManager metaModelManager = ocl.getMetaModelManager();
            ValueFactory valueFactory = metaModelManager.getValueFactory();
            if (this.specification == null) {
                Operation operation = this.getOperation();
                this.specification = InvocationBehavior.INSTANCE.getExpressionInOCL(metaModelManager, operation);
                InvocationBehavior.INSTANCE.validate(operation);
            }
            Query query = ocl.createQuery(this.specification);
            EvaluationEnvironment env = query.getEvaluationEnvironment();
            EList<Parameter> parms = this.operation.getOwnedParameter();
            if (!parms.isEmpty()) {
                int i = 0;
                while (i < parms.size()) {
                    Object object = arguments.get(i);
                    Value value = valueFactory.valueOf(object);
                    env.add((DomainTypedElement)parms.get(i), value);
                    ++i;
                }
            }
            Value result = query.evaluate(target);
            return result.asEcoreObject();
        }
        catch (DomainException e) {
            String message = NLS.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object)this.operation);
            throw new InvocationTargetException(new OCLDelegateException(message));
        }
        catch (OCLDelegateException e) {
            throw new InvocationTargetException(e);
        }
    }

    public Operation getOperation() {
        if (this.operation == null) {
            this.operation = this.delegateDomain.getPivot(Operation.class, (EObject)this.eOperation);
        }
        return this.operation;
    }

    public String toString() {
        if (this.operation != null) {
            return "<" + this.delegateDomain.getURI() + ":invocation> " + this.operation;
        }
        String name = String.valueOf(this.eOperation.getEContainingClass().getEPackage().getName()) + "::" + this.eOperation.getEContainingClass().getName() + "." + this.eOperation.getName();
        return "<" + this.delegateDomain.getURI() + ":invocation> " + name;
    }
}

