/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainException;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Query;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.EInvocationContext;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLQueryDelegate
implements QueryDelegate {
    protected OCLDelegateDomain delegateDomain;
    protected final EInvocationContext parserContext;
    protected final String expression;
    private ExpressionInOCL specification = null;

    public OCLQueryDelegate(OCLDelegateDomain delegateDomain, EClassifier context, Map<String, EClassifier> parameters, String expression) {
        this.delegateDomain = delegateDomain;
        MetaModelManager metaModelManager = delegateDomain.getMetaModelManager();
        URI uri = metaModelManager.getResourceIdentifier(this, null);
        this.parserContext = new EInvocationContext(metaModelManager, uri, context, parameters);
        this.expression = expression;
    }

    public Object execute(Object target, Map<String, ?> arguments) throws InvocationTargetException {
        if (this.specification == null) {
            this.prepare();
        }
        try {
            int argCount;
            OCL ocl = this.delegateDomain.getOCL();
            MetaModelManager metaModelManager = ocl.getMetaModelManager();
            ValueFactory valueFactory = metaModelManager.getValueFactory();
            Value targetValue = valueFactory.valueOf(target);
            DomainType targetType = targetValue.getType();
            Type requiredType = this.specification.getContextVariable().getType();
            if (!targetType.conformsTo((DomainStandardLibrary)metaModelManager, (DomainType)requiredType)) {
                String message = DomainUtil.bind((String)OCLMessages.WrongContextClassifier_ERROR_, (Object[])new Object[]{targetType, requiredType});
                throw new OCLDelegateException(message);
            }
            EList<Variable> parameterVariables = this.specification.getParameterVariable();
            int n = argCount = arguments != null ? arguments.size() : 0;
            if (parameterVariables.size() != argCount) {
                String message = DomainUtil.bind((String)OCLMessages.MismatchedArgumentCount_ERROR_, (Object[])new Object[]{argCount, parameterVariables.size()});
                throw new OCLDelegateException(message);
            }
            Query query = ocl.createQuery(this.specification);
            EvaluationEnvironment env = query.getEvaluationEnvironment();
            for (Variable parameterVariable : parameterVariables) {
                String name = parameterVariable.getName();
                Object object = arguments.get(name);
                if (object == null && !arguments.containsKey(name)) {
                    String message = DomainUtil.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object[])new Object[]{PivotUtil.getBody(this.specification)});
                    throw new OCLDelegateException(message);
                }
                Value value = valueFactory.valueOf(object);
                targetType = value.getType();
                if (!targetType.conformsTo((DomainStandardLibrary)metaModelManager, (DomainType)(requiredType = parameterVariable.getType()))) {
                    String message = DomainUtil.bind((String)OCLMessages.MismatchedArgumentType_ERROR_, (Object[])new Object[]{name, targetType, requiredType});
                    throw new OCLDelegateException(message);
                }
                env.add(parameterVariable, value);
            }
            Value result = query.evaluate(target);
            return result.asEcoreObject();
        }
        catch (DomainException e) {
            String message = DomainUtil.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object[])new Object[]{PivotUtil.getBody(this.specification)});
            throw new InvocationTargetException(new OCLDelegateException(message));
        }
        catch (OCLDelegateException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void prepare() throws InvocationTargetException {
        try {
            this.specification = this.parserContext.parse(this.expression);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public String toString() {
        OCLExpression bodyExpression = this.specification.getBodyExpression();
        if (bodyExpression != null) {
            return "<" + this.delegateDomain.getURI() + ":query> " + bodyExpression;
        }
        return "<" + this.delegateDomain.getURI() + ":query> " + PivotUtil.getBody(this.specification);
    }
}

