/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.context.ClassContext;
import org.eclipse.ocl.examples.pivot.delegate.InvocationBehavior;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.ValidationBehavior;
import org.eclipse.ocl.examples.pivot.delegate.ValidationDelegate;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLValidationDelegate
implements ValidationDelegate {
    protected final OCLDelegateDomain delegateDomain;
    protected final EClassifier eClassifier;

    public OCLValidationDelegate(OCLDelegateDomain delegateDomain, EClassifier classifier) {
        this.delegateDomain = delegateDomain;
        this.eClassifier = classifier;
    }

    public EvaluationVisitor createEvaluationVisitor(Object object, ExpressionInOCL query) {
        EnvironmentFactory environmentFactory = this.delegateDomain.getOCL().getEnvironmentFactory();
        Environment rootEnvironment = environmentFactory.createEnvironment();
        EvaluationEnvironment evaluationEnvironment = this.createEvaluationEnvironment(object, query, environmentFactory);
        DomainModelManager extents = evaluationEnvironment.createModelManager(object);
        EvaluationVisitor evaluationVisitor = environmentFactory.createEvaluationVisitor(rootEnvironment, evaluationEnvironment, extents);
        return evaluationVisitor;
    }

    public EvaluationEnvironment createEvaluationEnvironment(Object object, ExpressionInOCL query, EnvironmentFactory environmentFactory) {
        EvaluationEnvironment evaluationEnvironment = environmentFactory.createEvaluationEnvironment();
        MetaModelManager metaModelManager = evaluationEnvironment.getMetaModelManager();
        ValueFactory valueFactory = metaModelManager.getValueFactory();
        Value value = valueFactory.valueOf(object);
        evaluationEnvironment.add(query.getContextVariable(), value);
        return evaluationEnvironment;
    }

    protected String evaluateMessage(EvaluationVisitor evaluationVisitor, String constraintName, ExpressionInOCL query) {
        OCLExpression messageExpression = query.getMessageExpression();
        if (messageExpression == null) {
            return null;
        }
        try {
            Value result = (Value)messageExpression.accept(evaluationVisitor);
            return result.asString();
        }
        catch (InvalidValueException e) {
            String objectLabel = DomainUtil.getLabel((EObject)query.getContextVariable().getType());
            String message = DomainUtil.bind((String)OCLMessages.ValidationMessageIsNotString_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(query), constraintName, objectLabel});
            throw new OCLDelegateException(message, (Exception)((Object)e));
        }
    }

    public String toString() {
        return "<" + this.delegateDomain.getURI() + ":validate> " + this.eClassifier.getEPackage().getName() + "::" + this.eClassifier.getName();
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, EOperation invariant, String expression) {
        MetaModelManager metaModelManager = this.delegateDomain.getMetaModelManager();
        NamedElement namedElement = this.delegateDomain.getPivot(NamedElement.class, (EObject)invariant);
        if (namedElement instanceof Operation) {
            Operation operation = (Operation)namedElement;
            ExpressionInOCL query = InvocationBehavior.INSTANCE.getExpressionInOCL(metaModelManager, operation);
            InvocationBehavior.INSTANCE.validate(operation);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement instanceof Constraint) {
            ExpressionInOCL query;
            Constraint constraint = (Constraint)namedElement;
            ValueSpecification valueSpecification = constraint.getSpecification();
            if (valueSpecification instanceof ExpressionInOCL) {
                query = (ExpressionInOCL)valueSpecification;
            } else {
                Type contextType = (Type)constraint.getContext();
                URI uri = metaModelManager.getResourceIdentifier(constraint, "body");
                ClassContext classContext = new ClassContext(metaModelManager, uri, contextType);
                query = ValidationBehavior.INSTANCE.getExpressionInOCL(classContext, constraint);
            }
            if (query == null) {
                String message = DomainUtil.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{constraint.getContext()});
                throw new OCLDelegateException(message);
            }
            ValidationBehavior.INSTANCE.validate(constraint);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        throw new ClassCastException(String.valueOf(namedElement.getClass().getName()) + " does not provide a Constraint");
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, String constraintName, String expression) {
        return this.validatePivot((EClassifier)eClass, eObject, null, context, constraintName, null, 0);
    }

    public boolean validate(EDataType eDataType, Object value, Map<Object, Object> context, String constraintName, String expression) {
        return this.validatePivot((EClassifier)eDataType, value, null, context, constraintName, null, 0);
    }

    @Override
    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, String expression, int severity, String source, int code) {
        return this.validatePivot((EClassifier)eClass, eObject, diagnostics, context, constraintName, source, code);
    }

    @Override
    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, String expression, int severity, String source, int code) {
        return this.validatePivot((EClassifier)eDataType, value, diagnostics, context, constraintName, source, code);
    }

    protected boolean validatePivot(EClassifier eClassifier, Object value, DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, String source, int code) {
        ExpressionInOCL query;
        MetaModelManager metaModelManager = this.delegateDomain.getMetaModelManager();
        Type type = this.delegateDomain.getPivot(Type.class, (EObject)eClassifier);
        Constraint constraint = ValidationBehavior.INSTANCE.getConstraint(metaModelManager, eClassifier, constraintName);
        if (constraint == null) {
            String message = DomainUtil.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{type});
            throw new OCLDelegateException(message);
        }
        ValueSpecification valueSpecification = constraint.getSpecification();
        if (valueSpecification instanceof ExpressionInOCL) {
            query = (ExpressionInOCL)valueSpecification;
        } else {
            URI uri = metaModelManager.getResourceIdentifier(constraint, "body");
            ClassContext classContext = new ClassContext(metaModelManager, uri, type);
            query = ValidationBehavior.INSTANCE.getExpressionInOCL(classContext, constraint);
        }
        if (query == null) {
            String message = DomainUtil.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{type});
            throw new OCLDelegateException(message);
        }
        return this.validateExpressionInOCL(eClassifier, value, diagnostics, context, constraintName, source, code, query);
    }

    protected boolean check(EvaluationVisitor evaluationVisitor, String constraintName, ExpressionInOCL query) {
        if (query.getType() != evaluationVisitor.getMetaModelManager().getBooleanType()) {
            String objectLabel = DomainUtil.getLabel((EObject)query.getContextVariable().getType());
            String message = DomainUtil.bind((String)OCLMessages.ValidationConstraintIsNotBoolean_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(query), constraintName, objectLabel});
            throw new OCLDelegateException(message);
        }
        try {
            Value result = (Value)query.accept(evaluationVisitor);
            if (result.isNull()) {
                String objectLabel = DomainUtil.getLabel((EObject)query.getContextVariable().getType());
                String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsNull_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(query), constraintName, objectLabel});
                throw new OCLDelegateException(message);
            }
            return result.asBoolean();
        }
        catch (InvalidValueException e) {
            String objectLabel = DomainUtil.getLabel((EObject)query.getContextVariable().getType());
            String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsNotBoolean_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(query), constraintName, objectLabel});
            throw new OCLDelegateException(message, (Exception)((Object)e));
        }
        catch (InvalidEvaluationException e) {
            String objectLabel = DomainUtil.getLabel((EObject)query.getContextVariable().getType());
            String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(query), constraintName, objectLabel});
            throw new OCLDelegateException(message, (Exception)((Object)e));
        }
    }

    protected boolean validateExpressionInOCL(EClassifier eClassifier, Object value, DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, String source, int code, ExpressionInOCL query) {
        Value result;
        EvaluationVisitor evaluationVisitor = this.createEvaluationVisitor(value, query);
        if (query.getType() != evaluationVisitor.getMetaModelManager().getBooleanType()) {
            String objectLabel = DomainUtil.getLabel((EObject)query.getContextVariable().getType());
            String message = DomainUtil.bind((String)OCLMessages.ValidationConstraintIsNotBoolean_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(query), constraintName, objectLabel});
            throw new OCLDelegateException(message);
        }
        try {
            result = (Value)query.accept(evaluationVisitor);
            if (result.isNull()) {
                if (diagnostics == null) {
                    String objectLabel = DomainUtil.getLabel((EObject)query.getContextVariable().getType());
                    String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsNull_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(query), constraintName, objectLabel});
                    throw new OCLDelegateException(message);
                }
            } else if (result.asBoolean()) {
                return true;
            }
        }
        catch (InvalidValueException e) {
            String objectLabel = DomainUtil.getLabel((EObject)query.getContextVariable().getType());
            String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsNotBoolean_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(query), constraintName, objectLabel});
            throw new OCLDelegateException(message, (Exception)((Object)e));
        }
        catch (InvalidEvaluationException e) {
            String objectLabel = DomainUtil.getLabel((EObject)query.getContextVariable().getType());
            String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(query), constraintName, objectLabel});
            throw new OCLDelegateException(message, (Exception)((Object)e));
        }
        if (diagnostics != null) {
            String message = this.evaluateMessage(evaluationVisitor, constraintName, query);
            if (message == null) {
                String objectLabel = DomainUtil.getLabel((EClassifier)eClassifier, (Object)value, context);
                message = DomainUtil.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(query), constraintName, objectLabel});
            }
            int severity = result.isNull() ? 4 : 2;
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, source, code, message, new Object[]{value}));
        }
        return false;
    }
}

