/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Moniker;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2PivotDeclarationSwitch;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2PivotReferenceSwitch;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.model.OCLstdlib;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.AliasAdapter;
import org.eclipse.ocl.examples.pivot.utilities.External2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ecore2Pivot
extends AbstractConversion
implements External2Pivot,
PivotConstants {
    public static MetaModelManager.Factory FACTORY = new Factory();
    private Map<EObject, Element> createMap = new HashMap<EObject, Element>();
    private Set<EObject> referencers = new HashSet<EObject>();
    private Set<Ecore2Pivot> allConverters = new HashSet<Ecore2Pivot>();
    private List<EGenericType> genericTypes = new ArrayList<EGenericType>();
    private List<Resource.Diagnostic> errors = null;
    protected final Resource ecoreResource;
    protected Package pivotRoot = null;
    protected final Ecore2PivotDeclarationSwitch declarationPass = new Ecore2PivotDeclarationSwitch(this);
    protected final Ecore2PivotReferenceSwitch referencePass = new Ecore2PivotReferenceSwitch(this);
    private HashMap<EClassifier, Type> ecore2PivotMap = null;

    public static Ecore2Pivot findAdapter(Resource resource, MetaModelManager metaModelManager) {
        assert (metaModelManager != null);
        if (resource == null) {
            return null;
        }
        for (Adapter adapter : resource.eAdapters()) {
            Ecore2Pivot ecore2Pivot;
            if (!(adapter instanceof Ecore2Pivot) || (ecore2Pivot = (Ecore2Pivot)adapter).getMetaModelManager() != metaModelManager) continue;
            return ecore2Pivot;
        }
        return null;
    }

    public static Ecore2Pivot getAdapter(Resource resource, MetaModelManager metaModelManager) {
        Ecore2Pivot adapter;
        if (resource == null) {
            return null;
        }
        if (metaModelManager == null) {
            metaModelManager = new MetaModelManager();
        } else {
            adapter = Ecore2Pivot.findAdapter(resource, metaModelManager);
            if (adapter != null) {
                return adapter;
            }
        }
        adapter = new Ecore2Pivot(resource, metaModelManager);
        EList eAdapters = resource.eAdapters();
        eAdapters.add(adapter);
        return adapter;
    }

    public static Package importFromEcore(MetaModelManager metaModelManager, String alias, Resource ecoreResource) {
        if (ecoreResource == null) {
            return null;
        }
        Ecore2Pivot conversion = Ecore2Pivot.getAdapter(ecoreResource, metaModelManager);
        return conversion.getPivotRoot();
    }

    public static boolean isEcore(Resource resource) {
        EList contents = resource.getContents();
        for (EObject content : contents) {
            if (!(content instanceof EPackage)) continue;
            return true;
        }
        return false;
    }

    public static Element importFromEcore(MetaModelManager metaModelManager, String alias, EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource ecoreResource = eObject.eResource();
        Ecore2Pivot conversion = Ecore2Pivot.getAdapter(ecoreResource, metaModelManager);
        Package pivotRoot = conversion.getPivotRoot();
        if (pivotRoot == null) {
            return null;
        }
        return conversion.createMap.get(eObject);
    }

    public Ecore2Pivot(Resource ecoreResource, MetaModelManager metaModelManager) {
        super(metaModelManager != null ? metaModelManager : new MetaModelManager());
        this.ecoreResource = ecoreResource;
        this.metaModelManager.addExternalResource(this);
        this.metaModelManager.addListener(this);
    }

    protected void addCreated(EObject eObject, Element pivotElement) {
        this.createMap.put(eObject, pivotElement);
    }

    public void addGenericType(EGenericType eObject) {
        this.genericTypes.add(eObject);
    }

    public void addMapping(EObject eObject, Element pivotElement) {
        Type pivotType;
        if (pivotElement instanceof PivotObjectImpl) {
            ((PivotObjectImpl)((Object)pivotElement)).setTarget((Notifier)eObject);
        }
        if (eObject instanceof EClassifier && (pivotType = this.getEcore2PivotMap().get(eObject)) != null) {
            pivotElement = pivotType;
        }
        this.addCreated(eObject, pivotElement);
    }

    protected URI createPivotURI() {
        return PivotUtil.getPivotURI(this.ecoreResource.getURI());
    }

    public void dispose() {
        this.metaModelManager.removeExternalResource(this);
        this.getTarget().eAdapters().remove((Object)this);
    }

    protected void error(String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    public <T extends Element> T getCreated(java.lang.Class<T> requiredClass, EObject eObject) {
        return this.getPivotOfEcore(requiredClass, eObject);
    }

    public Map<EClassifier, Type> getEcore2PivotMap() {
        if (this.ecore2PivotMap == null) {
            this.ecore2PivotMap = new HashMap();
            this.initializeEcore2PivotMap();
        }
        return this.ecore2PivotMap;
    }

    public Resource getEcoreResource() {
        return this.ecoreResource;
    }

    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public <T extends Element> T getPivotOfEcore(java.lang.Class<T> requiredClass, EObject eObject) {
        Element element;
        if (this.pivotRoot == null) {
            this.getPivotRoot();
        }
        if ((element = this.createMap.get(eObject)) == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(element.getClass())) {
            throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + requiredClass.getName());
        }
        Element castElement = element;
        return (T)castElement;
    }

    public <T extends Element> T getPivotElement(java.lang.Class<T> requiredClass, EObject eObject) {
        Element element;
        if (this.pivotRoot == null) {
            this.getPivotRoot();
        }
        if ((element = this.createMap.get(eObject)) == null) {
            Ecore2Pivot converter;
            Resource resource = eObject.eResource();
            if (resource != this.ecoreResource && resource != null && this.allConverters.add(converter = Ecore2Pivot.getAdapter(resource, this.metaModelManager))) {
                converter.getPivotRoot();
                for (Map.Entry<EObject, Element> entry : converter.createMap.entrySet()) {
                    this.createMap.put(entry.getKey(), entry.getValue());
                }
            }
            element = this.createMap.get(eObject);
        }
        if (element == null) {
            this.error("Unresolved " + eObject);
        } else if (!requiredClass.isAssignableFrom(element.getClass())) {
            throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + requiredClass.getName());
        }
        Element castElement = element;
        return (T)castElement;
    }

    public Type getPivotType(EObject eObject) {
        Element pivotElement = this.createMap.get(eObject);
        if (pivotElement == null) {
            Ecore2Pivot converter;
            Resource resource = eObject.eResource();
            if (resource != this.ecoreResource && resource != null && this.allConverters.add(converter = Ecore2Pivot.getAdapter(resource, this.metaModelManager))) {
                converter.getPivotRoot();
                for (Map.Entry<EObject, Element> entry : converter.createMap.entrySet()) {
                    this.createMap.put(entry.getKey(), entry.getValue());
                }
            }
            pivotElement = this.createMap.get(eObject);
        }
        if (pivotElement == null) {
            this.error("Unresolved " + eObject);
        } else if (!(pivotElement instanceof Type)) {
            this.error("Incompatible " + eObject);
        } else {
            return (Type)pivotElement;
        }
        return null;
    }

    public Package getPivotRoot() {
        if (this.pivotRoot == null) {
            Resource pivotResource = this.importObjects((Collection<EObject>)this.ecoreResource.getContents(), this.createPivotURI());
            AliasAdapter ecoreAdapter = AliasAdapter.findAdapter(this.ecoreResource);
            if (ecoreAdapter != null) {
                Map<EObject, String> ecoreAliasMap = ecoreAdapter.getAliasMap();
                AliasAdapter pivotAdapter = AliasAdapter.getAdapter(pivotResource);
                Map<EObject, String> pivotAliasMap = pivotAdapter.getAliasMap();
                for (EObject eObject : ecoreAliasMap.keySet()) {
                    String alias = ecoreAliasMap.get(eObject);
                    Element element = this.createMap.get(eObject);
                    pivotAliasMap.put(element, alias);
                }
            }
            this.metaModelManager.installResource(pivotResource);
        }
        return this.pivotRoot;
    }

    @Override
    public Resource getResource() {
        return this.ecoreResource;
    }

    public Notifier getTarget() {
        return this.ecoreResource;
    }

    @Override
    public URI getURI() {
        return this.ecoreResource.getURI();
    }

    public Resource importObjects(Collection<EObject> ecoreContents, URI pivotURI) {
        Resource pivotResource = this.metaModelManager.createResource(pivotURI, "org.eclipse.ocl.examples.pivot");
        try {
            if (this.metaModelManager.getLibraryResource() == null && this.isPivot(ecoreContents)) {
                OCLstdlib library = OCLstdlib.create("http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib", "ocl", "ocl", ((EPackage)ecoreContents.iterator().next()).getNsURI());
                this.metaModelManager.loadLibrary((Resource)library);
            }
            this.pivotRoot = this.metaModelManager.createModel(pivotURI.lastSegment(), null);
            pivotResource.getContents().add((Object)this.pivotRoot);
            EList<Package> packages = this.pivotRoot.getNestedPackage();
            for (EObject eObject : ecoreContents) {
                Object pivotElement = this.declarationPass.doInPackageSwitch(eObject);
                if (pivotElement instanceof Package) {
                    packages.add((Package)pivotElement);
                    continue;
                }
                this.error("Bad ecore content");
            }
            HashMap<String, Type> resolvedSpecializations = new HashMap<String, Type>();
            for (EGenericType eGenericType : this.genericTypes) {
                Type pivotType = this.resolveType(resolvedSpecializations, eGenericType);
                this.createMap.put((EObject)eGenericType, pivotType);
            }
            for (EObject eObject : this.referencers) {
                this.referencePass.doInPackageSwitch(eObject);
            }
            for (EObject eObject : this.referencers) {
                Property pivotElement;
                Property oppositeProperty;
                if (!(eObject instanceof EReference) || (oppositeProperty = (pivotElement = this.getCreated(Property.class, eObject)).getOpposite()) != null || !(eObject.eContainer() instanceof EClass)) continue;
                this.metaModelManager.installPropertyDeclaration(pivotElement);
            }
        }
        catch (Exception e) {
            if (this.errors == null) {
                this.errors = new ArrayList<Resource.Diagnostic>();
            }
            this.errors.add((Resource.Diagnostic)new XMIException("Failked to load '" + pivotURI + "'", e));
        }
        if (this.errors != null) {
            pivotResource.getErrors().addAll(this.errors);
        }
        return pivotResource;
    }

    public void initializeEcore2PivotMap() {
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.EBOOLEAN, this.metaModelManager.getBooleanType());
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.EBIG_INTEGER, this.metaModelManager.getIntegerType());
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.EBIG_DECIMAL, this.metaModelManager.getRealType());
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.ESTRING, this.metaModelManager.getStringType());
    }

    @Override
    public boolean isAdapterFor(MetaModelManager metaModelManager) {
        return this.metaModelManager == metaModelManager;
    }

    public boolean isAdapterForType(Object type) {
        return type == Ecore2Pivot.class;
    }

    protected boolean isPivot(Collection<EObject> ecoreContents) {
        if (ecoreContents.size() != 1) {
            return false;
        }
        EObject ecoreRoot = ecoreContents.iterator().next();
        if (!(ecoreRoot instanceof EPackage)) {
            return false;
        }
        EPackage ecorePackage = (EPackage)ecoreRoot;
        if (ecorePackage.getEClassifier(PivotPackage.Literals.ENUMERATION_LITERAL.getName()) == null) {
            return false;
        }
        if (ecorePackage.getEClassifier(PivotPackage.Literals.EXPRESSION_IN_OCL.getName()) == null) {
            return false;
        }
        if (ecorePackage.getEClassifier(PivotPackage.Literals.OPERATION_CALL_EXP.getName()) == null) {
            return false;
        }
        return ecorePackage.getEClassifier(PivotPackage.Literals.TEMPLATE_PARAMETER_SUBSTITUTION.getName()) != null;
    }

    @Override
    public void metaModelManagerDisposed(MetaModelManager metaModelManager) {
        this.dispose();
    }

    public void notifyChanged(Notification notification) {
    }

    public void queueReference(EModelElement eObject) {
        this.referencers.add((EObject)eObject);
    }

    protected <T extends NamedElement> T refreshNamedElement(java.lang.Class<T> pivotClass, EClass pivotEClass, ENamedElement eNamedElement) {
        EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
        EObject pivotElement = eFactoryInstance.create(pivotEClass);
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        NamedElement castElement = (NamedElement)pivotElement;
        if (eNamedElement != null) {
            castElement.setName(eNamedElement.getName());
        }
        return (T)castElement;
    }

    protected Type resolveDataType(EGenericType eGenericType) {
        assert (eGenericType.getETypeArguments().isEmpty());
        EDataType eClassifier = (EDataType)eGenericType.getEClassifier();
        Type pivotType = this.getEcore2PivotMap().get(eClassifier);
        if (pivotType == null) {
            pivotType = this.getPivotType((EObject)eClassifier);
        }
        return pivotType;
    }

    protected Type resolveGenericType(Map<String, Type> resolvedSpecializations, EGenericType eGenericType) {
        EList eTypeArguments = eGenericType.getETypeArguments();
        assert (!eGenericType.getETypeArguments().isEmpty());
        EClassifier eClassifier = eGenericType.getEClassifier();
        EList eTypeParameters = eClassifier.getETypeParameters();
        assert (eTypeParameters.size() == eTypeArguments.size());
        Type unspecializedPivotType = this.getPivotType((EObject)eClassifier);
        if (unspecializedPivotType == null) {
            return null;
        }
        ArrayList<Type> templateArguments = new ArrayList<Type>();
        for (EGenericType eTypeArgument : eTypeArguments) {
            Type typeArgument = this.resolveType(resolvedSpecializations, eTypeArgument);
            templateArguments.add(typeArgument);
        }
        return this.metaModelManager.getLibraryType(unspecializedPivotType, templateArguments);
    }

    protected Type resolveSimpleType(EGenericType eGenericType) {
        assert (eGenericType.getETypeArguments().isEmpty());
        EClassifier eClassifier = eGenericType.getEClassifier();
        Type pivotType = this.getPivotType((EObject)eClassifier);
        return pivotType;
    }

    protected Type resolveType(Map<String, Type> resolvedSpecializations, EGenericType eGenericType) {
        Type pivotType = this.getCreated(Type.class, (EObject)eGenericType);
        if (pivotType != null) {
            return pivotType;
        }
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        EList eTypeArguments = eGenericType.getETypeArguments();
        if (eTypeParameter != null) {
            pivotType = this.resolveTypeParameter(eGenericType);
        } else if (eClassifier == null) {
            pivotType = this.resolveWildcardType(eGenericType);
        } else if (!eTypeArguments.isEmpty()) {
            String ecoreMoniker = Ecore2Moniker.toString(eGenericType);
            pivotType = resolvedSpecializations.get(ecoreMoniker);
            if (pivotType == null) {
                pivotType = this.resolveGenericType(resolvedSpecializations, eGenericType);
                resolvedSpecializations.put(ecoreMoniker, pivotType);
            }
        } else {
            pivotType = eClassifier instanceof EDataType ? this.resolveDataType(eGenericType) : this.resolveSimpleType(eGenericType);
        }
        this.createMap.put((EObject)eGenericType, pivotType);
        return pivotType;
    }

    protected Type resolveTypeParameter(EGenericType eGenericType) {
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        EList eTypeArguments = eGenericType.getETypeArguments();
        assert (eClassifier == null);
        assert (eTypeArguments.isEmpty());
        Type pivotType = this.getCreated(Type.class, (EObject)eTypeParameter);
        return pivotType;
    }

    protected Type resolveWildcardType(EGenericType eGenericType) {
        EObject eContainer;
        List list;
        int index;
        assert (eGenericType.getETypeArguments().isEmpty());
        assert (eGenericType.getEClassifier() == null);
        EClassifier eClassifier = eGenericType.getERawType();
        assert (eClassifier == EcorePackage.Literals.EJAVA_OBJECT);
        Class pivotElement = PivotFactory.eINSTANCE.createClass();
        String name = "wildcard";
        EReference eFeature = eGenericType.eContainmentFeature();
        if (eFeature != null && eFeature.isMany() && (index = (list = (List)(eContainer = eGenericType.eContainer()).eGet(eGenericType.eContainingFeature())).indexOf(eGenericType)) != 0) {
            name = String.valueOf(name) + index;
        }
        pivotElement.setName(name);
        return pivotElement;
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == null || newTarget == this.ecoreResource);
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (oldTarget == this.ecoreResource);
    }

    private static final class Factory
    implements MetaModelManager.Factory {
        private Factory() {
            MetaModelManager.addFactory(this);
        }

        public boolean canHandle(Resource resource) {
            return Ecore2Pivot.isEcore(resource);
        }

        public void configure(ResourceSet resourceSet) {
        }

        public URI getPackageURI(EObject eObject) {
            String uri;
            if (eObject instanceof EPackage && (uri = ((EPackage)eObject).getNsURI()) != null) {
                return URI.createURI((String)uri);
            }
            return null;
        }

        public Element importFromResource(MetaModelManager metaModelManager, Resource ecoreResource, String uriFragment) {
            if (ecoreResource == null) {
                return null;
            }
            Ecore2Pivot conversion = Ecore2Pivot.getAdapter(ecoreResource, metaModelManager);
            Package pivotRoot = conversion.getPivotRoot();
            if (uriFragment == null) {
                return pivotRoot;
            }
            EObject eObject = ecoreResource.getEObject(uriFragment);
            if (eObject == null) {
                return null;
            }
            return (Element)conversion.createMap.get(eObject);
        }
    }
}

