/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.library.JavaCompareToOperation;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ecore2PivotReferenceSwitch
extends EcoreSwitch<Object> {
    public static final String PROPERTY_OPPOSITE_ROLE_NAME_KEY = "Property.oppositeRoleName";
    public static final Object PROPERTY_OPPOSITE_ROLE_UNIQUE_KEY = "Property.oppositeUnique";
    public static final Object PROPERTY_OPPOSITE_ROLE_ORDERED_KEY = "Property.oppositeOrdered";
    public static final Object PROPERTY_OPPOSITE_ROLE_LOWER_KEY = "Property.oppositeLower";
    public static final Object PROPERTY_OPPOSITE_ROLE_UPPER_KEY = "Property.oppositeUpper";
    protected final Ecore2Pivot converter;

    public Ecore2PivotReferenceSwitch(Ecore2Pivot converter) {
        this.converter = converter;
    }

    public Object caseEAnnotation(EAnnotation eObject) {
        Annotation pivotElement = this.converter.getCreated(Annotation.class, (EObject)eObject);
        this.doSwitchAll((java.lang.Class)Element.class, (Collection)pivotElement.getReference(), (List<? extends EObject>)eObject.getReferences());
        return null;
    }

    public Object caseEClass(EClass eObject) {
        Class oclElementType;
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)eObject);
        this.doSwitchAll((java.lang.Class)Type.class, (Collection)pivotElement.getSuperClass(), (List<? extends EObject>)eObject.getEGenericSuperTypes());
        if (pivotElement.getSuperClass().isEmpty() && (oclElementType = this.converter.getMetaModelManager().getOclElementType()) != null) {
            pivotElement.getSuperClass().add((Object)oclElementType);
        }
        return null;
    }

    public Object caseEDataType(EDataType eObject) {
        super.caseEDataType(eObject);
        java.lang.Class instanceClass = eObject.getInstanceClass();
        if (instanceClass != null) {
            DataType pivotElement = this.converter.getCreated(DataType.class, (EObject)eObject);
            try {
                MetaModelManager metaModelManager = this.converter.getMetaModelManager();
                Method declaredMethod = instanceClass.getDeclaredMethod("compareTo", instanceClass);
                Operation operation = PivotFactory.eINSTANCE.createOperation();
                operation.setName(EvaluatorMessages.CompareToOperation);
                operation.setImplementation((LibraryFeature)new JavaCompareToOperation(declaredMethod));
                Parameter parameter = PivotFactory.eINSTANCE.createParameter();
                parameter.setName("that");
                parameter.setType(metaModelManager.getOclSelfType());
                operation.getOwnedParameter().add((Object)parameter);
                operation.setType(metaModelManager.getIntegerType());
                pivotElement.getOwnedOperation().add((Object)operation);
                pivotElement.getSuperClass().add((Object)metaModelManager.getOclComparableType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Object caseEOperation(EOperation eObject) {
        Operation pivotElement = this.converter.getCreated(Operation.class, (EObject)eObject);
        this.doSwitchAll((java.lang.Class)Type.class, (Collection)pivotElement.getRaisedException(), (List<? extends EObject>)eObject.getEGenericExceptions());
        return null;
    }

    public Object caseEReference(EReference eObject) {
        Property pivotElement = (Property)this.caseETypedElement((ETypedElement)eObject);
        this.doSwitchAll((java.lang.Class)Property.class, (Collection)pivotElement.getKeys(), (List<? extends EObject>)eObject.getEKeys());
        Property oppositeProperty = null;
        EReference eOpposite = eObject.getEOpposite();
        if (eOpposite != null) {
            oppositeProperty = this.converter.getCreated(Property.class, (EObject)eOpposite);
        } else {
            EAnnotation oppositeRole = eObject.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
            if (oppositeRole != null) {
                EMap details = oppositeRole.getDetails();
                String oppositeName = (String)details.get((Object)PROPERTY_OPPOSITE_ROLE_NAME_KEY);
                if (oppositeName != null) {
                    String upperValue;
                    String lowerValue;
                    String orderedValue;
                    oppositeProperty = PivotFactory.eINSTANCE.createProperty();
                    oppositeProperty.setName(oppositeName);
                    oppositeProperty.setImplicit(true);
                    Type remoteType = pivotElement.getType();
                    Type localType = PivotUtil.getOwningType(pivotElement);
                    oppositeProperty.setType(localType);
                    String uniqueValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_UNIQUE_KEY);
                    if (uniqueValue != null) {
                        oppositeProperty.setIsUnique(Boolean.valueOf(uniqueValue));
                    }
                    if ((orderedValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_ORDERED_KEY)) != null) {
                        oppositeProperty.setIsOrdered(Boolean.valueOf(orderedValue));
                    }
                    if ((lowerValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_LOWER_KEY)) != null) {
                        oppositeProperty.setLower(new BigInteger(lowerValue));
                    }
                    if ((upperValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_UPPER_KEY)) != null) {
                        oppositeProperty.setUpper(new BigInteger(upperValue));
                    }
                    remoteType.getOwnedAttribute().add((Object)oppositeProperty);
                    oppositeProperty.setOpposite(pivotElement);
                }
            } else {
                EMap details;
                String oppositeName;
                oppositeRole = eObject.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
                if (oppositeRole != null && (oppositeName = (String)(details = oppositeRole.getDetails()).get((Object)"body")) != null) {
                    oppositeProperty = PivotFactory.eINSTANCE.createProperty();
                    oppositeProperty.setName(oppositeName);
                    oppositeProperty.setImplicit(true);
                    Type remoteType = pivotElement.getType();
                    Type localType = PivotUtil.getOwningType(pivotElement);
                    oppositeProperty.setType(localType);
                    remoteType.getOwnedAttribute().add((Object)oppositeProperty);
                    oppositeProperty.setOpposite(pivotElement);
                }
            }
        }
        if (oppositeProperty != null) {
            pivotElement.setOpposite(oppositeProperty);
        }
        return pivotElement;
    }

    public TypedElement caseETypedElement(ETypedElement eObject) {
        TypedElement pivotElement = this.converter.getCreated(TypedElement.class, (EObject)eObject);
        EGenericType eType = eObject.getEGenericType();
        if (eType != null) {
            Type pivotType = this.converter.getPivotType((EObject)eType);
            pivotElement.setType(pivotType);
        }
        return pivotElement;
    }

    public Object caseETypeParameter(ETypeParameter eObject) {
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)eObject);
        TypeTemplateParameter typeTemplateParameter = (TypeTemplateParameter)pivotElement.getTemplateParameter();
        this.doSwitchAll((java.lang.Class)Type.class, (Collection)typeTemplateParameter.getConstrainingType(), (List<? extends EObject>)eObject.getEBounds());
        return null;
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            T pivotElement = this.converter.getPivotElement(pivotClass, eObject);
            if (pivotElement == null) continue;
            pivotElements.add(pivotElement);
        }
    }
}

