/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluationEnvironment;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.pivot.Adaptable;
import org.eclipse.ocl.examples.pivot.Customizable;
import org.eclipse.ocl.examples.pivot.OCLUtil;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.options.Option;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEvaluationEnvironment
implements EvaluationEnvironment,
Adaptable,
Customizable {
    protected final MetaModelManager metaModelManager;
    private final EvaluationEnvironment parent;
    private final Map<DomainTypedElement, Value> variableValues = new HashMap<DomainTypedElement, Value>();
    private final Map<Option<?>, Object> options = new HashMap();

    protected AbstractEvaluationEnvironment(MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
        this.parent = null;
    }

    protected AbstractEvaluationEnvironment(EvaluationEnvironment parent) {
        this.metaModelManager = parent.getMetaModelManager();
        this.parent = parent;
    }

    @Override
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    protected EvaluationEnvironment getParent() {
        return this.parent;
    }

    @Override
    public Value getValueOf(VariableDeclaration referredVariable) {
        if (referredVariable instanceof Variable) assert (((Variable)referredVariable).getRepresentedParameter() == null);
        Value object = this.variableValues.get(referredVariable);
        if (object == null && this.parent != null && !this.variableValues.containsKey(referredVariable)) {
            object = this.parent.getValueOf(referredVariable);
        }
        return object;
    }

    @Override
    public void replace(DomainTypedElement referredVariable, Value value) {
        if (referredVariable instanceof Variable) assert (((Variable)referredVariable).getRepresentedParameter() == null);
        this.variableValues.put(referredVariable, value);
    }

    @Override
    public void add(DomainTypedElement referredVariable, Value value) {
        Value oldValue;
        if (referredVariable instanceof Variable) assert (((Variable)referredVariable).getRepresentedParameter() == null);
        if (this.variableValues.containsKey(referredVariable) && (oldValue = this.variableValues.get(referredVariable)) != value && (oldValue == null || !oldValue.equals(value))) {
            String message = NLS.bind((String)OCLMessages.BindingExist_ERROR_, (Object)referredVariable, (Object)oldValue);
            throw new IllegalArgumentException(message);
        }
        this.variableValues.put(referredVariable, value);
    }

    @Override
    @Deprecated
    public Value remove(DomainTypedElement referredVariable) {
        if (referredVariable instanceof Variable) assert (((Variable)referredVariable).getRepresentedParameter() == null);
        return this.variableValues.remove(referredVariable);
    }

    @Override
    public void clear() {
        this.variableValues.clear();
    }

    public String toString() {
        return this.variableValues.toString();
    }

    @Override
    public boolean overrides(Operation operation, int opcode) {
        return this.getParent() != null ? this.getParent().overrides(operation, opcode) : false;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        AbstractEvaluationEnvironment result = adapterType.isInstance(this) ? this : null;
        return (T)result;
    }

    protected Map<Option<?>, Object> basicGetOptions() {
        return this.options;
    }

    @Override
    public Map<Option<?>, Object> getOptions() {
        Customizable parent = this.getParent() != null ? OCLUtil.getAdapter(this.getParent(), Customizable.class) : null;
        HashMap result = parent != null ? new HashMap(parent.getOptions()) : new HashMap();
        result.putAll(this.basicGetOptions());
        return result;
    }

    @Override
    public <T> void setOption(Option<T> option, T value) {
        this.basicGetOptions().put(option, value);
    }

    @Override
    public <T> void putOptions(Map<? extends Option<T>, ? extends T> options) {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        myOptions.clear();
        myOptions.putAll(options);
    }

    @Override
    public <T> T removeOption(Option<T> option) {
        T result = this.getValue(option);
        this.basicGetOptions().remove(option);
        return result;
    }

    @Override
    public <T> Map<Option<T>, T> removeOptions(Collection<Option<T>> options) {
        HashMap<Option<T>, T> result = new HashMap<Option<T>, T>();
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        for (Option<T> next : options) {
            result.put(next, this.getValue(next));
            myOptions.remove(next);
        }
        return result;
    }

    @Override
    public Map<Option<?>, Object> clearOptions() {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        HashMap result = new HashMap(myOptions);
        myOptions.clear();
        return result;
    }

    @Override
    public boolean isEnabled(Option<Boolean> option) {
        Boolean result = this.getValue(option);
        return result == null ? false : result;
    }

    @Override
    public <T> T getValue(Option<T> option) {
        Object result = this.getOptions().get(option);
        if (result == null) {
            Customizable parent = this.getParent() != null ? OCLUtil.getAdapter(this.getParent(), Customizable.class) : null;
            result = parent != null ? parent.getValue(option) : option.getDefaultValue();
        }
        return (T)result;
    }

    @Override
    public NullValue throwInvalidEvaluation(InvalidValueException e) throws InvalidEvaluationException {
        throw new InvalidEvaluationException((DomainEvaluationEnvironment)this, e);
    }

    @Override
    public NullValue throwInvalidEvaluation(String message) throws InvalidEvaluationException {
        throw new InvalidEvaluationException((DomainEvaluationEnvironment)this, message, null, null, null);
    }

    @Override
    public NullValue throwInvalidEvaluation(String message, DomainExpression expression) throws InvalidEvaluationException {
        throw new InvalidEvaluationException((DomainEvaluationEnvironment)this, message, null, expression, null);
    }

    @Override
    public NullValue throwInvalidEvaluation(String message, DomainExpression expression, Object context) throws InvalidEvaluationException {
        throw new InvalidEvaluationException((DomainEvaluationEnvironment)this, message, null, expression, context);
    }

    @Override
    public NullValue throwInvalidEvaluation(Throwable e, DomainExpression expression, Object context, String message, Object ... bindings) throws InvalidEvaluationException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidEvaluationException((DomainEvaluationEnvironment)this, boundMessage, e, expression, context);
    }
}

