/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainClassifierType;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainEnumerationLiteral;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainException;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.EvaluatorMultipleIterationManager;
import org.eclipse.ocl.examples.domain.library.EvaluatorSingleIterationManager;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.library.LibraryIteration;
import org.eclipse.ocl.examples.domain.library.LibraryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryProperty;
import org.eclipse.ocl.examples.domain.library.LibraryTernaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryUnaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.InvalidValue;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.SequenceRangeImpl;
import org.eclipse.ocl.examples.library.executor.ReflectiveType;
import org.eclipse.ocl.examples.pivot.AssociationClassCallExp;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionKind;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.MessageExp;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.StateExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.UnspecifiedValueExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.evaluation.AbstractEvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class EvaluationVisitorImpl
extends AbstractEvaluationVisitor {
    public static boolean isSimpleRange(CollectionLiteralExp cl) {
        EList<CollectionLiteralPart> partsList = cl.getPart();
        int size = partsList.size();
        if (size == 1) {
            CollectionLiteralPart part = (CollectionLiteralPart)partsList.get(0);
            return part instanceof CollectionRange;
        }
        return false;
    }

    public EvaluationVisitorImpl(Environment env, EvaluationEnvironment evalEnv, DomainModelManager modelManager) {
        super(env, evalEnv, modelManager);
    }

    public EvaluationVisitor createNestedEvaluator() {
        EnvironmentFactory factory = this.environment.getFactory();
        EvaluationEnvironment nestedEvalEnv = factory.createEvaluationEnvironment(this.evaluationEnvironment);
        return new EvaluationVisitorImpl(this.environment, nestedEvalEnv, this.modelManager);
    }

    public Value evaluate(DomainExpression body) {
        return (Value)((OCLExpression)body).accept(this);
    }

    public EvaluationVisitor getEvaluator() {
        return this;
    }

    public LibraryFeature lookupImplementation(DomainType dynamicType, DomainOperation staticOperation) {
        ReflectiveType inheritance = this.metaModelManager.getInheritance(dynamicType);
        return inheritance.lookupImplementation((DomainStandardLibrary)this.metaModelManager, staticOperation);
    }

    public Value safeVisit(Visitable v) {
        if (v == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("null expression");
        }
        try {
            return v.accept(this);
        }
        catch (DomainException e) {
            throw e;
        }
        catch (Exception e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e, null, v, "Evaluation Failure", new Object[0]);
        }
    }

    public Value visitAssociationClassCallExp(AssociationClassCallExp ae) {
        Value context = (Value)ae.getSource().accept(this.getUndecoratedVisitor());
        if (context.isUndefined()) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Undefined context for AssociationClassCall", ae);
        }
        return this.evaluationEnvironment.navigateAssociationClass(ae.getReferredAssociationClass(), ae.getNavigationSource(), context);
    }

    public BooleanValue visitBooleanLiteralExp(BooleanLiteralExp booleanLiteralExp) {
        boolean value = booleanLiteralExp.isBooleanSymbol();
        return this.valueFactory.booleanValueOf(value);
    }

    public Value visitCollectionItem(CollectionItem item) {
        throw new UnsupportedOperationException("evaluation of CollectionItem");
    }

    public Value visitCollectionLiteralExp(CollectionLiteralExp cl) {
        CollectionKind kind = cl.getKind();
        EList<CollectionLiteralPart> parts = cl.getPart();
        DomainCollectionType type = (DomainCollectionType)cl.getType();
        if (kind == CollectionKind.SEQUENCE && EvaluationVisitorImpl.isSimpleRange(cl)) {
            IntegerValue lastInteger;
            IntegerValue firstInteger;
            CollectionRange collRange = (CollectionRange)parts.get(0);
            OCLExpression first = collRange.getFirst();
            OCLExpression last = collRange.getLast();
            Value firstVal = (Value)first.accept(this.getUndecoratedVisitor());
            if (firstVal == null) {
                return this.evaluationEnvironment.throwInvalidEvaluation("Invalid first element", cl, first);
            }
            Value lastVal = (Value)last.accept(this.getUndecoratedVisitor());
            if (lastVal == null) {
                return this.evaluationEnvironment.throwInvalidEvaluation("Invalid last element", cl, last);
            }
            try {
                firstInteger = firstVal.asIntegerValue();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, firstVal, "Non integer first element", new Object[0]);
            }
            try {
                lastInteger = lastVal.asIntegerValue();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, lastVal, "Non integer last element", new Object[0]);
            }
            try {
                return new SequenceRangeImpl(this.valueFactory, type, this.valueFactory.createRange(firstInteger, lastInteger));
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, lastVal, "Non integer first or last element", new Object[0]);
            }
        }
        ArrayList<Object> results = new ArrayList<Object>();
        block14: for (CollectionLiteralPart part : parts) {
            Integer lastInt;
            Integer firstInt;
            IntegerValue lastInteger;
            IntegerValue firstInteger;
            if (part instanceof CollectionItem) {
                CollectionItem item = (CollectionItem)part;
                OCLExpression itemExp = item.getItem();
                Value itemVal = (Value)itemExp.accept(this.getUndecoratedVisitor());
                if (itemVal == null) continue;
                results.add(itemVal);
                continue;
            }
            CollectionRange range = (CollectionRange)part;
            OCLExpression first = range.getFirst();
            OCLExpression last = range.getLast();
            Value firstVal = (Value)first.accept(this.getUndecoratedVisitor());
            if (firstVal == null) {
                return this.evaluationEnvironment.throwInvalidEvaluation("Invalid first element", cl, first);
            }
            Value lastVal = (Value)last.accept(this.getUndecoratedVisitor());
            if (lastVal == null) {
                return this.evaluationEnvironment.throwInvalidEvaluation("Invalid last element", cl, last);
            }
            try {
                firstInteger = firstVal.asIntegerValue();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, firstVal, "Non integer first element", new Object[0]);
            }
            try {
                lastInteger = lastVal.asIntegerValue();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, lastVal, "Non integer last element", new Object[0]);
            }
            try {
                firstInt = firstInteger.asInteger();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, firstInteger, "Out of range first element", new Object[0]);
            }
            try {
                lastInt = lastInteger.asInteger();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, lastInteger, "Out of range last element", new Object[0]);
            }
            int increment = lastInt.compareTo(firstInt);
            int i = firstInt;
            while (true) {
                results.add(this.valueFactory.integerValueOf(i));
                if (i == lastInt) continue block14;
                i += increment;
            }
        }
        return this.valueFactory.createCollectionValue(type.isOrdered(), type.isUnique(), type.getElementType(), results);
    }

    public Value visitCollectionRange(CollectionRange range) {
        throw new UnsupportedOperationException("evaluation of CollectionRange");
    }

    public Value visitConstructorExp(ConstructorExp ce) {
        Type type = ce.getType();
        String value = ce.getValue();
        if (value == null) {
            ObjectValue objectValue = type.createInstance(this.valueFactory);
            for (ConstructorPart part : ce.getPart()) {
                Value propertyValue = (Value)part.getInitExpression().accept(this.getUndecoratedVisitor());
                try {
                    part.getReferredProperty().setValue(objectValue, propertyValue);
                }
                catch (InvalidValueException e) {
                    return this.evaluationEnvironment.throwInvalidEvaluation(e);
                }
            }
            return objectValue;
        }
        return type.createInstance(this.valueFactory, value);
    }

    public Value visitEnumLiteralExp(EnumLiteralExp el) {
        return this.valueFactory.createEnumerationLiteralValue((DomainEnumerationLiteral)el.getReferredEnumLiteral());
    }

    public Value visitExpressionInOCL(ExpressionInOCL expression) {
        return this.safeVisit(expression.getBodyExpression());
    }

    public Value visitIfExp(IfExp ifExp) {
        BooleanValue evaluatedCondition;
        OCLExpression condition = ifExp.getCondition();
        try {
            evaluatedCondition = ((Value)condition.accept(this.getUndecoratedVisitor())).asBooleanValue();
        }
        catch (InvalidValueException e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e);
        }
        OCLExpression expression = null;
        expression = evaluatedCondition.isTrue() ? ifExp.getThenExpression() : ifExp.getElseExpression();
        return (Value)expression.accept(this.getUndecoratedVisitor());
    }

    public Value visitIntegerLiteralExp(IntegerLiteralExp integerLiteralExp) {
        BigInteger value = integerLiteralExp.getIntegerSymbol();
        if (value == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Invalid Integer Value", integerLiteralExp);
        }
        return this.valueFactory.integerValueOf(value);
    }

    public Value visitInvalidLiteralExp(InvalidLiteralExp invalidLiteralExp) {
        return this.evaluationEnvironment.throwInvalidEvaluation("Invalid Literal");
    }

    public Value visitIterateExp(IterateExp iterateExp) {
        CollectionValue sourceValue;
        Iteration staticIteration = iterateExp.getReferredIteration();
        EvaluationVisitor undecoratedVisitor = this.getUndecoratedVisitor();
        try {
            OCLExpression source = iterateExp.getSource();
            sourceValue = ((Value)source.accept(undecoratedVisitor)).asCollectionValue();
        }
        catch (InvalidValueException e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e);
        }
        DomainType dynamicSourceType = sourceValue.getType();
        LibraryIteration implementation = (LibraryIteration)dynamicSourceType.lookupImplementation((DomainStandardLibrary)this.metaModelManager, (DomainOperation)staticIteration);
        Value result = null;
        try {
            EvaluatorSingleIterationManager iterationManager;
            Variable accumulator = iterateExp.getResult();
            Value initValue = (Value)accumulator.getInitExpression().accept(undecoratedVisitor);
            if (initValue.isUndefined()) {
                return this.evaluationEnvironment.throwInvalidEvaluation(null, iterateExp, initValue, EvaluatorMessages.UndefinedInitialiser, new Object[0]);
            }
            Parameter accumulatorVariable = accumulator.getRepresentedParameter();
            OCLExpression body = iterateExp.getBody();
            EList<Variable> iterators = iterateExp.getIterator();
            int iSize = iterators.size();
            if (iSize == 1) {
                Parameter firstIterator = ((Variable)iterators.get(0)).getRepresentedParameter();
                iterationManager = new EvaluatorSingleIterationManager((DomainEvaluator)undecoratedVisitor, (DomainExpression)body, sourceValue, (DomainTypedElement)accumulatorVariable, initValue, (DomainTypedElement)firstIterator);
            } else {
                DomainTypedElement[] variables = new VariableDeclaration[iSize];
                int i = 0;
                while (i < iSize) {
                    variables[i] = ((Variable)iterators.get(i)).getRepresentedParameter();
                    ++i;
                }
                iterationManager = new EvaluatorMultipleIterationManager((DomainEvaluator)undecoratedVisitor, (DomainExpression)body, sourceValue, (DomainTypedElement)accumulatorVariable, initValue, variables);
            }
            result = implementation.evaluateIteration((DomainIterationManager)iterationManager);
        }
        catch (InvalidValueException e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e);
        }
        catch (DomainException e) {
            throw e;
        }
        catch (Exception e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e, iterateExp, sourceValue, "Failed to evaluate '" + staticIteration + "'", new Object[0]);
        }
        if (result == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Java-Null result from '" + staticIteration + "'", iterateExp, sourceValue);
        }
        return result;
    }

    public Value visitIteratorExp(IteratorExp iteratorExp) {
        CollectionValue sourceValue;
        Iteration staticIteration = iteratorExp.getReferredIteration();
        EvaluationVisitor undecoratedVisitor = this.getUndecoratedVisitor();
        try {
            OCLExpression source = iteratorExp.getSource();
            Value sourceVal = (Value)source.accept(undecoratedVisitor);
            sourceValue = sourceVal.asCollectionValue();
        }
        catch (InvalidValueException e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e);
        }
        DomainType dynamicSourceType = sourceValue.getType();
        LibraryIteration implementation = (LibraryIteration)dynamicSourceType.lookupImplementation((DomainStandardLibrary)this.metaModelManager, (DomainOperation)staticIteration);
        Value result = null;
        try {
            EvaluatorSingleIterationManager iterationManager;
            OCLExpression body = iteratorExp.getBody();
            Value accumulatorValue = implementation.createAccumulatorValue((DomainEvaluator)undecoratedVisitor, (DomainType)PivotUtil.getBehavioralType(iteratorExp.getType()), (DomainType)PivotUtil.getBehavioralType(body.getType()));
            EList<Variable> iterators = iteratorExp.getIterator();
            int iSize = iterators.size();
            if (iSize == 1) {
                Parameter firstIterator = ((Variable)iterators.get(0)).getRepresentedParameter();
                iterationManager = new EvaluatorSingleIterationManager((DomainEvaluator)undecoratedVisitor, (DomainExpression)body, sourceValue, null, accumulatorValue, (DomainTypedElement)firstIterator);
            } else {
                DomainTypedElement[] variables = new VariableDeclaration[iSize];
                int i = 0;
                while (i < iSize) {
                    variables[i] = ((Variable)iterators.get(i)).getRepresentedParameter();
                    ++i;
                }
                iterationManager = new EvaluatorMultipleIterationManager((DomainEvaluator)undecoratedVisitor, (DomainExpression)body, sourceValue, null, accumulatorValue, variables);
            }
            result = implementation.evaluateIteration((DomainIterationManager)iterationManager);
        }
        catch (InvalidValueException e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e);
        }
        catch (DomainException e) {
            throw e;
        }
        catch (Exception e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e, iteratorExp, sourceValue, "Failed to evaluate '" + staticIteration + "'", new Object[0]);
        }
        if (result == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Java-Null result from '" + staticIteration + "'", iteratorExp, sourceValue);
        }
        return result;
    }

    public Value visitLetExp(LetExp letExp) {
        Value value;
        OCLExpression expression = letExp.getIn();
        Variable variable = letExp.getVariable();
        try {
            value = (Value)variable.accept(this);
        }
        catch (InvalidEvaluationException e) {
            value = this.valueFactory.createInvalidValue(e);
        }
        EvaluationVisitor nestedVisitor = this.getUndecoratedVisitor().createNestedEvaluator();
        nestedVisitor.getEvaluationEnvironment().add(variable, value);
        return (Value)expression.accept(nestedVisitor);
    }

    public Value visitMessageExp(MessageExp m) {
        throw new UnsupportedOperationException("evaluation of MessageExp");
    }

    public Value visitNullLiteralExp(NullLiteralExp nullLiteralExp) {
        return this.valueFactory.getNull();
    }

    public Value visitOperationCallExp(OperationCallExp operationCallExp) {
        LibraryFeature implementation;
        Value sourceValue;
        EvaluationVisitor undecoratedVisitor = this.getUndecoratedVisitor();
        EvaluationVisitor evaluator = undecoratedVisitor.getEvaluator();
        Operation staticOperation = operationCallExp.getReferredOperation();
        OCLExpression source = operationCallExp.getSource();
        try {
            sourceValue = (Value)source.accept(undecoratedVisitor);
        }
        catch (InvalidEvaluationException e) {
            sourceValue = this.valueFactory.createInvalidValue(e);
        }
        DomainType dynamicSourceType = sourceValue.getType();
        EList<OCLExpression> arguments = operationCallExp.getArgument();
        Value onlyArgument = null;
        EList<Parameter> ownedParameters = staticOperation.getOwnedParameter();
        if (ownedParameters.size() == 1 && ((Parameter)ownedParameters.get(0)).getType() instanceof SelfType) {
            onlyArgument = (Value)((OCLExpression)arguments.get(0)).accept(undecoratedVisitor);
            DomainType argType = onlyArgument.getType();
            dynamicSourceType = dynamicSourceType.getCommonType((DomainStandardLibrary)this.metaModelManager, argType);
        }
        if ((implementation = dynamicSourceType.lookupImplementation((DomainStandardLibrary)this.metaModelManager, (DomainOperation)staticOperation)) == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("No implementation for '" + staticOperation + "'", operationCallExp, sourceValue);
        }
        try {
            Value result = null;
            int iSize = arguments.size();
            switch (iSize) {
                case 0: {
                    result = ((LibraryUnaryOperation)implementation).evaluate((DomainEvaluator)evaluator, (DomainCallExp)operationCallExp, sourceValue, new Value[0]);
                    break;
                }
                case 1: {
                    LibraryBinaryOperation binaryOperation = (LibraryBinaryOperation)implementation;
                    if (onlyArgument == null) {
                        if (binaryOperation.argumentsMayBeInvalid()) {
                            try {
                                onlyArgument = (Value)((OCLExpression)arguments.get(0)).accept(undecoratedVisitor);
                            }
                            catch (InvalidEvaluationException e) {
                                onlyArgument = this.valueFactory.createInvalidValue(e);
                            }
                        } else {
                            onlyArgument = (Value)((OCLExpression)arguments.get(0)).accept(undecoratedVisitor);
                        }
                    }
                    result = binaryOperation.evaluate((DomainEvaluator)evaluator, (DomainCallExp)operationCallExp, sourceValue, new Value[]{onlyArgument});
                    break;
                }
                case 2: {
                    Value firstArgument = (Value)((OCLExpression)arguments.get(0)).accept(undecoratedVisitor);
                    Value secondArgument = (Value)((OCLExpression)arguments.get(1)).accept(undecoratedVisitor);
                    result = ((LibraryTernaryOperation)implementation).evaluate((DomainEvaluator)evaluator, (DomainCallExp)operationCallExp, sourceValue, new Value[]{firstArgument, secondArgument});
                    break;
                }
                default: {
                    Value[] values = new Value[iSize];
                    int i = 0;
                    while (i < iSize) {
                        values[i] = (Value)((OCLExpression)arguments.get(i)).accept(undecoratedVisitor);
                        ++i;
                    }
                    result = ((LibraryOperation)implementation).evaluate((DomainEvaluator)evaluator, (DomainCallExp)operationCallExp, sourceValue, values);
                }
            }
            if (result == null) {
                return this.evaluationEnvironment.throwInvalidEvaluation("Java-Null result from '" + staticOperation + "'", operationCallExp, sourceValue);
            }
            return result;
        }
        catch (InvalidValueException e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e);
        }
        catch (DomainException e) {
            throw e;
        }
        catch (Exception e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e, operationCallExp, sourceValue, "Failed to evaluate '" + staticOperation + "'", new Object[0]);
        }
    }

    public Value visitPropertyCallExp(PropertyCallExp propertyCallExp) {
        LibraryProperty implementation;
        Property property = propertyCallExp.getReferredProperty();
        try {
            implementation = (LibraryProperty)this.metaModelManager.getImplementation(property);
        }
        catch (Exception e) {
            String implementationClass = property.getImplementationClass();
            if (implementationClass != null) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, propertyCallExp, null, EvaluatorMessages.ImplementationClassLoadFailure, implementationClass);
            }
            return this.evaluationEnvironment.throwInvalidEvaluation(e, propertyCallExp, null, "Failed to load implementation for '" + property + "'", new Object[0]);
        }
        OCLExpression source = propertyCallExp.getSource();
        EvaluationVisitor evaluationVisitor = this.getUndecoratedVisitor();
        Value sourceValue = (Value)source.accept(evaluationVisitor);
        Value resultValue = null;
        try {
            resultValue = implementation.evaluate((DomainEvaluator)this, (DomainType)propertyCallExp.getType(), sourceValue, (DomainProperty)propertyCallExp.getReferredProperty());
        }
        catch (DomainException e) {
            throw e;
        }
        catch (Exception e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e, propertyCallExp, sourceValue, "Failed to evaluate '" + property + "'", new Object[0]);
        }
        if (resultValue == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation(null, propertyCallExp, sourceValue, "Java-Null result from '" + property + "'", new Object[0]);
        }
        return resultValue;
    }

    public Value visitRealLiteralExp(RealLiteralExp realLiteralExp) {
        BigDecimal value = realLiteralExp.getRealSymbol();
        if (value == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Invalid Real Value", realLiteralExp);
        }
        return this.valueFactory.realValueOf(value);
    }

    public Value visitStateExp(StateExp s) {
        return this.valueFactory.createElementValue((DomainElement)s.getReferredState());
    }

    public Value visitStringLiteralExp(StringLiteralExp stringLiteralExp) {
        String value = stringLiteralExp.getStringSymbol();
        if (value == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Invalid String Value", stringLiteralExp);
        }
        return this.valueFactory.stringValueOf(value);
    }

    public Value visitTupleLiteralExp(TupleLiteralExp tl) {
        Type type = tl.getType();
        HashMap<TupleLiteralPart, Value> propertyValues = new HashMap<TupleLiteralPart, Value>();
        for (TupleLiteralPart part : tl.getPart()) {
            propertyValues.put(part, (Value)part.accept(this.getUndecoratedVisitor()));
        }
        return this.valueFactory.createTupleValue((DomainTupleType)((TupleType)type), propertyValues);
    }

    public Value visitTupleLiteralPart(TupleLiteralPart tp) {
        return (Value)tp.getInitExpression().accept(this.getUndecoratedVisitor());
    }

    public Value visitTypeExp(TypeExp t) {
        return this.valueFactory.createTypeValue(((DomainClassifierType)t.getType()).getInstanceType());
    }

    public Value visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp unlimitedNaturalLiteralExp) {
        BigInteger value = unlimitedNaturalLiteralExp.getUnlimitedNaturalSymbol();
        if (value == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Invalid Unlimited Natural Value", unlimitedNaturalLiteralExp);
        }
        if (value.signum() < 0) {
            return this.valueFactory.getUnlimited();
        }
        return this.valueFactory.integerValueOf(value);
    }

    public Value visitUnspecifiedValueExp(UnspecifiedValueExp uv) {
        throw new UnsupportedOperationException("evaluation of UnspecifiedValueExp");
    }

    public Value visitVariable(Variable variable) {
        OCLExpression initExp = variable.getInitExpression();
        if (initExp == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Uninitialized variable", null, variable);
        }
        return (Value)initExp.accept(this.getUndecoratedVisitor());
    }

    public Value visitVariableExp(VariableExp variableExp) {
        Value value;
        Parameter representedParameter;
        VariableDeclaration variableDeclaration = variableExp.getReferredVariable();
        if (variableDeclaration instanceof Variable && (representedParameter = ((Variable)variableDeclaration).getRepresentedParameter()) != null) {
            variableDeclaration = representedParameter;
        }
        if ((value = this.evaluationEnvironment.getValueOf(variableDeclaration)) == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Undefined variable '" + variableDeclaration.getName() + "'", variableExp);
        }
        if (value.isInvalid()) {
            Exception e = ((InvalidValue)value).getException();
            return this.evaluationEnvironment.throwInvalidEvaluation(e, variableExp, null, "Invalid variable '" + variableDeclaration.getName() + "'", new Object[0]);
        }
        return value;
    }

    public Value visiting(Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for EvaluationVisitor");
    }
}

