/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractOperation;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryTernaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryUnaryOperation;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;

public class ConstrainedOperation
extends AbstractOperation
implements LibraryUnaryOperation,
LibraryBinaryOperation,
LibraryTernaryOperation {
    protected final ExpressionInOCL expressionInOCL;

    public ConstrainedOperation(ExpressionInOCL expressionInOCL) {
        this.expressionInOCL = expressionInOCL;
    }

    public Value evaluate(DomainEvaluator evaluator, DomainCallExp callExp, Value sourceValue, Value ... argumentValues) throws InvalidEvaluationException, InvalidValueException {
        EvaluationVisitor evaluationVisitor = (EvaluationVisitor)evaluator;
        EvaluationVisitor nestedVisitor = evaluationVisitor.createNestedEvaluator();
        EvaluationEnvironment nestedEvaluationEnvironment = nestedVisitor.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add(this.expressionInOCL.getContextVariable(), sourceValue);
        EList<Variable> parameters = this.expressionInOCL.getParameterVariable();
        if (!parameters.isEmpty()) {
            EList<OCLExpression> arguments = ((OperationCallExp)callExp).getArgument();
            int i = 0;
            while (i < parameters.size()) {
                OCLExpression argument = (OCLExpression)arguments.get(i);
                Value value = (Value)argument.accept(evaluationVisitor);
                nestedEvaluationEnvironment.add(((Variable)parameters.get(i)).getRepresentedParameter(), value);
                ++i;
            }
        }
        return (Value)this.expressionInOCL.accept(nestedVisitor);
    }

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue) throws InvalidValueException {
        EvaluationVisitor evaluationVisitor = (EvaluationVisitor)evaluator;
        EvaluationVisitor nestedVisitor = evaluationVisitor.createNestedEvaluator();
        EvaluationEnvironment nestedEvaluationEnvironment = nestedVisitor.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add(this.expressionInOCL.getContextVariable(), sourceValue);
        return (Value)this.expressionInOCL.accept(nestedVisitor);
    }

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue, Value argumentValue) throws InvalidValueException {
        EvaluationVisitor evaluationVisitor = (EvaluationVisitor)evaluator;
        EvaluationVisitor nestedVisitor = evaluationVisitor.createNestedEvaluator();
        EvaluationEnvironment nestedEvaluationEnvironment = nestedVisitor.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add(this.expressionInOCL.getContextVariable(), sourceValue);
        EList<Variable> parameters = this.expressionInOCL.getParameterVariable();
        nestedEvaluationEnvironment.add(((Variable)parameters.get(0)).getRepresentedParameter(), argumentValue);
        return (Value)this.expressionInOCL.accept(nestedVisitor);
    }

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue, Value firstArgumentValue, Value secondArgumentValue) throws InvalidValueException {
        EvaluationVisitor evaluationVisitor = (EvaluationVisitor)evaluator;
        EvaluationVisitor nestedVisitor = evaluationVisitor.createNestedEvaluator();
        EvaluationEnvironment nestedEvaluationEnvironment = nestedVisitor.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add(this.expressionInOCL.getContextVariable(), sourceValue);
        EList<Variable> parameters = this.expressionInOCL.getParameterVariable();
        nestedEvaluationEnvironment.add(((Variable)parameters.get(0)).getRepresentedParameter(), firstArgumentValue);
        nestedEvaluationEnvironment.add(((Variable)parameters.get(1)).getRepresentedParameter(), secondArgumentValue);
        return (Value)this.expressionInOCL.accept(nestedVisitor);
    }
}

