/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EMOFResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.utilities.ProjectMap;
import org.eclipse.ocl.examples.domain.utilities.StandaloneProjectMap;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.library.executor.ReflectiveType;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Model;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.library.StandardLibraryContribution;
import org.eclipse.ocl.examples.pivot.manager.ImplementationManager;
import org.eclipse.ocl.examples.pivot.manager.LambdaTypeManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManageable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerListener;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.PackageTracker;
import org.eclipse.ocl.examples.pivot.manager.PivotStandardLibrary;
import org.eclipse.ocl.examples.pivot.manager.PrecedenceManager;
import org.eclipse.ocl.examples.pivot.manager.TupleTypeManager;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.manager.TypeTracker;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.model.OCLMetaModel;
import org.eclipse.ocl.examples.pivot.uml.UML2Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.util.Nameable;
import org.eclipse.ocl.examples.pivot.utilities.CompleteElementIterable;
import org.eclipse.ocl.examples.pivot.utilities.External2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.PivotResourceFactoryImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.values.PivotValueFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModelManager
extends PivotStandardLibrary
implements Adapter.Internal,
MetaModelManageable {
    private static Set<Factory> factoryMap = new HashSet<Factory>();
    private static final Logger logger;
    private final PackageManager packageManager = this.createPackageManager();
    private PrecedenceManager precedenceManager = null;
    private TupleTypeManager tupleManager = null;
    private LambdaTypeManager lambdaManager = null;
    private ImplementationManager implementationManager = null;
    private ValueFactory valueFactory = null;
    private Resource orphanage = null;
    protected Package pivotMetaModel = null;
    private boolean libraryLoadInProgress = false;
    protected final ResourceSet pivotResourceSet;
    protected final List<Library> pivotLibraries = new ArrayList<Library>();
    protected Resource pivotLibraryResource = null;
    protected ResourceSetImpl externalResourceSet = null;
    private final Map<String, Namespace> globalNamespaces = new HashMap<String, Namespace>();
    private final Set<Type> globalTypes = new HashSet<Type>();
    private int unspecifiedTypeCount = 0;
    private final Map<URI, External2Pivot> external2PivotMap = new HashMap<URI, External2Pivot>();
    private Map<Object, URI> uriMap = null;
    private EAnnotation lockingAnnotation = null;
    private List<MetaModelManagerListener> listeners = null;

    static {
        Ecore2Pivot.FACTORY.getClass();
        UML2Ecore2Pivot.FACTORY.getClass();
        logger = Logger.getLogger(MetaModelManager.class);
    }

    public static void addFactory(Factory factory) {
        factoryMap.add(factory);
    }

    public static MetaModelManager findAdapter(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        return PivotUtil.getAdapter(MetaModelManager.class, (Notifier)resourceSet);
    }

    public static MetaModelManager getAdapter(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        EList eAdapters = resourceSet.eAdapters();
        MetaModelManager adapter = PivotUtil.getAdapter(MetaModelManager.class, (List<Adapter>)eAdapters);
        if (adapter == null) {
            adapter = new MetaModelManager(resourceSet);
            eAdapters.add(adapter);
        }
        return adapter;
    }

    public static void initializePivotResourceSet(ResourceSet pivotResourceSet) {
        StandaloneProjectMap.initializeURIResourceMap((ResourceSet)pivotResourceSet);
        Resource.Factory.Registry resourceFactoryRegistry = pivotResourceSet.getResourceFactoryRegistry();
        Map contentTypeToFactoryMap = resourceFactoryRegistry.getContentTypeToFactoryMap();
        contentTypeToFactoryMap.put("org.eclipse.ocl.examples.pivot", new PivotResourceFactoryImpl());
        Map extensionToFactoryMap = resourceFactoryRegistry.getExtensionToFactoryMap();
        extensionToFactoryMap.put("*", new XMIResourceFactoryImpl());
        extensionToFactoryMap.put("pivot", new PivotResourceFactoryImpl());
        EPackage.Registry packageRegistry = pivotResourceSet.getPackageRegistry();
        packageRegistry.put((Object)"http://www.eclipse.org/ocl/3.1.0/Pivot", (Object)PivotPackage.eINSTANCE);
    }

    public MetaModelManager() {
        this((ResourceSet)new ResourceSetImpl());
        MetaModelManager.initializePivotResourceSet(this.pivotResourceSet);
    }

    public MetaModelManager(StandaloneProjectMap projectMap) {
        this((ResourceSet)new ResourceSetImpl());
        this.pivotResourceSet.eAdapters().add((Object)projectMap);
        MetaModelManager.initializePivotResourceSet(this.pivotResourceSet);
    }

    public MetaModelManager(ResourceSet pivotResourceSet) {
        this.pivotResourceSet = pivotResourceSet;
        pivotResourceSet.eAdapters().add((Object)this);
    }

    public void addClassLoader(ClassLoader classLoader) {
        ImplementationManager implementationManager = this.getImplementationManager();
        implementationManager.addClassLoader(classLoader);
    }

    public void addExternalResource(External2Pivot external2Pivot) {
        this.external2PivotMap.put(external2Pivot.getURI(), external2Pivot);
    }

    public Namespace addGlobalNamespace(String name, Namespace namespace) {
        return this.globalNamespaces.put(name, namespace);
    }

    public boolean addGlobalTypes(Collection<Type> types) {
        return this.globalTypes.addAll(types);
    }

    public void addListener(MetaModelManagerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<MetaModelManagerListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addLockedElement(Object lockedElement) {
        if (lockedElement instanceof EObject) {
            EList lockingReferences;
            if (this.lockingAnnotation == null) {
                this.lockingAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            }
            if (!(lockingReferences = this.lockingAnnotation.getReferences()).contains(lockedElement)) {
                lockingReferences.add((EObject)lockedElement);
            }
        }
    }

    public void addOrphanClass(Type pivotElement) {
        if (pivotElement.getUnspecializedElement() != null ? !$assertionsDisabled && pivotElement.getUnspecializedElement().getUnspecializedElement() != null : !$assertionsDisabled && !(pivotElement instanceof LambdaType) && !(pivotElement instanceof TupleType) && !(pivotElement instanceof UnspecifiedType)) {
            throw new AssertionError();
        }
        this.getOrphanResource().getContents().add((Object)pivotElement);
    }

    public void addPackage(Package pivotPackage) {
        this.packageManager.addPackage(pivotPackage);
    }

    public int compareOperationMatches(Operation reference, Map<TemplateParameter, ParameterableElement> referenceBindings, Operation candidate, Map<TemplateParameter, ParameterableElement> candidateBindings) {
        if (reference instanceof Iteration && candidate instanceof Iteration) {
            int iteratorCountDelta = ((Iteration)candidate).getOwnedIterator().size() - ((Iteration)reference).getOwnedIterator().size();
            if (iteratorCountDelta != 0) {
                return iteratorCountDelta;
            }
            Type referenceType = PivotUtil.getOwningType((Iteration)reference);
            Type candidateType = PivotUtil.getOwningType((Iteration)candidate);
            Type specializedReferenceType = this.getSpecializedType(referenceType, referenceBindings);
            Type specializedCandidateType = this.getSpecializedType(candidateType, candidateBindings);
            if (referenceType != candidateType) {
                if (this.conformsTo(specializedReferenceType, specializedCandidateType, null)) {
                    return 1;
                }
                if (this.conformsTo(specializedCandidateType, specializedReferenceType, null)) {
                    return -1;
                }
            }
        }
        EList<Parameter> candidateParameters = candidate.getOwnedParameter();
        EList<Parameter> referenceParameters = reference.getOwnedParameter();
        int parameterCountDelta = candidateParameters.size() - referenceParameters.size();
        if (parameterCountDelta != 0) {
            return parameterCountDelta;
        }
        boolean referenceConformsToCandidate = true;
        boolean candidateConformsReference = true;
        int i = 0;
        while (i < candidateParameters.size()) {
            Type referenceType = this.getTypeWithMultiplicity((TypedMultiplicityElement)referenceParameters.get(i));
            Type candidateType = this.getTypeWithMultiplicity((TypedMultiplicityElement)candidateParameters.get(i));
            Type specializedReferenceType = this.getSpecializedType(referenceType, referenceBindings);
            Type specializedCandidateType = this.getSpecializedType(candidateType, candidateBindings);
            if (referenceType != candidateType) {
                if (!this.conformsTo(specializedReferenceType, specializedCandidateType, null)) {
                    referenceConformsToCandidate = false;
                }
                if (!this.conformsTo(specializedCandidateType, specializedReferenceType, null)) {
                    candidateConformsReference = false;
                }
            }
            ++i;
        }
        if (referenceConformsToCandidate != candidateConformsReference) {
            return referenceConformsToCandidate ? 1 : -1;
        }
        Type referenceType = PivotUtil.getOwningType(reference);
        Type candidateType = PivotUtil.getOwningType(candidate);
        Type specializedReferenceType = this.getSpecializedType(referenceType, referenceBindings);
        Type specializedCandidateType = this.getSpecializedType(candidateType, candidateBindings);
        if (referenceType != candidateType) {
            if (this.conformsTo(specializedReferenceType, specializedCandidateType, null)) {
                return 1;
            }
            if (this.conformsTo(specializedCandidateType, specializedReferenceType, null)) {
                return -1;
            }
        }
        return 0;
    }

    @Deprecated
    public boolean conformsTo(Type firstType, Type secondType) {
        return this.conformsTo(firstType, secondType, null);
    }

    public boolean conformsTo(Type firstType, Type secondType, Map<TemplateParameter, ParameterableElement> bindings) {
        if (firstType == null || secondType == null) {
            return false;
        }
        if (bindings != null) {
            TemplateParameter secondTemplateParameter;
            ParameterableElement parameterableElement;
            TemplateParameter firstTemplateParameter = firstType.getOwningTemplateParameter();
            if (firstTemplateParameter != null && (parameterableElement = bindings.get(firstTemplateParameter)) instanceof Type) {
                firstType = (Type)parameterableElement;
            }
            if ((secondTemplateParameter = secondType.getOwningTemplateParameter()) != null) {
                ParameterableElement parameterableElement2 = bindings.get(secondTemplateParameter);
                if (parameterableElement2 instanceof Type) {
                    secondType = (Type)parameterableElement2;
                } else if (parameterableElement2 == null && bindings.containsKey(secondTemplateParameter)) {
                    bindings.put(secondTemplateParameter, firstType);
                    return true;
                }
            }
        }
        if (firstType == secondType) {
            return true;
        }
        if ((firstType = this.getPrimaryType(firstType)) == (secondType = this.getPrimaryType(secondType))) {
            return true;
        }
        if (secondType instanceof AnyType) {
            return true;
        }
        if (firstType instanceof AnyType) {
            return false;
        }
        if (firstType instanceof InvalidType) {
            return true;
        }
        if (secondType instanceof InvalidType) {
            return false;
        }
        if (firstType instanceof VoidType) {
            return true;
        }
        if (secondType instanceof VoidType) {
            return false;
        }
        if (firstType instanceof ClassifierType) {
            if (secondType instanceof ClassifierType) {
                return this.conformsToClassifierType((ClassifierType)firstType, (ClassifierType)secondType, bindings);
            }
        } else {
            if (firstType instanceof CollectionType) {
                if (secondType instanceof CollectionType) {
                    return this.conformsToCollectionType((CollectionType)firstType, (CollectionType)secondType, bindings);
                }
                return false;
            }
            if (firstType instanceof LambdaType) {
                if (secondType instanceof LambdaType) {
                    return this.conformsToLambdaType((LambdaType)firstType, (LambdaType)secondType, bindings);
                }
                return false;
            }
            if (firstType instanceof TupleType) {
                if (secondType instanceof TupleType) {
                    return this.conformsToTupleType((TupleType)firstType, (TupleType)secondType, bindings);
                }
                return false;
            }
        }
        for (Type superClass : this.getSuperClasses(firstType)) {
            if (!this.conformsTo(superClass, secondType, bindings)) continue;
            return true;
        }
        return false;
    }

    protected boolean conformsToClassifierType(ClassifierType firstType, ClassifierType secondType, Map<TemplateParameter, ParameterableElement> bindings) {
        Type firstElementType = firstType.getInstanceType();
        Type secondElementType = secondType.getInstanceType();
        if (bindings != null) {
            TemplateParameter secondTemplateParameter;
            ParameterableElement parameterableElement;
            TemplateParameter firstTemplateParameter = firstElementType.getOwningTemplateParameter();
            if (firstTemplateParameter != null && (parameterableElement = bindings.get(firstTemplateParameter)) instanceof Type) {
                firstElementType = (Type)parameterableElement;
            }
            if ((secondTemplateParameter = secondElementType.getOwningTemplateParameter()) != null) {
                ParameterableElement parameterableElement2 = bindings.get(secondTemplateParameter);
                if (parameterableElement2 instanceof Type) {
                    secondElementType = (Type)parameterableElement2;
                } else if (parameterableElement2 == null && bindings.containsKey(secondTemplateParameter)) {
                    bindings.put(secondTemplateParameter, firstElementType);
                    return true;
                }
            }
        }
        if (firstElementType instanceof UnspecifiedType) {
            Type lowerBound = ((UnspecifiedType)firstElementType).getLowerBound();
            if (this.conformsTo(secondElementType, lowerBound, bindings)) {
                ((UnspecifiedType)firstElementType).setLowerBound(secondElementType);
                return true;
            }
            return false;
        }
        if (secondElementType instanceof UnspecifiedType) {
            Type upperBound = ((UnspecifiedType)secondElementType).getUpperBound();
            if (this.conformsTo(upperBound, firstElementType, bindings)) {
                ((UnspecifiedType)secondElementType).setUpperBound(firstElementType);
                return true;
            }
            return false;
        }
        return this.conformsTo(firstElementType, secondElementType, bindings);
    }

    public Collection<Package> computePivotRootPackages() {
        HashSet<Package> rootPackages = new HashSet<Package>();
        if (this.pivotLibraryResource != null) {
            for (EObject eObject : this.pivotLibraryResource.getContents()) {
                if (!(eObject instanceof Package)) continue;
                rootPackages.add((Package)eObject);
            }
        }
        for (Resource pivotResource : this.pivotResourceSet.getResources()) {
            for (EObject eObject : pivotResource.getContents()) {
                if (!(eObject instanceof Package)) continue;
                rootPackages.add((Package)eObject);
            }
        }
        return rootPackages;
    }

    public boolean conformsToCollectionType(DomainCollectionType firstCollectionType, DomainCollectionType secondCollectionType) {
        return this.conformsToCollectionType((CollectionType)firstCollectionType, (CollectionType)secondCollectionType, null);
    }

    protected boolean conformsToCollectionType(CollectionType firstType, CollectionType secondType, Map<TemplateParameter, ParameterableElement> bindings) {
        CollectionType unspecializedFirstType = PivotUtil.getUnspecializedTemplateableElement(firstType);
        CollectionType unspecializedSecondType = PivotUtil.getUnspecializedTemplateableElement(secondType);
        if (!this.isSuperClassOf(unspecializedSecondType, unspecializedFirstType)) {
            return false;
        }
        Type firstElementType = firstType.getElementType();
        Type secondElementType = secondType.getElementType();
        if (bindings != null) {
            TemplateParameter secondTemplateParameter;
            ParameterableElement parameterableElement;
            TemplateParameter firstTemplateParameter;
            if (firstElementType != null && (firstTemplateParameter = firstElementType.getOwningTemplateParameter()) != null && (parameterableElement = bindings.get(firstTemplateParameter)) instanceof Type) {
                firstElementType = (Type)parameterableElement;
            }
            if (secondElementType != null && (secondTemplateParameter = secondElementType.getOwningTemplateParameter()) != null) {
                parameterableElement = bindings.get(secondTemplateParameter);
                if (parameterableElement instanceof Type) {
                    secondElementType = (Type)parameterableElement;
                } else if (parameterableElement == null && bindings.containsKey(secondTemplateParameter)) {
                    bindings.put(secondTemplateParameter, firstElementType);
                    return true;
                }
            }
        }
        if (firstElementType instanceof UnspecifiedType) {
            Type lowerBound = ((UnspecifiedType)firstElementType).getLowerBound();
            if (this.conformsTo(secondElementType, lowerBound, bindings)) {
                ((UnspecifiedType)firstElementType).setLowerBound(secondElementType);
                return true;
            }
            return false;
        }
        if (secondElementType instanceof UnspecifiedType) {
            Type upperBound = ((UnspecifiedType)secondElementType).getUpperBound();
            if (this.conformsTo(upperBound, firstElementType, bindings)) {
                ((UnspecifiedType)secondElementType).setUpperBound(firstElementType);
                return true;
            }
            return false;
        }
        return this.conformsTo(firstElementType, secondElementType, bindings);
    }

    protected boolean conformsToLambdaType(LambdaType actualType, LambdaType requiredType, Map<TemplateParameter, ParameterableElement> bindings) {
        Type requiredContextType;
        Type actualContextType = actualType.getContextType();
        if (!this.conformsTo(actualContextType, requiredContextType = requiredType.getContextType(), bindings)) {
            return false;
        }
        Type actualResultType = actualType.getResultType();
        Type requiredResultType = requiredType.getResultType();
        if (!this.conformsTo(requiredResultType, actualResultType, bindings)) {
            return false;
        }
        EList<Type> actualParameterTypes = actualType.getParameterType();
        EList<Type> requiredParameterTypes = requiredType.getParameterType();
        int iMax = actualParameterTypes.size();
        if (iMax != requiredParameterTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < iMax) {
            Type requiredParameterType;
            Type actualParameterType = (Type)actualParameterTypes.get(i);
            if (!this.conformsTo(actualParameterType, requiredParameterType = (Type)requiredParameterTypes.get(i), bindings)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean conformsToTupleType(TupleType actualType, TupleType requiredType, Map<TemplateParameter, ParameterableElement> bindings) {
        EList<Property> actualProperties = actualType.getOwnedAttribute();
        EList<Property> requiredProperties = requiredType.getOwnedAttribute();
        if (actualProperties.size() != requiredProperties.size()) {
            return false;
        }
        for (Property actualProperty : actualProperties) {
            Property requiredProperty = PivotUtil.getNamedElement(requiredProperties, actualProperty.getName());
            if (requiredProperty == null) {
                return false;
            }
            if (this.conformsTo(actualProperty.getType(), requiredProperty.getType(), bindings)) continue;
            return false;
        }
        return true;
    }

    protected ImplementationManager createImplementationManager() {
        return new ImplementationManager(this);
    }

    public InvalidLiteralExp createInvalidExpression() {
        InvalidLiteralExp invalidLiteralExp = PivotFactory.eINSTANCE.createInvalidLiteralExp();
        invalidLiteralExp.setType(this.getOclInvalidType());
        return invalidLiteralExp;
    }

    protected LambdaTypeManager createLambdaManager() {
        return new LambdaTypeManager(this);
    }

    public Model createModel(String string, String nsURI) {
        return this.createPackage(Model.class, PivotPackage.Literals.MODEL, string, nsURI);
    }

    protected Resource createOrphanage() {
        return Orphanage.getOrphanage(this.pivotResourceSet);
    }

    public <T extends Package> T createPackage(Class<T> pivotClass, EClass pivotEClass, String name, String nsURI) {
        Package pivotPackage = (Package)pivotEClass.getEPackage().getEFactoryInstance().create(pivotEClass);
        pivotPackage.setName(name);
        pivotPackage.setNsURI(nsURI);
        this.addPackage(pivotPackage);
        return (T)pivotPackage;
    }

    protected PackageManager createPackageManager() {
        return new PackageManager(this);
    }

    protected PrecedenceManager createPrecedenceManager() {
        PrecedenceManager precedenceManager = new PrecedenceManager();
        Collection<Package> rootPackages = this.computePivotRootPackages();
        List<String> errors = precedenceManager.compilePrecedences(rootPackages);
        for (String error : errors) {
            logger.error((Object)error);
        }
        return precedenceManager;
    }

    public Resource createResource(URI uri, String contentType) {
        return this.pivotResourceSet.createResource(uri, contentType);
    }

    protected TupleTypeManager createTupleManager() {
        return new TupleTypeManager(this);
    }

    public UnspecifiedType createUnspecifiedType() {
        String value = "<unspecified:" + this.unspecifiedTypeCount++ + ">";
        UnspecifiedType unspecifiedType = PivotFactory.eINSTANCE.createUnspecifiedType();
        unspecifiedType.setName(value);
        unspecifiedType.setLowerBound(this.getOclAnyType());
        unspecifiedType.setUpperBound(this.getOclVoidType());
        this.addOrphanClass(unspecifiedType);
        return unspecifiedType;
    }

    protected ValueFactory createValueFactory() {
        return new PivotValueFactory(this);
    }

    @Override
    public void dispose() {
        if (this.listeners != null) {
            List<MetaModelManagerListener> savedListeners = this.listeners;
            this.listeners = null;
            for (MetaModelManagerListener listener : savedListeners) {
                listener.metaModelManagerDisposed(this);
            }
        }
        this.pivotResourceSet.eAdapters().remove((Object)this);
        this.pivotResourceSet.getPackageRegistry().clear();
        for (Resource resource : this.pivotResourceSet.getResources()) {
            resource.unload();
        }
        this.pivotResourceSet.getResources().clear();
        this.pivotLibraries.clear();
        this.pivotLibraryResource = null;
        if (this.externalResourceSet != null) {
            for (Resource resource : this.externalResourceSet.getResources()) {
                resource.unload();
            }
        }
        this.externalResourceSet = null;
        this.globalNamespaces.clear();
        this.globalTypes.clear();
        this.external2PivotMap.clear();
        this.uriMap = null;
        this.lockingAnnotation = null;
        this.packageManager.dispose();
        if (this.tupleManager != null) {
            this.tupleManager.dispose();
            this.tupleManager = null;
        }
        if (this.lambdaManager != null) {
            this.lambdaManager.dispose();
            this.lambdaManager = null;
        }
        if (this.precedenceManager != null) {
            this.precedenceManager.dispose();
            this.precedenceManager = null;
        }
        if (this.implementationManager != null) {
            this.implementationManager.dispose();
            this.implementationManager = null;
        }
        if (this.valueFactory != null) {
            this.valueFactory.dispose();
            this.valueFactory = null;
        }
        this.orphanage = null;
        this.pivotMetaModel = null;
        super.dispose();
    }

    public PackageTracker findPackageTracker(Package pivotPackage) {
        return this.packageManager.findPackageTracker(pivotPackage);
    }

    public TypeTracker findTypeTracker(Type pivotType) {
        return this.packageManager.findTypeTracker(pivotType);
    }

    public Iterable<Constraint> getAllConstraints(Type pivotType) {
        if (pivotType == null) {
            return Collections.emptyList();
        }
        Set<Constraint> allConstraints = this.getAllConstraints(pivotType, null);
        if (allConstraints != null) {
            return allConstraints;
        }
        return Collections.emptyList();
    }

    protected Set<Constraint> getAllConstraints(Type type, Set<Constraint> knownConstraints) {
        for (Constraint constraint : this.getLocalConstraints(type)) {
            if (knownConstraints == null) {
                knownConstraints = new HashSet<Constraint>();
                knownConstraints.add(constraint);
                continue;
            }
            if (knownConstraints.add(constraint)) continue;
            return knownConstraints;
        }
        for (Type superType : this.getSuperClasses(type)) {
            knownConstraints = this.getAllConstraints(superType, knownConstraints);
        }
        return knownConstraints;
    }

    public Iterable<Operation> getAllOperations(Operation pivotOperation) {
        if (pivotOperation == null) {
            return Collections.emptyList();
        }
        Type pivotClass = pivotOperation.getOwningType();
        TypeTracker typeTracker = this.packageManager.findTypeTracker(pivotClass);
        if (typeTracker != null) {
            return typeTracker.getTypeServer().getOperations(pivotOperation);
        }
        return Collections.singletonList(pivotOperation);
    }

    public Iterable<Package> getAllPackages() {
        if (!this.libraryLoadInProgress && this.pivotMetaModel == null) {
            this.lazyLoadPivotMetaModel();
        }
        return this.packageManager.getAllPackages();
    }

    public Iterable<Package> getAllPackages(Package pkg, boolean loadPivotMetaModelFirst) {
        PackageTracker packageTracker;
        if (!this.libraryLoadInProgress && loadPivotMetaModelFirst && this.pivotMetaModel == null) {
            this.lazyLoadPivotMetaModel();
        }
        if ((packageTracker = this.packageManager.findPackageTracker(pkg)) != null) {
            return packageTracker.getPackageServer().getPackages();
        }
        return Collections.singletonList(pkg);
    }

    public Iterable<Property> getAllProperties(Property pivotProperty) {
        if (pivotProperty == null) {
            return Collections.emptyList();
        }
        Type pivotClass = pivotProperty.getOwningType();
        TypeTracker typeTracker = this.packageManager.findTypeTracker(pivotClass);
        if (typeTracker != null) {
            return typeTracker.getTypeServer().getProperties(pivotProperty);
        }
        return Collections.singletonList(pivotProperty);
    }

    public Iterable<Type> getAllTypes(Type pivotType) {
        if (pivotType == null) {
            return Collections.emptyList();
        }
        TypeTracker typeTracker = this.packageManager.findTypeTracker(pivotType);
        if (typeTracker != null) {
            return typeTracker.getTypeServer().getTypes();
        }
        return Collections.singletonList(pivotType);
    }

    public CollectionType getBagType(DomainType elementType) {
        return this.getBagType(this.getType(elementType));
    }

    public CollectionType getBagType(Type elementType) {
        return this.getLibraryType(this.getBagType(), Collections.singletonList(elementType));
    }

    public ClassifierType getClassifierType(DomainType instanceType) {
        return this.getClassifierType(this.getType(instanceType));
    }

    public ClassifierType getClassifierType(Type instanceType) {
        ClassifierType classifierType;
        ArrayList<Type> templateArguments = new ArrayList<Type>();
        templateArguments.add(instanceType);
        if (instanceType instanceof Enumeration) {
            classifierType = this.getEnumerationClassifierType();
        } else if (instanceType instanceof CollectionType) {
            classifierType = this.getCollectionClassifierType();
            templateArguments.add(((CollectionType)instanceType).getElementType());
        } else {
            classifierType = this.getClassClassifierType();
        }
        return this.getLibraryType(classifierType, templateArguments);
    }

    public CollectionType getCollectionType(boolean isOrdered, boolean isUnique) {
        if (isOrdered) {
            if (isUnique) {
                return this.getOrderedSetType();
            }
            return this.getSequenceType();
        }
        if (isUnique) {
            return this.getSetType();
        }
        return this.getBagType();
    }

    public CollectionType getCollectionType(boolean isOrdered, boolean isUnique, Type elementType) {
        return this.getLibraryType(this.getCollectionType(isOrdered, isUnique), Collections.singletonList(elementType));
    }

    public Type getCollectionType(String collectionTypeName, Type elementType) {
        if (elementType == null || elementType.eIsProxy()) {
            return this.getOclInvalidType();
        }
        return this.getLibraryType((Type)((Object)collectionTypeName), (List<? extends ParameterableElement>)Collections.singletonList(elementType));
    }

    public CollectionType getCollectionType(DomainType genericType, DomainType elementType) {
        return this.getLibraryType((CollectionType)this.getType(genericType), Collections.singletonList(this.getType(elementType)));
    }

    public List<Type> getCommonClasses(Type leftClass, Type rightClass) {
        List<Type> commonClasses = null;
        if (this.conformsTo(rightClass, leftClass, null)) {
            commonClasses = new ArrayList<Type>();
            commonClasses.add(leftClass);
        }
        for (Type superClass : leftClass.getSuperClass()) {
            List<Type> commonSuperClasses = this.getCommonClasses(superClass, rightClass);
            if (commonSuperClasses == null) continue;
            if (commonClasses == null) {
                commonClasses = commonSuperClasses;
                continue;
            }
            commonClasses.addAll(commonSuperClasses);
        }
        return commonClasses;
    }

    public Type getCommonType(Type leftType, Type rightType, Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions) {
        if (leftType instanceof UnspecifiedType) {
            ((UnspecifiedType)leftType).setUpperBound(rightType);
            return rightType;
        }
        if (rightType instanceof UnspecifiedType) {
            ((UnspecifiedType)rightType).setUpperBound(leftType);
            return leftType;
        }
        if (leftType instanceof TupleType && rightType instanceof TupleType) {
            TupleTypeManager tupleManager = this.getTupleManager();
            return tupleManager.getCommonType((TupleType)leftType, (TupleType)rightType, templateParameterSubstitutions);
        }
        if (this.conformsTo(leftType, rightType, templateParameterSubstitutions)) {
            return rightType;
        }
        if (this.conformsTo(rightType, leftType, templateParameterSubstitutions)) {
            return leftType;
        }
        List<Type> commonClasses = this.getCommonClasses(leftType, rightType);
        if (commonClasses == null) {
            return null;
        }
        Type mostConformant = null;
        for (Type commonClass : commonClasses) {
            if (mostConformant == null) {
                mostConformant = commonClass;
                continue;
            }
            if (!this.conformsTo(commonClass, mostConformant, templateParameterSubstitutions)) continue;
            mostConformant = commonClass;
        }
        return mostConformant;
    }

    public String getDefaultStandardLibraryURI() {
        return this.defaultStandardLibraryURI;
    }

    public ResourceSet getExternalResourceSet() {
        if (this.externalResourceSet == null) {
            this.externalResourceSet = new ResourceSetImpl();
            ProjectMap projectMap = ProjectMap.findAdapter((ResourceSet)this.pivotResourceSet);
            if (projectMap == null) {
                projectMap = ProjectMap.getAdapter((ResourceSet)this.externalResourceSet);
            } else {
                this.externalResourceSet.eAdapters().add((Object)projectMap);
            }
            projectMap.initializeResourceSet((ResourceSet)this.externalResourceSet);
            this.externalResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emof", new EMOFResourceFactoryImpl());
            MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)this.externalResourceSet, this);
            for (Factory factory : factoryMap) {
                factory.configure((ResourceSet)this.externalResourceSet);
            }
        }
        return this.externalResourceSet;
    }

    public Set<Map.Entry<String, Namespace>> getGlobalNamespaces() {
        return this.globalNamespaces.entrySet();
    }

    public Iterable<Type> getGlobalTypes() {
        return this.globalTypes;
    }

    public LibraryFeature getImplementation(Feature feature) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        LibraryFeature implementation = feature.getImplementation();
        if (implementation == null) {
            ImplementationManager implementationManager = this.getImplementationManager();
            implementation = implementationManager.loadImplementation(feature);
        }
        return implementation;
    }

    public LibraryFeature getImplementation(Operation operation) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (operation == null) {
            return null;
        }
        LibraryFeature implementation = operation.getImplementation();
        if (implementation == null) {
            ImplementationManager implementationManager = this.getImplementationManager();
            implementation = implementationManager.getOperationImplementation(operation);
            operation.setImplementation(implementation);
        }
        return implementation;
    }

    public LibraryFeature getImplementation(Property property) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (property == null) {
            return null;
        }
        LibraryFeature implementation = property.getImplementation();
        if (implementation == null) {
            ImplementationManager implementationManager = this.getImplementationManager();
            implementation = implementationManager.getPropertyImplementation(property);
            property.setImplementation(implementation);
        }
        return implementation;
    }

    public ImplementationManager getImplementationManager() {
        if (this.implementationManager == null) {
            this.implementationManager = this.createImplementationManager();
        }
        return this.implementationManager;
    }

    public Precedence getInfixPrecedence(String operatorName) {
        PrecedenceManager precedenceManager = this.getPrecedenceManager();
        return precedenceManager.getInfixPrecedence(operatorName);
    }

    public ReflectiveType getInheritance(DomainType type) {
        Type type1 = this.getType(type);
        if (type1 == null) {
            return null;
        }
        Type type2 = (Type)type1.getUnspecializedElement();
        TypeServer typeServer = this.getTypeServer(type2 != null ? type2 : type1);
        return typeServer.getExecutorType();
    }

    public LambdaTypeManager getLambdaManager() {
        if (this.lambdaManager == null) {
            this.lambdaManager = this.createLambdaManager();
        }
        return this.lambdaManager;
    }

    public LambdaType getLambdaType(String typeName, Type contextType, List<? extends Type> parameterTypes, Type resultType, Map<TemplateParameter, ParameterableElement> bindings) {
        LambdaTypeManager lambdaManager = this.getLambdaManager();
        return lambdaManager.getLambdaType(typeName, contextType, parameterTypes, resultType, bindings);
    }

    public List<Library> getLibraries() {
        return this.pivotLibraries;
    }

    public Resource getLibraryResource() {
        return this.pivotLibraryResource;
    }

    public Type getLibraryType(String string, List<? extends ParameterableElement> templateArguments) {
        Type libraryType = this.getRequiredLibraryType(string);
        if (libraryType == null) {
            return null;
        }
        return this.getLibraryType(libraryType, templateArguments);
    }

    public <T extends Type> T getLibraryType(T libraryType, List<? extends ParameterableElement> templateArguments) {
        List<TemplateParameter> templateParameters;
        assert (libraryType == PivotUtil.getUnspecializedTemplateableElement(libraryType));
        if (libraryType == this.getAnyClassifierType() && templateArguments != null && templateArguments.size() == 1 && templateArguments.get(0) == libraryType) {
            return libraryType;
        }
        TemplateSignature templateSignature = libraryType.getOwnedTemplateSignature();
        List<TemplateParameter> list = templateParameters = templateSignature != null ? templateSignature.getParameter() : Collections.emptyList();
        if (templateParameters.isEmpty()) {
            return libraryType;
        }
        if (templateArguments == null || templateArguments.size() != templateParameters.size()) {
            throw new IllegalArgumentException("Incorrect template bindings for template type");
        }
        boolean isUnspecialized = this.isUnspecialized(templateParameters, templateArguments);
        if (isUnspecialized) {
            return libraryType;
        }
        TypeServer typeServer = this.getTypeServer(libraryType);
        Type specializedType = typeServer.getSpecializedType(templateArguments);
        return (T)specializedType;
    }

    public Iterable<Type> getLocalClasses(Package pkg) {
        return new CompletePackageTypesIterable(this.getAllPackages(pkg, true));
    }

    public Iterable<Comment> getLocalComments(Operation operation) {
        if (operation.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        return new CompleteElementCommentsIterable(this.getAllOperations(operation));
    }

    public Iterable<Comment> getLocalComments(Property property) {
        if (property.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        return new CompleteElementCommentsIterable(this.getAllProperties(property));
    }

    public Iterable<Comment> getLocalComments(Type type) {
        if (type == null || type.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteElementCommentsIterable(this.getAllTypes(type));
    }

    public Iterable<Constraint> getLocalConstraints(Operation operation) {
        if (operation.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        return new CompleteElementConstraintsIterable(this.getAllOperations(operation));
    }

    public Iterable<Constraint> getLocalConstraints(Property property) {
        if (property.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        return new CompleteElementConstraintsIterable(this.getAllProperties(property));
    }

    public Iterable<Constraint> getLocalConstraints(Type type) {
        if (type == null || type.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteElementConstraintsIterable(this.getAllTypes(type));
    }

    public Iterable<Operation> getLocalOperations(Type type, Boolean selectStatic) {
        if (type == null || type.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteTypeOperationsIterable(this.getAllTypes(type), selectStatic);
    }

    public Iterable<Package> getLocalPackages(Package pkg) {
        return new CompletePackagePackagesIterable(this.getAllPackages(pkg, true));
    }

    public Iterable<Property> getLocalProperties(Type type, Boolean selectStatic) {
        if (type == null || type.getOwningTemplateParameter() != null) {
            return Collections.emptyList();
        }
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteClassPropertiesIterable(this.getAllTypes(type), selectStatic);
    }

    public EObject getLockingObject() {
        return this.lockingAnnotation;
    }

    @Override
    public MetaModelManager getMetaModelManager() {
        return this;
    }

    public DomainType getMetaType(DomainType instanceType) {
        if (instanceType instanceof PrimitiveType) {
            return this.getPivotType("PrimitiveType");
        }
        throw new UnsupportedOperationException();
    }

    public DomainType getOclType(String typeName) {
        return this.getInheritance(this.getPivotType(typeName));
    }

    public CollectionType getOrderedSetType(DomainType elementType) {
        return this.getOrderedSetType(this.getType(elementType));
    }

    public CollectionType getOrderedSetType(Type elementType) {
        return this.getLibraryType(this.getOrderedSetType(), Collections.singletonList(elementType));
    }

    private Resource getOrphanResource() {
        if (this.orphanage == null) {
            this.orphanage = this.createOrphanage();
        }
        return this.orphanage;
    }

    public PackageManager getPackageManager() {
        return this.packageManager;
    }

    public PackageTracker getPackageTracker(Package pivotPackage) {
        return this.packageManager.getPackageTracker(pivotPackage);
    }

    public Package getPivotMetaModel() {
        AnyType oclAnyType;
        if (this.pivotMetaModel == null && (oclAnyType = this.getOclAnyType()) != null) {
            Package stdlibPackage = oclAnyType.getPackage();
            for (Package aPackage : this.getAllPackages(stdlibPackage, false)) {
                Type anyType = PivotUtil.getNamedElement(aPackage.getOwnedType(), PivotPackage.Literals.ELEMENT.getName());
                if (anyType == null) continue;
                this.pivotMetaModel = aPackage;
                break;
            }
            if (this.pivotMetaModel == null) {
                OCLMetaModel metaModelResource = new OCLMetaModel(this, stdlibPackage.getName(), stdlibPackage.getNsPrefix(), stdlibPackage.getNsURI());
                this.pivotResourceSet.getResources().add((Object)metaModelResource);
                this.pivotMetaModel = (Package)metaModelResource.getContents().get(0);
                this.addPackage(this.pivotMetaModel);
            }
        }
        return this.pivotMetaModel;
    }

    public <T extends NamedElement> T getPivotOfEcore(Class<T> pivotClass, EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource metaModel = eObject.eResource();
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter(metaModel, this);
        if (ecore2Pivot == null) {
            return null;
        }
        return (T)((NamedElement)ecore2Pivot.getCreated(pivotClass, eObject));
    }

    public ResourceSet getPivotResourceSet() {
        return this.pivotResourceSet;
    }

    public Type getPivotType(String className) {
        Package pivotMetaModel = this.getPivotMetaModel();
        if (pivotMetaModel == null) {
            return null;
        }
        return PivotUtil.getNamedElement(pivotMetaModel.getOwnedType(), className);
    }

    protected PrecedenceManager getPrecedenceManager() {
        if (this.precedenceManager == null) {
            this.precedenceManager = this.createPrecedenceManager();
        }
        return this.precedenceManager;
    }

    public Iterable<? extends Nameable> getPrecedences(Package pivotPackage) {
        return pivotPackage.getOwnedPrecedence();
    }

    public Precedence getPrefixPrecedence(String operatorName) {
        PrecedenceManager precedenceManager = this.getPrecedenceManager();
        return precedenceManager.getPrefixPrecedence(operatorName);
    }

    public <T extends EObject> T getPrimaryElement(T element) {
        if (element instanceof Operation) {
            return (T)this.getPrimaryOperation((Operation)element);
        }
        if (element instanceof Package) {
            return (T)this.getPrimaryPackage((Package)element);
        }
        if (element instanceof Property) {
            return (T)this.getPrimaryProperty((Property)element);
        }
        if (element instanceof Type) {
            return (T)this.getPrimaryType((Type)element);
        }
        return element;
    }

    public Operation getPrimaryOperation(Operation pivotOperation) {
        Operation operation;
        Type pivotClass = pivotOperation.getOwningType();
        TypeTracker typeTracker = this.packageManager.findTypeTracker(pivotClass);
        if (typeTracker != null && (operation = typeTracker.getTypeServer().getOperation(pivotOperation)) != null) {
            return operation;
        }
        return pivotOperation;
    }

    public Package getPrimaryPackage(String nsURI, String ... subPackagePath) {
        Package pivotPackage = this.packageManager.getPackageByURI(nsURI);
        if (pivotPackage == null) {
            return null;
        }
        if (subPackagePath != null) {
            String[] stringArray = subPackagePath;
            int n = subPackagePath.length;
            int n2 = 0;
            while (n2 < n) {
                String subPackageName = stringArray[n2];
                if ((pivotPackage = this.getPrimaryPackage(pivotPackage, subPackageName)) == null) {
                    return null;
                }
                ++n2;
            }
        }
        return pivotPackage;
    }

    public Package getPrimaryPackage(Package parentPackage, String subPackageName) {
        PackageTracker packageTracker = this.packageManager.findPackageTracker(parentPackage);
        if (packageTracker != null) {
            return packageTracker.getPackageServer().getNestedPackage(subPackageName);
        }
        return PivotUtil.getNamedElement(parentPackage.getNestedPackage(), subPackageName);
    }

    public Package getPrimaryPackage(Package pivotPackage) {
        PackageTracker packageTracker = this.packageManager.findPackageTracker(pivotPackage);
        if (packageTracker != null) {
            return packageTracker.getPrimaryPackage();
        }
        return pivotPackage;
    }

    public Property getPrimaryProperty(Property pivotProperty) {
        Type pivotClass = pivotProperty.getOwningType();
        TypeTracker typeTracker = this.packageManager.findTypeTracker(pivotClass);
        if (typeTracker != null) {
            return typeTracker.getTypeServer().getProperty(pivotProperty.getName());
        }
        return pivotProperty;
    }

    public Type getPrimaryType(Type pivotType) {
        TypeTracker typeTracker = this.packageManager.findTypeTracker(pivotType);
        if (typeTracker != null) {
            return typeTracker.getPrimaryType();
        }
        return pivotType;
    }

    public Type getPrimaryType(String nsURI, String path, String ... extraPath) {
        Package pivotPackage = this.packageManager.getPackageByURI(nsURI);
        if (pivotPackage == null) {
            return null;
        }
        if (extraPath == null || extraPath.length == 0) {
            return this.getPrimaryType(pivotPackage, path);
        }
        if ((pivotPackage = this.getPrimaryPackage(pivotPackage, path)) == null) {
            return null;
        }
        int iMax = extraPath.length - 1;
        int i = 0;
        while (i < iMax) {
            if ((pivotPackage = this.getPrimaryPackage(pivotPackage, extraPath[i])) == null) {
                return null;
            }
            ++i;
        }
        return this.getPrimaryType(pivotPackage, extraPath[iMax]);
    }

    public Type getPrimaryType(Package parentPackage, String typeName) {
        PackageTracker packageTracker = this.packageManager.findPackageTracker(parentPackage);
        if (packageTracker != null) {
            return packageTracker.getPackageServer().getType(typeName);
        }
        return PivotUtil.getNamedElement(this.getLocalClasses(parentPackage), typeName);
    }

    public URI getResourceIdentifier(Object uniqueContext, String subContext) {
        URI uri;
        if (subContext == null) {
            subContext = "";
        }
        if (uniqueContext instanceof Element) {
            uri = URI.createURI((String)(String.valueOf(Pivot2Moniker.toString((Element)uniqueContext)) + "///" + subContext + ".essentialocl"));
        } else {
            if (this.uriMap == null) {
                this.uriMap = new HashMap<Object, URI>();
            }
            if ((uri = this.uriMap.get(uniqueContext)) == null) {
                uri = URI.createURI((String)(String.valueOf(EcoreUtil.generateUUID()) + subContext + ".essentialocl"));
                this.uriMap.put(uniqueContext, uri);
            }
        }
        return uri;
    }

    public CollectionType getSequenceType(DomainType elementType) {
        return this.getSequenceType(this.getType(elementType));
    }

    public CollectionType getSequenceType(Type elementType) {
        return this.getLibraryType(this.getSequenceType(), Collections.singletonList(elementType));
    }

    public CollectionType getSetType(DomainType elementType) {
        return this.getSetType(this.getType(elementType));
    }

    public CollectionType getSetType(Type elementType) {
        return this.getLibraryType(this.getSetType(), Collections.singletonList(elementType));
    }

    protected Type getSpecializedLambdaType(LambdaType type, Map<TemplateParameter, ParameterableElement> usageBindings) {
        LambdaType specializedLambdaType = this.getLambdaType(type.getName(), type.getContextType(), (List<? extends Type>)type.getParameterType(), type.getResultType(), usageBindings);
        return specializedLambdaType;
    }

    public Type getSpecializedType(Type type, Map<TemplateParameter, ParameterableElement> usageBindings) {
        if (type == null) {
            return null;
        }
        TemplateParameter owningTemplateParameter = type.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            if (usageBindings == null) {
                return type;
            }
            ParameterableElement parameterableElement = usageBindings.get(owningTemplateParameter);
            return parameterableElement instanceof Type ? (Type)parameterableElement : type;
        }
        if (usageBindings == null) {
            return type;
        }
        if (type instanceof TupleType) {
            return this.getTupleType((TupleType)type, usageBindings);
        }
        if (type instanceof LambdaType) {
            return this.getSpecializedLambdaType((LambdaType)type, usageBindings);
        }
        Type unspecializedType = PivotUtil.getUnspecializedTemplateableElement(type);
        Map<TemplateParameter, ParameterableElement> typeBindings = PivotUtil.getAllTemplateParametersAsBindings(type);
        PivotUtil.getAllTemplateParameterSubstitutions(typeBindings, type);
        if (typeBindings != null && !typeBindings.isEmpty()) {
            for (TemplateParameter templateParameter : typeBindings.keySet()) {
                ParameterableElement aParameterableElement;
                ParameterableElement parameterableElement = typeBindings.get(templateParameter);
                if (parameterableElement == null) continue;
                TemplateParameter aTemplateParameter = parameterableElement.getOwningTemplateParameter();
                if (aTemplateParameter != null) {
                    aParameterableElement = usageBindings.get(aTemplateParameter);
                    if (aParameterableElement == null) continue;
                    typeBindings.put(templateParameter, aParameterableElement);
                    continue;
                }
                if (!(parameterableElement instanceof SelfType) || (aParameterableElement = usageBindings.get(null)) == null) continue;
                typeBindings.put(templateParameter, aParameterableElement);
            }
            List<TemplateParameter> templateParameters = PivotUtil.getAllTemplateParameters(unspecializedType);
            ArrayList<ParameterableElement> templateArguments = new ArrayList<ParameterableElement>(templateParameters.size());
            for (TemplateParameter templateParameter : templateParameters) {
                ParameterableElement templateArgument = typeBindings.get(templateParameter);
                if (templateArgument == null) {
                    templateArgument = templateParameter.getParameteredElement();
                }
                if (templateArgument instanceof Type) {
                    templateArgument = this.getSpecializedType((Type)templateArgument, usageBindings);
                }
                templateArguments.add(templateArgument);
            }
            return this.getLibraryType(unspecializedType, templateArguments);
        }
        return type;
    }

    protected <T extends Type> T getSpecializedTypeServer(T unspecializedType, List<? extends ParameterableElement> templateArguments) {
        TypeServer typeServer = this.getTypeServer(unspecializedType);
        Type specializedType = typeServer.getSpecializedType(templateArguments);
        return (T)specializedType;
    }

    public Iterable<Type> getSuperClasses(Type pivotType) {
        if (pivotType == null || pivotType.getOwningTemplateParameter() != null) {
            return Collections.singletonList(this.getOclAnyType());
        }
        if (this.pivotMetaModel == null && pivotType == this.getClassType()) {
            this.lazyLoadPivotMetaModel();
        }
        return new CompleteClassSuperClassesIterable(this.getAllTypes(pivotType));
    }

    public ResourceSet getTarget() {
        return this.pivotResourceSet;
    }

    public TupleTypeManager getTupleManager() {
        if (this.tupleManager == null) {
            this.tupleManager = this.createTupleManager();
        }
        return this.tupleManager;
    }

    public DomainTupleType getTupleType(List<? extends DomainTypedElement> parts) {
        return this.getTupleType("Tuple", parts, null);
    }

    public TupleType getTupleType(String typeName, Collection<? extends DomainTypedElement> parts, Map<TemplateParameter, ParameterableElement> bindings) {
        TupleTypeManager tupleManager = this.getTupleManager();
        return tupleManager.getTupleType(typeName, parts, bindings);
    }

    public TupleType getTupleType(TupleType tupleType, Map<TemplateParameter, ParameterableElement> bindings) {
        TupleTypeManager tupleManager = this.getTupleManager();
        return tupleManager.getTupleType(tupleType, bindings);
    }

    public DomainType getType(DomainElement element) {
        if (element instanceof EObject) {
            return this.getPivotType(((EObject)element).eClass().getName());
        }
        return super.getType(element);
    }

    public Type getType(DomainType dType) {
        if (dType instanceof Type) {
            return this.getPrimaryType((Type)dType);
        }
        DomainPackage dPackage = dType.getPackage();
        String nsURI = dPackage.getNsURI();
        Package pPackage = this.packageManager.getPackageByURI(nsURI);
        if (pPackage == null) {
            throw new UnsupportedOperationException();
        }
        return this.getPrimaryType(pPackage, dType.getName());
    }

    public DomainType getType(EClassifier eClassifier) {
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter(eClassifier.eResource(), this);
        Type pivotType = ecore2Pivot.getCreated(Type.class, (EObject)eClassifier);
        return pivotType;
    }

    public TypeServer getTypeServer(Type pivotType) {
        return this.getTypeTracker(pivotType).getTypeServer();
    }

    public TypeTracker getTypeTracker(Type pivotType) {
        TypeTracker typeTracker = this.packageManager.findTypeTracker(pivotType);
        if (typeTracker == null) {
            PackageTracker packageTracker = this.getPackageTracker(pivotType.getPackage());
            typeTracker = packageTracker.getTypeTracker(pivotType);
        }
        return typeTracker;
    }

    public Type getTypeWithMultiplicity(TypedMultiplicityElement element) {
        boolean isMany;
        Type elementType = PivotUtil.getBehavioralType(element.getType());
        int upperBound = element.getUpper().intValue();
        boolean bl = isMany = upperBound < 0 || 1 < upperBound;
        if (!isMany) {
            return elementType;
        }
        boolean isOrdered = element.isOrdered();
        boolean isUnique = element.isUnique();
        CollectionType collectionType = isOrdered ? (isUnique ? this.getOrderedSetType() : this.getSequenceType()) : (isUnique ? this.getSetType() : this.getBagType());
        assert (elementType != null);
        return this.getLibraryType(collectionType, Collections.singletonList(elementType));
    }

    public ValueFactory getValueFactory() {
        if (this.valueFactory == null) {
            this.valueFactory = this.createValueFactory();
        }
        return this.valueFactory;
    }

    protected void installLibrary(Library pivotLibrary) {
        String uri = pivotLibrary.getNsURI();
        if (this.pivotLibraries.isEmpty()) {
            if (uri == null) {
                throw new IllegalLibraryException(OCLMessages.MissingLibraryURI_ERROR_);
            }
            this.setDefaultStandardLibraryURI(uri);
            this.pivotLibraries.add(pivotLibrary);
        } else if (!this.pivotLibraries.contains(pivotLibrary)) {
            String libraryURI = this.getDefaultStandardLibraryURI();
            if (uri != null && !uri.equals(libraryURI)) {
                throw new IllegalLibraryException(NLS.bind((String)OCLMessages.ImportedLibraryURI_ERROR_, (Object)uri, (Object)libraryURI));
            }
            this.pivotLibraries.add(pivotLibrary);
        }
    }

    public void installPackage(Package pivotPackage) {
        if (pivotPackage instanceof Library) {
            this.installLibrary((Library)pivotPackage);
        }
        this.addPackage(pivotPackage);
    }

    public void installPropertyDeclaration(Property thisProperty) {
        if ((thisProperty.isTransient() || thisProperty.isVolatile()) && !thisProperty.isDerived()) {
            return;
        }
        Property opposite = thisProperty.getOpposite();
        if (opposite != null) {
            return;
        }
        Type thatType = thisProperty.getType();
        if (thatType == null || thatType instanceof DataType) {
            return;
        }
        Type thisType = thisProperty.getOwningType();
        if (thisType == null) {
            return;
        }
        String name = thisType.getName();
        for (Property thatProperty : thatType.getOwnedAttribute()) {
            if (!name.equals(thatProperty.getName())) continue;
            if (!thatProperty.isImplicit()) {
                return;
            }
            opposite = thatProperty;
        }
        if (opposite != null) {
            opposite.setOpposite(null);
            thisProperty.setOpposite(null);
            opposite.setUpper(BigInteger.valueOf(-1L));
            return;
        }
        for (Property aThisProperty : thisType.getOwnedAttribute()) {
            if (aThisProperty == thisProperty || aThisProperty.getType() != thatType) continue;
            return;
        }
        opposite = PivotFactory.eINSTANCE.createProperty();
        opposite.setImplicit(true);
        opposite.setName(name);
        opposite.setType(thisType);
        opposite.setLower(BigInteger.valueOf(0L));
        if (thisProperty.isComposite()) {
            opposite.setUpper(BigInteger.valueOf(1L));
        } else {
            opposite.setUpper(BigInteger.valueOf(-1L));
        }
        thatType.getOwnedAttribute().add((Object)opposite);
        opposite.setOpposite(thisProperty);
        thisProperty.setOpposite(opposite);
    }

    public void installResource(Resource pivotResource) {
        for (EObject eObject : pivotResource.getContents()) {
            if (!(eObject instanceof Package)) continue;
            Package pivotPackage = (Package)eObject;
            this.installPackage(pivotPackage);
        }
    }

    public boolean isAdapterFor(MetaModelManager metaModelManager) {
        return this == metaModelManager;
    }

    protected boolean isUnspecialized(List<TemplateParameter> templateParameters, List<? extends ParameterableElement> templateArguments) {
        int iMax = templateParameters.size();
        assert (templateArguments.size() == iMax);
        boolean isUnspecialized = true;
        int i = 0;
        while (i < iMax) {
            if (templateArguments.get(i) != templateParameters.get(i).getParameteredElement()) {
                isUnspecialized = false;
            }
            ++i;
        }
        return isUnspecialized;
    }

    protected void lazyLoadPivotMetaModel() {
        if (!this.pivotLibraries.isEmpty()) {
            this.loadPivotMetaModel(this.pivotLibraries.get(0));
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == MetaModelManager.class;
    }

    public boolean isSuperClassOf(Type unspecializedFirstType, Type secondType) {
        Type unspecializedSecondType = PivotUtil.getUnspecializedTemplateableElement(secondType);
        if (unspecializedFirstType == unspecializedSecondType) {
            return true;
        }
        for (Type superClass : this.getSuperClasses(unspecializedSecondType)) {
            if (!this.isSuperClassOf(unspecializedFirstType, superClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnderspecified(ParameterableElement type) {
        if (type == null) {
            return false;
        }
        if (type instanceof TemplateableElement) {
            for (TemplateBinding templateBinding : ((TemplateableElement)((Object)type)).getTemplateBinding()) {
                for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitution()) {
                    if (!this.isUnderspecified((Type)templateParameterSubstitution.getActual())) continue;
                    return true;
                }
            }
        }
        if (type instanceof UnspecifiedType) {
            return true;
        }
        if (type instanceof CollectionType) {
            return this.isUnderspecified(((CollectionType)type).getElementType());
        }
        if (type instanceof TupleType) {
            for (Property part : ((TupleType)type).getOwnedAttribute()) {
                if (!this.isUnderspecified(part.getType())) continue;
                return true;
            }
        }
        if (type instanceof LambdaType) {
            LambdaType lambdaType = (LambdaType)type;
            if (this.isUnderspecified(lambdaType.getContextType())) {
                return true;
            }
            for (Type parameterType : lambdaType.getParameterType()) {
                if (!this.isUnderspecified(parameterType)) continue;
                return true;
            }
            if (this.isUnderspecified(lambdaType.getResultType())) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Resource loadDefaultLibrary(String uri) {
        if (!this.pivotLibraries.isEmpty() && this.pivotLibraryResource == null) {
            this.loadLibrary(this.pivotLibraries.get(0).eResource());
            return this.pivotLibraryResource;
        }
        if (uri == null) {
            return null;
        }
        StandardLibraryContribution contribution = (StandardLibraryContribution)StandardLibraryContribution.REGISTRY.get(uri);
        if (contribution == null) {
            return null;
        }
        Resource resource = contribution.getResource();
        this.loadLibrary(resource);
        return resource;
    }

    public void loadLibrary(Resource pivotResource) {
        assert (this.pivotLibraryResource == null || this.pivotLibraryResource == pivotResource);
        if (pivotResource != null) {
            this.pivotLibraryResource = pivotResource;
            this.installResource(pivotResource);
        }
        for (Package rootPackage : this.computePivotRootPackages()) {
            if (!(rootPackage instanceof Library)) continue;
            if (!this.pivotLibraries.contains(rootPackage)) {
                this.pivotLibraries.add((Library)rootPackage);
            }
            this.loadLibraryPackage(rootPackage);
        }
    }

    protected void loadLibraryPackage(Package pivotPackage) {
        for (Package nestedPackage : pivotPackage.getNestedPackage()) {
            this.loadLibraryPackage(nestedPackage);
        }
        for (Type type : pivotPackage.getOwnedType()) {
            if (!PivotUtil.isLibraryType(type)) continue;
            this.defineLibraryType(type);
        }
    }

    protected void loadPivotMetaModel(Library pivotLibrary) {
        for (Package libPackage : this.getAllPackages(pivotLibrary, false)) {
            if (PivotUtil.getNamedElement(libPackage.getOwnedType(), PivotPackage.Literals.ELEMENT.getName()) == null) continue;
            this.pivotMetaModel = libPackage;
            return;
        }
        OCLMetaModel metaModelResource = new OCLMetaModel(this, pivotLibrary.getName(), pivotLibrary.getNsPrefix(), pivotLibrary.getNsURI());
        this.pivotMetaModel = (Package)metaModelResource.getContents().get(0);
        this.addPackage(this.pivotMetaModel);
    }

    public Element loadResource(URI uri, String alias, ResourceSet resourceSet) {
        Resource resource;
        URI resourceURI = uri.trimFragment();
        String resourceURIstring = resourceURI.toString();
        if (resourceURIstring.equals(this.defaultStandardLibraryURI)) {
            resource = this.loadDefaultLibrary(resourceURIstring);
        } else {
            StandardLibraryContribution contribution = (StandardLibraryContribution)StandardLibraryContribution.REGISTRY.get(resourceURIstring);
            if (contribution != null) {
                resource = contribution.getResource();
            } else {
                External2Pivot external2Pivot = this.external2PivotMap.get(uri);
                if (external2Pivot != null) {
                    resource = external2Pivot.getResource();
                } else {
                    EList contents;
                    if (resourceSet == null) {
                        resourceSet = this.getExternalResourceSet();
                    }
                    try {
                        resource = resourceSet.getResource(resourceURI, true);
                    }
                    catch (RuntimeException e) {
                        Resource resource2 = resourceSet.getResource(resourceURI, false);
                        if (resource2 != null) {
                            resourceSet.getResources().remove((Object)resource2);
                            resource2 = null;
                        }
                        throw e;
                    }
                    if (resource != null && (contents = resource.getContents()).size() > 0) {
                        EObject firstContent = (EObject)contents.get(0);
                        for (Factory factory : factoryMap) {
                            URI packageURI = factory.getPackageURI(firstContent);
                            if (packageURI == null) continue;
                            External2Pivot external2Pivot2 = this.external2PivotMap.get(packageURI);
                            if (external2Pivot2 == null) break;
                            resource = external2Pivot2.getResource();
                            break;
                        }
                    }
                }
            }
        }
        if (resource != null) {
            return this.loadResource(resource, uri.fragment());
        }
        logger.warn((Object)("Cannot load package with URI '" + uri + "'"));
        return null;
    }

    public Element loadResource(Resource resource, String fragmentURI) {
        for (Factory factory : factoryMap) {
            if (!factory.canHandle(resource)) continue;
            return factory.importFromResource(this, resource, fragmentURI);
        }
        throw new IllegalArgumentException("Cannot create pivot from '" + fragmentURI + "'");
    }

    public LibraryFeature lookupImplementation(DomainOperation dynamicOperation) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return this.getImplementation((Operation)dynamicOperation);
    }

    public void notifyChanged(Notification notification) {
    }

    public void removeExternalResource(External2Pivot external2Pivot) {
        this.external2PivotMap.remove(external2Pivot.getURI());
    }

    public void removeListener(MetaModelManagerListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void resolveAllOperations(Set<Operation> allOperations, Type forType, Boolean selectStatic, String operationName, List<Parameter> parameters, Set<Type> alreadyVisited) {
        if (alreadyVisited.add(forType)) {
            int iMax = parameters.size();
            for (Operation candidateOperation : this.getLocalOperations(forType, selectStatic)) {
                EList<Parameter> candidateParameters;
                if (!operationName.equals(candidateOperation.getName()) || (candidateParameters = candidateOperation.getOwnedParameter()).size() != iMax) continue;
                int i = 0;
                while (i < iMax) {
                    Type candidateType;
                    Type type = parameters.get(i).getType();
                    if (type != (candidateType = ((Parameter)candidateParameters.get(i)).getType())) break;
                    ++i;
                }
                if (i < iMax) continue;
                allOperations.add(candidateOperation);
            }
            for (Type superType : this.getSuperClasses(forType)) {
                this.resolveAllOperations(allOperations, superType, selectStatic, operationName, parameters, alreadyVisited);
            }
        }
    }

    public Operation resolveBaseOperation(Operation operation) {
        HashSet<Operation> allOperations = new HashSet<Operation>();
        this.resolveAllOperations((Set<Operation>)allOperations, operation.getOwningType(), operation.isStatic(), operation.getName(), (List<Parameter>)operation.getOwnedParameter(), (Set<Type>)new HashSet<Type>());
        Operation baseOperation = operation;
        for (Operation candidateOperation : allOperations) {
            Type candidateType;
            Type baseType;
            if (candidateOperation == operation || !this.conformsTo(baseType = baseOperation.getOwningType(), candidateType = candidateOperation.getOwningType(), null)) continue;
            baseOperation = candidateOperation;
        }
        return baseOperation;
    }

    public Set<Operation> resolveLocalOperation(Type pivotClass, String operationName, Type ... pivotArguments) {
        Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions = null;
        HashSet<Operation> pivotOperations = null;
        for (Operation pivotOperation : pivotClass.getOwnedOperation()) {
            EList<Parameter> pivotParameters;
            if (!operationName.equals(pivotOperation.getName()) || pivotArguments.length != (pivotParameters = pivotOperation.getOwnedParameter()).size()) continue;
            boolean typesConform = true;
            int i = 0;
            while (i < pivotArguments.length) {
                Type argumentType = pivotArguments[i];
                Parameter pivotParameter = (Parameter)pivotParameters.get(i);
                Type parameterType = this.getTypeWithMultiplicity(pivotParameter);
                if (parameterType instanceof SelfType) {
                    parameterType = pivotOperation.getOwningType();
                }
                if (!this.conformsTo(argumentType, parameterType, templateParameterSubstitutions)) {
                    typesConform = false;
                    break;
                }
                ++i;
            }
            if (!typesConform) continue;
            if (pivotOperations == null) {
                pivotOperations = new HashSet<Operation>();
            }
            pivotOperations.add(pivotOperation);
        }
        return pivotOperations;
    }

    public Operation resolveOperation(Type leftType, String operationName, Type ... rightTypes) {
        Set<Operation> candidateOperations = this.resolveOperations(leftType, operationName, rightTypes);
        if (candidateOperations == null) {
            return null;
        }
        if (candidateOperations.size() > 1) {
            logger.warn((Object)("Ambiguous operation '" + operationName + "'"));
        }
        return candidateOperations.iterator().next();
    }

    public Set<Operation> resolveOperations(Type pivotClass, String operationName, Type ... pivotArguments) {
        Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions = PivotUtil.getAllTemplateParameterSubstitutions(null, pivotClass);
        Set<Operation> pivotOperations = this.resolveLocalOperation(pivotClass, operationName, pivotArguments);
        for (TemplateBinding templateBinding : pivotClass.getTemplateBinding()) {
            Set<Operation> morePivotOperations;
            TemplateSignature signature = templateBinding.getSignature();
            TemplateableElement template = signature.getTemplate();
            if (!(template instanceof Type) || (morePivotOperations = this.resolveLocalOperation((Type)template, operationName, pivotArguments)) == null) continue;
            if (pivotOperations == null) {
                pivotOperations = morePivotOperations;
                continue;
            }
            pivotOperations.addAll(morePivotOperations);
        }
        if (pivotOperations == null) {
            EList<Type> superClasses = pivotClass.getSuperClass();
            if (!superClasses.isEmpty()) {
                for (Type superClass : superClasses) {
                    Set<Operation> superOperations = this.resolveOperations(superClass, operationName, pivotArguments);
                    if (superOperations == null) continue;
                    if (pivotOperations == null) {
                        pivotOperations = superOperations;
                        continue;
                    }
                    pivotOperations.addAll(superOperations);
                }
            } else {
                AnyType oclAnyType = this.getOclAnyType();
                if (pivotClass != oclAnyType) {
                    pivotOperations = this.resolveOperations(oclAnyType, operationName, pivotArguments);
                }
            }
        }
        return pivotOperations;
    }

    public void setDefaultStandardLibraryURI(String defaultStandardLibraryURI) {
        this.defaultStandardLibraryURI = defaultStandardLibraryURI;
    }

    public void setLibraryLoadInProgress(boolean libraryLoadInProgress) {
        this.libraryLoadInProgress = libraryLoadInProgress;
    }

    public void setTarget(Notifier newTarget) {
    }

    public void unsetTarget(Notifier oldTarget) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteClassPropertiesIterable
    extends CompleteElementIterable<Type, Property> {
        protected final Boolean selectStatic;

        public CompleteClassPropertiesIterable(Iterable<Type> types, Boolean selectStatic) {
            super(types);
            this.selectStatic = selectStatic;
        }

        @Override
        protected Iterable<Property> getInnerIterable(Type model) {
            return model.getOwnedAttribute();
        }

        @Override
        protected Property getInnerValue(Property element) {
            if (this.selectStatic != null && element.isStatic() != this.selectStatic.booleanValue()) {
                return null;
            }
            return element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteClassSuperClassesIterable
    extends CompleteElementIterable<Type, Type> {
        public CompleteClassSuperClassesIterable(Iterable<Type> types) {
            super(types);
        }

        @Override
        protected Iterable<Type> getInnerIterable(Type model) {
            return model.getSuperClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteElementCommentsIterable
    extends CompleteElementIterable<Element, Comment> {
        public CompleteElementCommentsIterable(Iterable<? extends Element> models) {
            super(models);
        }

        @Override
        protected Iterable<Comment> getInnerIterable(Element model) {
            return model.getOwnedComment();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteElementConstraintsIterable
    extends CompleteElementIterable<NamedElement, Constraint> {
        public CompleteElementConstraintsIterable(Iterable<? extends NamedElement> models) {
            super(models);
        }

        @Override
        protected Iterable<Constraint> getInnerIterable(NamedElement model) {
            return model.getOwnedRule();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompletePackagePackagesIterable
    extends CompleteElementIterable<Package, Package> {
        public CompletePackagePackagesIterable(Iterable<Package> packages) {
            super(packages);
        }

        @Override
        protected Iterable<Package> getInnerIterable(Package model) {
            return model.getNestedPackage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompletePackageTypesIterable
    extends CompleteElementIterable<Package, Type> {
        public CompletePackageTypesIterable(Iterable<Package> packages) {
            super(packages);
        }

        @Override
        protected Iterable<Type> getInnerIterable(Package model) {
            return model.getOwnedType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteTypeOperationsIterable
    extends CompleteElementIterable<Type, Operation> {
        protected final Boolean selectStatic;

        public CompleteTypeOperationsIterable(Iterable<Type> types, Boolean selectStatic) {
            super(types);
            this.selectStatic = selectStatic;
        }

        @Override
        protected Iterable<Operation> getInnerIterable(Type model) {
            return model.getOwnedOperation();
        }

        @Override
        protected Operation getInnerValue(Operation element) {
            if (this.selectStatic != null && element.isStatic() != this.selectStatic.booleanValue()) {
                return null;
            }
            return element;
        }
    }

    public static interface Factory {
        public boolean canHandle(Resource var1);

        public void configure(ResourceSet var1);

        public URI getPackageURI(EObject var1);

        public Element importFromResource(MetaModelManager var1, Resource var2, String var3);
    }
}

