/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.executor.PivotReflectivePackage;
import org.eclipse.ocl.examples.pivot.manager.PackageClient;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.PackageTracker;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.manager.TypeTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageServer
extends PackageTracker {
    public static Function<PackageTracker, Package> tracker2package = new Function<PackageTracker, Package>(){

        public Package apply(PackageTracker packageTracker) {
            return packageTracker.getTarget();
        }
    };
    private final List<PackageTracker> trackers = new ArrayList<PackageTracker>();
    private Map<String, TypeServer> typeServers = null;
    private Map<String, PackageServer> nestedPackageServers = null;
    private PivotReflectivePackage executorPackage = null;

    protected PackageServer(PackageManager packageManager, Package primaryPackage) {
        super(packageManager, primaryPackage);
        this.trackers.add(this);
        this.initContents(this);
    }

    public void addNestedPackage(Package pivotPackage) {
        if (this.nestedPackageServers == null) {
            this.nestedPackageServers = new HashMap<String, PackageServer>();
        }
        String packageName = pivotPackage.getName();
        String nsURI = pivotPackage.getNsURI();
        Package primaryPackage = null;
        if (nsURI != null && (primaryPackage = this.packageManager.getPackageByURI(nsURI)) != null) {
            PackageServer packageServer = this.packageManager.getPackageTracker(primaryPackage).getPackageServer();
            if (primaryPackage != pivotPackage) {
                packageServer.addSecondaryPackage(pivotPackage);
            }
            this.nestedPackageServers.put(packageName, packageServer);
            return;
        }
        PackageServer nestedPackageServer = this.nestedPackageServers.get(packageName);
        if (nestedPackageServer == null) {
            PackageTracker nestedPackageTracker = (PackageTracker)EcoreUtil.getAdapter((List)pivotPackage.eAdapters(), (Object)this.packageManager);
            if (nestedPackageTracker instanceof PackageClient) {
                nestedPackageServer = nestedPackageTracker.getPackageServer();
                this.nestedPackageServers.put(packageName, nestedPackageServer);
            } else if (nestedPackageTracker instanceof PackageServer) {
                this.nestedPackageServers.put(packageName, nestedPackageServer);
                this.packageManager.addedNestedPrimaryPackage(pivotPackage);
            } else {
                nestedPackageServer = new PackageServer(this.packageManager, pivotPackage);
                this.nestedPackageServers.put(packageName, nestedPackageServer);
                this.packageManager.addedNestedPrimaryPackage(pivotPackage);
            }
        } else {
            nestedPackageServer.addSecondaryPackage(pivotPackage);
        }
    }

    public void addSecondaryPackage(Package secondaryPackage) {
        PackageClient packageClient = (PackageClient)EcoreUtil.getAdapter((List)secondaryPackage.eAdapters(), (Object)this.packageManager);
        if (packageClient == null) {
            packageClient = new PackageClient(this, secondaryPackage);
        }
        if (!this.trackers.contains(packageClient)) {
            this.trackers.add(packageClient);
        }
    }

    void addType(Type pivotType) {
        String className;
        TypeServer typeServer;
        if (pivotType instanceof LambdaType || pivotType instanceof TupleType) {
            return;
        }
        if (this.typeServers == null) {
            this.typeServers = new HashMap<String, TypeServer>();
        }
        if ((typeServer = this.typeServers.get(className = pivotType.getName())) == null) {
            typeServer = (TypeServer)EcoreUtil.getAdapter((List)pivotType.eAdapters(), (Object)this.packageManager);
            if (typeServer == null) {
                typeServer = new TypeServer(this.packageManager, pivotType);
            }
            if (pivotType.getUnspecializedElement() == null) {
                this.typeServers.put(className, typeServer);
            }
        } else {
            typeServer.addSecondaryType(pivotType);
        }
    }

    void addedNestedPackage(Object nestedObject) {
        if (nestedObject instanceof Package) {
            Package nestedPackage = (Package)nestedObject;
            this.addNestedPackage(nestedPackage);
        }
    }

    @Override
    public void dispose() {
        if (!this.trackers.isEmpty()) {
            ArrayList<PackageTracker> savedPackageTrackers = new ArrayList<PackageTracker>(this.trackers);
            this.trackers.clear();
            for (PackageTracker tracker : savedPackageTrackers) {
                if (!(tracker instanceof PackageClient)) continue;
                tracker.dispose();
            }
        }
        if (this.typeServers != null) {
            ArrayList<TypeServer> savedTypeServers = new ArrayList<TypeServer>(this.typeServers.values());
            this.typeServers.clear();
            for (TypeServer typeServer : savedTypeServers) {
                typeServer.dispose();
            }
            this.typeServers = null;
        }
        if (this.nestedPackageServers != null) {
            ArrayList<PackageServer> savedPackageServers = new ArrayList<PackageServer>(this.nestedPackageServers.values());
            this.nestedPackageServers.clear();
            for (PackageServer packageServer : savedPackageServers) {
                packageServer.dispose();
            }
            this.nestedPackageServers = null;
        }
        super.dispose();
    }

    public PivotReflectivePackage getExecutorPackage() {
        if (this.executorPackage == null) {
            this.executorPackage = new PivotReflectivePackage(this.getMetaModelManager(), this.target);
        }
        return this.executorPackage;
    }

    public Package getNestedPackage(String nestedPackageName) {
        PackageServer nestedPackageServer = this.nestedPackageServers.get(nestedPackageName);
        return nestedPackageServer != null ? nestedPackageServer.getTarget() : null;
    }

    @Override
    public PackageServer getPackageServer() {
        return this;
    }

    public Iterable<Package> getPackages() {
        return Iterables.transform(this.trackers, tracker2package);
    }

    public Type getType(String typeName) {
        TypeServer typeServer = this.typeServers.get(typeName);
        return typeServer != null ? typeServer.getTarget() : null;
    }

    @Override
    TypeTracker getTypeTracker(Type pivotType) {
        String className;
        TypeServer typeServer;
        if (this.typeServers == null) {
            this.typeServers = new HashMap<String, TypeServer>();
        }
        if ((typeServer = this.typeServers.get(className = pivotType.getName())) == null) {
            typeServer = (TypeServer)EcoreUtil.getAdapter((List)pivotType.eAdapters(), (Object)this.packageManager);
            if (typeServer == null) {
                typeServer = new TypeServer(this.packageManager, pivotType);
            }
            this.typeServers.put(className, typeServer);
        }
        return typeServer.getTypeTracker(pivotType);
    }

    void removedClient(PackageClient packageClient) {
        this.trackers.remove(packageClient);
    }

    void removedNestedPackage(Object nestedObject) {
        if (nestedObject instanceof Package) {
            Package nestedPackage = (Package)nestedObject;
            PackageServer packageServer = this.nestedPackageServers.get(nestedPackage.getName());
            packageServer.removedPackage(nestedPackage);
        }
    }

    void removedPackage(Package pivotPackage) {
        PackageTracker packageTracker = this.packageManager.findPackageTracker(pivotPackage);
        if (packageTracker == this) {
            this.dispose();
        } else {
            this.trackers.remove(packageTracker);
        }
    }
}

