/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.domain.types.AbstractStandardLibrary;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.BagType;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.OrderedSetType;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.SequenceType;
import org.eclipse.ocl.examples.pivot.SetType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.osgi.util.NLS;

public abstract class PivotStandardLibrary
extends AbstractStandardLibrary {
    private static final Logger logger = Logger.getLogger(PivotStandardLibrary.class);
    public static final String DEFAULT_OCL_STDLIB_URI = "http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib";
    protected String defaultStandardLibraryURI = "http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib";
    private ClassifierType anyClassifierType = null;
    private BagType bagType = null;
    private PrimitiveType booleanType = null;
    private Class classType = null;
    private ClassifierType classClassifierType = null;
    private ClassifierType collectionClassifierType = null;
    private CollectionType collectionType = null;
    private Class enumerationType = null;
    private ClassifierType enumerationClassifierType = null;
    private PrimitiveType integerType = null;
    private AnyType oclAnyType = null;
    private Class oclComparableType = null;
    private Class oclElementType = null;
    private InvalidType oclInvalidType = null;
    private Class oclLambdaType = null;
    private SelfType oclSelfType = null;
    private Class oclSummableType = null;
    private Class oclTupleType = null;
    private VoidType oclVoidType = null;
    private OrderedSetType orderedSetType = null;
    private PrimitiveType realType = null;
    private SequenceType sequenceType = null;
    private SetType setType = null;
    private PrimitiveType stringType = null;
    private PrimitiveType unlimitedNaturalType = null;
    private Map<String, Type> nameToLibraryTypeMap = null;

    protected void defineLibraryType(Type pivotType) {
        String name;
        Type oldType;
        if (this.nameToLibraryTypeMap == null) {
            this.nameToLibraryTypeMap = new HashMap<String, Type>();
        }
        if ((oldType = this.nameToLibraryTypeMap.put(name = pivotType.getName(), pivotType)) != null && oldType != pivotType) {
            logger.warn((Object)("Conflicting pivot type '" + name + "'"));
        }
    }

    public void dispose() {
        this.resetLibrary();
        super.dispose();
    }

    public ClassifierType getAnyClassifierType() {
        if (this.anyClassifierType == null) {
            Type type = this.getRequiredLibraryType("AnyClassifier");
            if (type instanceof ClassifierType) {
                if (((ClassifierType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("AnyClassifier is not a templated type");
                }
                if (((ClassifierType)type).getOwnedTemplateSignature().getParameter().size() != 1) {
                    throw new IllegalLibraryException("AnyClassifier is not a templated type with a single argument");
                }
                this.anyClassifierType = (ClassifierType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("AnyClassifier is not a ClassifierType");
            }
        }
        return this.anyClassifierType;
    }

    public BagType getBagType() {
        if (this.bagType == null) {
            Type type = this.getRequiredLibraryType("Bag");
            if (type instanceof BagType) {
                if (((BagType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("Bag is not a templated type");
                }
                if (((BagType)type).getOwnedTemplateSignature().getParameter().size() != 1) {
                    throw new IllegalLibraryException("Bag is not a templated type with a single argument");
                }
                this.bagType = (BagType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Bag is not a BagType");
            }
        }
        return this.bagType;
    }

    public PrimitiveType getBooleanType() {
        if (this.booleanType == null) {
            Type type = this.getRequiredLibraryType("Boolean");
            if (type instanceof PrimitiveType) {
                this.booleanType = (PrimitiveType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Boolean is not a PrimitiveType");
            }
        }
        return this.booleanType;
    }

    public Class getClassType() {
        if (this.classType == null) {
            Type type = this.getRequiredLibraryType("Class");
            if (type instanceof Class) {
                this.classType = (Class)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Class is not a Class");
            }
        }
        return this.classType;
    }

    public ClassifierType getClassClassifierType() {
        if (this.classClassifierType == null) {
            Type type = this.getRequiredLibraryType("ClassClassifier");
            if (type instanceof ClassifierType) {
                if (((ClassifierType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("ClassClassifier is not a templated type");
                }
                if (((ClassifierType)type).getOwnedTemplateSignature().getParameter().size() != 1) {
                    throw new IllegalLibraryException("ClassClassifier is not a templated type with a single argument");
                }
                this.classClassifierType = (ClassifierType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("ClassClassifier is not a ClassifierType");
            }
        }
        return this.classClassifierType;
    }

    public ClassifierType getCollectionClassifierType() {
        if (this.collectionClassifierType == null) {
            Type type = this.getRequiredLibraryType("CollectionClassifier");
            if (type instanceof ClassifierType) {
                if (((ClassifierType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("CollectionClassifier is not a templated type");
                }
                if (((ClassifierType)type).getOwnedTemplateSignature().getParameter().size() != 2) {
                    throw new IllegalLibraryException("CollectionClassifier is not a templated type with two arguments");
                }
                this.collectionClassifierType = (ClassifierType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("CollectionClassifier is not a ClassifierType");
            }
        }
        return this.collectionClassifierType;
    }

    public CollectionType getCollectionType() {
        if (this.collectionType == null) {
            Type type = this.getRequiredLibraryType("Collection");
            if (type instanceof CollectionType) {
                if (((CollectionType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("Collection is not a templated type");
                }
                if (((CollectionType)type).getOwnedTemplateSignature().getParameter().size() != 1) {
                    throw new IllegalLibraryException("Collection is not a templated type with a single argument");
                }
                this.collectionType = (CollectionType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Collection is not a CollectionType");
            }
        }
        return this.collectionType;
    }

    public ClassifierType getEnumerationClassifierType() {
        if (this.enumerationClassifierType == null) {
            Type type = this.getRequiredLibraryType("EnumerationClassifier");
            if (type instanceof ClassifierType) {
                if (((ClassifierType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("EnumerationClassifier is not a templated type");
                }
                if (((ClassifierType)type).getOwnedTemplateSignature().getParameter().size() != 1) {
                    throw new IllegalLibraryException("EnumerationClassifier is not a templated type with a single argument");
                }
                this.enumerationClassifierType = (ClassifierType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("EnumerationClassifier is not a ClassifierType");
            }
        }
        return this.enumerationClassifierType;
    }

    public Class getEnumerationType() {
        if (this.enumerationType == null) {
            Type type = this.getRequiredLibraryType("Enumeration");
            if (type instanceof Class) {
                this.enumerationType = (Class)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Enumeration is not a Class");
            }
        }
        return this.enumerationType;
    }

    public PrimitiveType getIntegerType() {
        if (this.integerType == null) {
            Type type = this.getRequiredLibraryType("Integer");
            if (type instanceof PrimitiveType) {
                this.integerType = (PrimitiveType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Integer is not a PrimitiveType");
            }
        }
        return this.integerType;
    }

    public Type getLibraryType(String typeName) {
        if (this.nameToLibraryTypeMap == null) {
            this.nameToLibraryTypeMap = new HashMap<String, Type>();
            this.loadDefaultLibrary(this.defaultStandardLibraryURI);
        }
        return this.nameToLibraryTypeMap.get(typeName);
    }

    public AnyType getOclAnyType() {
        if (this.oclAnyType == null) {
            Type type = this.getRequiredLibraryType("OclAny");
            if (type instanceof AnyType) {
                this.oclAnyType = (AnyType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclAny is not an AnyType");
            }
        }
        return this.oclAnyType;
    }

    public Class getOclComparableType() {
        if (this.oclComparableType == null) {
            Type type = this.getRequiredLibraryType("OclComparable");
            if (type instanceof Class) {
                this.oclComparableType = (Class)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclComparable is not a Class");
            }
        }
        return this.oclComparableType;
    }

    public Class getOclElementType() {
        if (this.oclElementType == null) {
            Type type = this.getRequiredLibraryType("OclElement");
            if (type instanceof Class) {
                this.oclElementType = (Class)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclElement is not a Class");
            }
        }
        return this.oclElementType;
    }

    public InvalidType getOclInvalidType() {
        if (this.oclInvalidType == null) {
            Type type = this.getRequiredLibraryType("OclInvalid");
            if (type instanceof InvalidType) {
                this.oclInvalidType = (InvalidType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclInvalid is not an InvalidType");
            }
        }
        return this.oclInvalidType;
    }

    public Class getOclLambdaType() {
        if (this.oclLambdaType == null) {
            Type type = this.getRequiredLibraryType("OclLambda");
            if (type instanceof Class) {
                this.oclLambdaType = (Class)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclLambda is not a Class");
            }
        }
        return this.oclLambdaType;
    }

    public Type getOclMessageType() {
        return this.getRequiredLibraryType("OclMessage");
    }

    public SelfType getOclSelfType() {
        if (this.oclSelfType == null) {
            Type type = this.getRequiredLibraryType("OclSelf");
            if (type instanceof SelfType) {
                this.oclSelfType = (SelfType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclSelf is not a SelfType");
            }
        }
        return this.oclSelfType;
    }

    public Class getOclSummableType() {
        if (this.oclSummableType == null) {
            Type type = this.getRequiredLibraryType("OclSummable");
            if (type instanceof Class) {
                this.oclSummableType = (Class)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclSummable is not a Class");
            }
        }
        return this.oclSummableType;
    }

    public Class getOclTupleType() {
        if (this.oclTupleType == null) {
            Type type = this.getRequiredLibraryType("OclTuple");
            if (type instanceof Class) {
                this.oclTupleType = (Class)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclTuple is not a Class");
            }
        }
        return this.oclTupleType;
    }

    public VoidType getOclVoidType() {
        if (this.oclVoidType == null) {
            Type type = this.getRequiredLibraryType("OclVoid");
            if (type instanceof VoidType) {
                this.oclVoidType = (VoidType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclVoid is not a VoidType");
            }
        }
        return this.oclVoidType;
    }

    public OrderedSetType getOrderedSetType() {
        if (this.orderedSetType == null) {
            Type type = this.getRequiredLibraryType("OrderedSet");
            if (type instanceof OrderedSetType) {
                if (((OrderedSetType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("OrderedSet is not a templated type");
                }
                if (((OrderedSetType)type).getOwnedTemplateSignature().getParameter().size() != 1) {
                    throw new IllegalLibraryException("OrderedSet is not a templated type with a single argument");
                }
                this.orderedSetType = (OrderedSetType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OrderedSet is not an OrderedSetType");
            }
        }
        return this.orderedSetType;
    }

    public PrimitiveType getRealType() {
        if (this.realType == null) {
            Type type = this.getRequiredLibraryType("Real");
            if (type instanceof PrimitiveType) {
                this.realType = (PrimitiveType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Real is not a PrimitiveType");
            }
        }
        return this.realType;
    }

    public Type getRequiredLibraryType(String typeName) {
        Type type = this.getLibraryType(typeName);
        if (type == null) {
            type = this.getLibraryType(typeName);
            if (this.nameToLibraryTypeMap == null || this.nameToLibraryTypeMap.isEmpty()) {
                throw new IllegalLibraryException(OCLMessages.EmptyLibrary_ERROR_);
            }
            throw new IllegalLibraryException(NLS.bind((String)OCLMessages.MissingLibraryType_ERROR_, (Object)typeName));
        }
        return type;
    }

    public SequenceType getSequenceType() {
        if (this.sequenceType == null) {
            Type type = this.getRequiredLibraryType("Sequence");
            if (type instanceof SequenceType) {
                if (((SequenceType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("Sequence is not a templated type");
                }
                if (((SequenceType)type).getOwnedTemplateSignature().getParameter().size() != 1) {
                    throw new IllegalLibraryException("Sequence is not a templated type with a single argument");
                }
                this.sequenceType = (SequenceType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Sequence is not a SequenceType");
            }
        }
        return this.sequenceType;
    }

    public SetType getSetType() {
        if (this.setType == null) {
            Type type = this.getRequiredLibraryType("Set");
            if (type instanceof SetType) {
                if (((SetType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("Set is not a templated type");
                }
                if (((SetType)type).getOwnedTemplateSignature().getParameter().size() != 1) {
                    throw new IllegalLibraryException("Set is not a templated type with a single argument");
                }
                this.setType = (SetType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Set is not a SetType");
            }
        }
        return this.setType;
    }

    public PrimitiveType getStringType() {
        if (this.stringType == null) {
            Type type = this.getRequiredLibraryType("String");
            if (type instanceof PrimitiveType) {
                this.stringType = (PrimitiveType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("String is not a PrimitiveType");
            }
        }
        return this.stringType;
    }

    public PrimitiveType getUnlimitedNaturalType() {
        if (this.unlimitedNaturalType == null) {
            Type type = this.getRequiredLibraryType("UnlimitedNatural");
            if (type instanceof PrimitiveType) {
                this.unlimitedNaturalType = (PrimitiveType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("UnlimitedNatural is not a PrimitiveType");
            }
        }
        return this.unlimitedNaturalType;
    }

    public boolean isOrdered(Type sourceType) {
        if (sourceType instanceof OrderedSetType) {
            return true;
        }
        return sourceType instanceof SequenceType;
    }

    public boolean isUnique(Type sourceType) {
        if (sourceType instanceof OrderedSetType) {
            return true;
        }
        return sourceType instanceof SetType;
    }

    protected abstract Resource loadDefaultLibrary(String var1);

    public void resetLibrary() {
        this.bagType = null;
        this.booleanType = null;
        this.classType = null;
        this.classClassifierType = null;
        this.anyClassifierType = null;
        this.collectionClassifierType = null;
        this.collectionType = null;
        this.enumerationClassifierType = null;
        this.enumerationType = null;
        this.integerType = null;
        this.oclAnyType = null;
        this.oclElementType = null;
        this.oclInvalidType = null;
        this.oclLambdaType = null;
        this.oclTupleType = null;
        this.oclVoidType = null;
        this.orderedSetType = null;
        this.realType = null;
        this.sequenceType = null;
        this.setType = null;
        this.stringType = null;
        this.unlimitedNaturalType = null;
        this.nameToLibraryTypeMap = null;
    }
}

