/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.internal.impl.TypedElementImpl;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleTypeManager {
    protected final MetaModelManager metaModelManager;
    private Map<Integer, List<TupleType>> hash2tuple = null;

    protected TupleTypeManager(MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
    }

    public void dispose() {
        this.hash2tuple = null;
    }

    public Type getCommonType(TupleType leftType, TupleType rightType, Map<TemplateParameter, ParameterableElement> bindings) {
        EList<Property> leftProperties = leftType.getOwnedAttribute();
        EList<Property> rightProperties = rightType.getOwnedAttribute();
        if (leftProperties.size() != rightProperties.size()) {
            return null;
        }
        boolean isLeft = true;
        boolean isRight = true;
        ArrayList<Property> commonProperties = new ArrayList<Property>(leftProperties.size());
        for (Property leftProperty : leftProperties) {
            Property rightProperty = PivotUtil.getNamedElement(rightProperties, leftProperty.getName());
            Type leftPropertyType = leftProperty.getType();
            Type rightPropertyType = rightProperty.getType();
            TypedElement commonProperty = null;
            Type commonType = this.metaModelManager.getCommonType(leftPropertyType, rightPropertyType, bindings);
            if (commonType == null) {
                return null;
            }
            if (commonType != leftPropertyType) {
                isLeft = false;
            } else {
                commonProperty = leftProperty;
            }
            if (commonType != rightPropertyType) {
                isRight = false;
            } else {
                commonProperty = rightProperty;
            }
            if (commonProperty == null) {
                commonProperty = new TuplePart(leftProperty.getName(), commonType);
            }
            commonProperties.add((Property)commonProperty);
        }
        if (isLeft) {
            return leftType;
        }
        if (isRight) {
            return rightType;
        }
        return this.getTupleType(leftType.getName(), commonProperties, bindings);
    }

    /*
     * WARNING - void declaration
     */
    protected TupleType getOrderedTupleType(String name, List<TuplePart> orderedParts) {
        void var4_9;
        if (this.hash2tuple == null) {
            this.hash2tuple = new HashMap<Integer, List<TupleType>>();
        }
        int hash = name.hashCode();
        for (TypedElement typedElement : orderedParts) {
            hash = 101 * hash + typedElement.getName().hashCode();
        }
        List<TupleType> list = this.hash2tuple.get(hash);
        if (list == null) {
            ArrayList arrayList = new ArrayList();
            this.hash2tuple.put(hash, arrayList);
        }
        int iMax = orderedParts.size();
        for (TupleType candidateTupleType : var4_9) {
            EList<Property> candidateParts = candidateTupleType.getOwnedAttribute();
            if (candidateParts.size() != iMax) continue;
            int i = 0;
            for (TuplePart orderedPart : orderedParts) {
                Property candidatePart = (Property)candidateParts.get(i);
                if (orderedPart.getType() != candidatePart.getType() || !orderedPart.getName().equals(candidatePart.getName())) break;
                ++i;
            }
            if (i < iMax) continue;
            return candidateTupleType;
        }
        TupleType tupleType = PivotFactory.eINSTANCE.createTupleType();
        tupleType.setName(name);
        EList<Property> tupleParts = tupleType.getOwnedAttribute();
        for (TuplePart part : orderedParts) {
            Property tuplePart = PivotFactory.eINSTANCE.createProperty();
            tuplePart.setName(part.getName());
            tuplePart.setType(part.getType());
            tupleParts.add(tuplePart);
        }
        tupleType.getSuperClass().add((Object)this.metaModelManager.getOclTupleType());
        var4_9.add(tupleType);
        this.metaModelManager.addOrphanClass(tupleType);
        return tupleType;
    }

    public TupleType getTupleType(String typeName, Collection<? extends DomainTypedElement> parts, Map<TemplateParameter, ParameterableElement> bindings) {
        ArrayList<TuplePart> orderedParts = new ArrayList<TuplePart>(parts.size());
        for (DomainTypedElement domainTypedElement : parts) {
            Type type = this.metaModelManager.getType(domainTypedElement.getType());
            Type specializedType = this.metaModelManager.getSpecializedType(type, bindings);
            orderedParts.add(new TuplePart(domainTypedElement.getName(), specializedType));
        }
        Collections.sort(orderedParts);
        return this.getOrderedTupleType(typeName, orderedParts);
    }

    public TupleType getTupleType(TupleType type, Map<TemplateParameter, ParameterableElement> usageBindings) {
        TupleType specializedTupleType = type;
        HashMap<String, Type> resolutions = null;
        for (Property property : specializedTupleType.getOwnedAttribute()) {
            Type propertyType = this.metaModelManager.getTypeWithMultiplicity(property);
            Type resolvedPropertyType = this.metaModelManager.getSpecializedType(propertyType, usageBindings);
            if (resolvedPropertyType == propertyType) continue;
            if (resolutions == null) {
                resolutions = new HashMap<String, Type>();
            }
            resolutions.put(property.getName(), resolvedPropertyType);
        }
        if (resolutions != null) {
            ArrayList<Property> parts = new ArrayList<Property>();
            Iterator iterator = specializedTupleType.getOwnedAttribute().iterator();
            while (iterator.hasNext()) {
                Property property;
                TypedElement part = property = (Property)iterator.next();
                Type resolvedPropertyType = (Type)resolutions.get(property.getName());
                if (resolvedPropertyType != null) {
                    part = new TuplePart(property.getName(), resolvedPropertyType);
                }
                parts.add((Property)part);
            }
            specializedTupleType = this.getTupleType(type.getName(), parts, usageBindings);
        }
        return specializedTupleType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TuplePart
    extends TypedElementImpl
    implements Comparable<TuplePart> {
        public TuplePart(String name, Type type) {
            this.setName(name);
            this.setType(type);
        }

        @Override
        public int compareTo(TuplePart o) {
            String n2;
            String n1 = this.getName();
            if (n1 == (n2 = o.getName())) {
                return 0;
            }
            if (n1 == null) {
                return -1;
            }
            if (n2 == null) {
                return 1;
            }
            return n1.compareTo(n2);
        }
    }
}

