/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.prettyprint;

import java.math.BigInteger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.prettyprint.PivotPrettyPrintVisitor;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.util.AbstractVisitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class EssentialOCLPrettyPrintVisitor
extends PivotPrettyPrintVisitor {
    public static PrettyPrinter.Factory FACTORY = new Factory();

    public EssentialOCLPrettyPrintVisitor(PrettyPrinter context) {
        super(context);
    }

    protected void appendSourceNavigation(CallExp object) {
        OCLExpression source = object.getSource();
        if (!(source == null || source instanceof VariableExp && ((VariableExp)source).isImplicit())) {
            if (source instanceof OperationCallExp && ((OperationCallExp)source).getReferredOperation() != null && ((OperationCallExp)source).getReferredOperation().getPrecedence() != null) {
                ((PrettyPrinter)this.context).append("(");
                ((PrettyPrinter)this.context).precedenceVisit(source, null);
                ((PrettyPrinter)this.context).append(")");
            } else {
                this.safeVisit(source);
            }
            if (source.getType() instanceof CollectionType) {
                ((PrettyPrinter)this.context).append(object.isImplicit() ? "." : "->");
            } else if (!object.isImplicit()) {
                ((PrettyPrinter)this.context).append(".");
            }
        }
    }

    public Object visitBooleanLiteralExp(BooleanLiteralExp object) {
        ((PrettyPrinter)this.context).append(Boolean.toString(object.isBooleanSymbol()));
        return null;
    }

    public Object visitCollectionItem(CollectionItem object) {
        this.safeVisit(object.getItem());
        return null;
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp object) {
        ((PrettyPrinter)this.context).appendName(object.getType(), ((PrettyPrinter)this.context).getReservedNames());
        EList<CollectionLiteralPart> parts = object.getPart();
        if (parts.isEmpty()) {
            ((PrettyPrinter)this.context).append("{}");
        } else {
            ((PrettyPrinter)this.context).push("{", "");
            String prefix = "";
            for (CollectionLiteralPart part : parts) {
                ((PrettyPrinter)this.context).append(prefix);
                this.safeVisit(part);
                prefix = ", ";
            }
            ((PrettyPrinter)this.context).exdent("", "}", "");
            ((PrettyPrinter)this.context).pop();
        }
        return null;
    }

    public Object visitCollectionRange(CollectionRange object) {
        this.safeVisit(object.getFirst());
        ((PrettyPrinter)this.context).next("", "..", "");
        this.safeVisit(object.getLast());
        return null;
    }

    public Object visitConstraint(Constraint object) {
        String stereotype = object.getStereotype();
        if ("body".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("body");
        } else if ("derivation".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("der");
        } else if ("initial".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("init");
        } else if ("invariant".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("inv");
        } else if ("postcondition".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("post");
        } else if ("precondition".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("pre");
        } else {
            ((PrettyPrinter)this.context).append(stereotype);
        }
        if (object.getName() != null) {
            ((PrettyPrinter)this.context).append(" ");
            ((PrettyPrinter)this.context).appendName(object);
        }
        ((PrettyPrinter)this.context).push(":", " ");
        this.safeVisit(object.getSpecification());
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    public Value visitConstructorExp(ConstructorExp object) {
        ((PrettyPrinter)this.context).appendQualifiedType(object.getType());
        ((PrettyPrinter)this.context).push("{", "");
        String prefix = "";
        for (ConstructorPart part : object.getPart()) {
            ((PrettyPrinter)this.context).append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        ((PrettyPrinter)this.context).exdent("", "}", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    public String visitConstructorPart(ConstructorPart part) {
        ((PrettyPrinter)this.context).appendName(part.getReferredProperty());
        OCLExpression initExpression = part.getInitExpression();
        if (initExpression != null) {
            ((PrettyPrinter)this.context).append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    public Object visitEnumLiteralExp(EnumLiteralExp object) {
        this.safeVisit(object.getReferredEnumLiteral());
        return null;
    }

    public Object visitExpressionInOCL(ExpressionInOCL object) {
        this.safeVisit(object.getBodyExpression());
        return null;
    }

    public Object visitIfExp(IfExp object) {
        ((PrettyPrinter)this.context).push("if", " ");
        this.safeVisit(object.getCondition());
        ((PrettyPrinter)this.context).exdent(" ", "then", " ");
        this.safeVisit(object.getThenExpression());
        ((PrettyPrinter)this.context).exdent(" ", "else", " ");
        this.safeVisit(object.getElseExpression());
        ((PrettyPrinter)this.context).exdent(" ", "endif", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    public Object visitIntegerLiteralExp(IntegerLiteralExp object) {
        ((PrettyPrinter)this.context).append(object.getIntegerSymbol());
        return null;
    }

    public Object visitInvalidLiteralExp(InvalidLiteralExp object) {
        ((PrettyPrinter)this.context).append("invalid");
        return null;
    }

    public Object visitIterateExp(IterateExp object) {
        Iteration referredIteration = object.getReferredIteration();
        OCLExpression body = object.getBody();
        Variable result = object.getResult();
        if (((PrettyPrinter)this.context).showNames()) {
            EList<Variable> iterators = object.getIterator();
            this.appendSourceNavigation(object);
            ((PrettyPrinter)this.context).appendName(referredIteration);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            if (iterators.size() > 0) {
                boolean hasExplicitIterator = false;
                for (Variable iterator : iterators) {
                    if (iterator.isImplicit()) continue;
                    if (prefix != null) {
                        ((PrettyPrinter)this.context).next(null, prefix, " ");
                    }
                    this.safeVisit(iterator);
                    prefix = ",";
                    hasExplicitIterator = true;
                }
                if (hasExplicitIterator) {
                    prefix = ";";
                }
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                this.safeVisit(result);
                ((PrettyPrinter)this.context).next(null, " |", " ");
            }
            this.safeVisit(body);
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
        } else {
            OCLExpression source = object.getSource();
            if (source != null) {
                this.safeVisit(source.getType());
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredIteration);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            for (Variable iterator : object.getIterator()) {
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                ((PrettyPrinter)this.context).appendName(iterator);
                ((PrettyPrinter)this.context).append(" : ");
                this.safeVisit(iterator.getType());
                prefix = ",";
            }
            ((PrettyPrinter)this.context).next(null, ";", " ");
            ((PrettyPrinter)this.context).appendName(result);
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(result.getType());
            ((PrettyPrinter)this.context).next(null, " |", " ");
            this.safeVisit(body != null ? body.getType() : null);
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    public Object visitIteratorExp(IteratorExp object) {
        Iteration referredIteration = object.getReferredIteration();
        OCLExpression body = object.getBody();
        if (((PrettyPrinter)this.context).showNames()) {
            EList<Variable> iterators = object.getIterator();
            this.appendSourceNavigation(object);
            if (object.isImplicit()) {
                assert (referredIteration.getName().equals("collect"));
                assert (iterators.size() == 1);
                this.safeVisit(body);
            } else {
                ((PrettyPrinter)this.context).appendName(referredIteration);
                ((PrettyPrinter)this.context).push("(", "");
                if (iterators.size() > 0) {
                    String prefix = null;
                    boolean hasExplicitIterator = false;
                    for (Variable iterator : iterators) {
                        if (iterator.isImplicit()) continue;
                        if (prefix != null) {
                            ((PrettyPrinter)this.context).next(null, prefix, " ");
                        }
                        this.safeVisit(iterator);
                        prefix = ",";
                        hasExplicitIterator = true;
                    }
                    if (hasExplicitIterator) {
                        ((PrettyPrinter)this.context).next(null, " |", " ");
                    } else if (prefix != null) {
                        ((PrettyPrinter)this.context).next(null, prefix, " ");
                    }
                }
                this.safeVisit(body);
                ((PrettyPrinter)this.context).next("", ")", "");
                ((PrettyPrinter)this.context).pop();
            }
        } else {
            OCLExpression source = object.getSource();
            if (source != null) {
                this.safeVisit(source.getType());
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredIteration);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            for (Variable iterator : object.getIterator()) {
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                ((PrettyPrinter)this.context).appendName(iterator);
                ((PrettyPrinter)this.context).append(" : ");
                this.safeVisit(iterator.getType());
                prefix = ",";
            }
            ((PrettyPrinter)this.context).next(null, " |", " ");
            this.safeVisit(body != null ? body.getType() : null);
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    public Object visitLetExp(LetExp object) {
        ((PrettyPrinter)this.context).push("let", " ");
        this.safeVisit(object.getVariable());
        ((PrettyPrinter)this.context).exdent(" ", "in", " ");
        this.safeVisit(object.getIn());
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    public Object visitNullLiteralExp(NullLiteralExp object) {
        ((PrettyPrinter)this.context).append("null");
        return null;
    }

    public Object visitOCLExpression(OCLExpression object) {
        ((PrettyPrinter)this.context).append("<");
        ((PrettyPrinter)this.context).append(object.eClass().getName());
        ((PrettyPrinter)this.context).append(">");
        return null;
    }

    public Object visitOpaqueExpression(OpaqueExpression object) {
        String body = PivotUtil.getBody(object);
        if (body != null) {
            ((PrettyPrinter)this.context).append(body);
        } else {
            ((PrettyPrinter)this.context).append("null -- not specified");
        }
        return null;
    }

    public Object visitOperationCallExp(OperationCallExp object) {
        OCLExpression source = object.getSource();
        EList<OCLExpression> arguments = object.getArgument();
        Operation referredOperation = object.getReferredOperation();
        if (((PrettyPrinter)this.context).showNames()) {
            Precedence precedence;
            Precedence precedence2 = precedence = referredOperation != null ? referredOperation.getPrecedence() : null;
            if (precedence == null) {
                this.appendSourceNavigation(object);
                if (!object.isImplicit()) {
                    ((PrettyPrinter)this.context).appendName(referredOperation);
                    ((PrettyPrinter)this.context).push("(", "");
                    String prefix = null;
                    for (OCLExpression argument : arguments) {
                        if (prefix != null) {
                            ((PrettyPrinter)this.context).next(null, prefix, " ");
                        }
                        ((PrettyPrinter)this.context).precedenceVisit(argument, null);
                        prefix = ",";
                    }
                    ((PrettyPrinter)this.context).next("", ")", "");
                    ((PrettyPrinter)this.context).pop();
                }
            } else {
                boolean lowerPrecedence;
                Precedence currentPrecedence = ((PrettyPrinter)this.context).getCurrentPrecedence();
                boolean bl = lowerPrecedence = currentPrecedence != null && precedence.getOrder().compareTo(currentPrecedence.getOrder()) > 0;
                if (lowerPrecedence) {
                    ((PrettyPrinter)this.context).push("(", null);
                }
                if (arguments.size() == 0) {
                    ((PrettyPrinter)this.context).appendName(referredOperation, null);
                    if (referredOperation != null && PivotUtil.isValidIdentifier(referredOperation.getName())) {
                        ((PrettyPrinter)this.context).append(" ");
                    }
                    ((PrettyPrinter)this.context).precedenceVisit(source, precedence);
                } else {
                    ((PrettyPrinter)this.context).precedenceVisit(source, precedence);
                    ((PrettyPrinter)this.context).next(" ", ((PrettyPrinter)this.context).getName(referredOperation, null), " ");
                    ((PrettyPrinter)this.context).precedenceVisit((OCLExpression)arguments.get(0), precedence);
                }
                if (lowerPrecedence) {
                    ((PrettyPrinter)this.context).exdent("", ")", "");
                    ((PrettyPrinter)this.context).pop();
                }
            }
        } else {
            if (source != null) {
                this.safeVisit(source.getType());
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredOperation);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            for (OCLExpression argument : arguments) {
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                this.safeVisit(argument.getType());
                prefix = ",";
            }
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    public Object visitParameter(Parameter object) {
        ((PrettyPrinter)this.context).appendName(object);
        Type type = object.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendQualifiedType(type);
        }
        return null;
    }

    public Object visitPropertyCallExp(PropertyCallExp object) {
        Property referredProperty = object.getReferredProperty();
        if (((PrettyPrinter)this.context).showNames()) {
            this.appendSourceNavigation(object);
            ((PrettyPrinter)this.context).appendName(referredProperty);
        } else {
            this.safeVisit(referredProperty);
        }
        return null;
    }

    public Object visitRealLiteralExp(RealLiteralExp object) {
        ((PrettyPrinter)this.context).append(object.getRealSymbol());
        return null;
    }

    public Object visitStringLiteralExp(StringLiteralExp object) {
        ((PrettyPrinter)this.context).append("'");
        ((PrettyPrinter)this.context).append(PivotUtil.convertToOCLString(object.getStringSymbol()));
        ((PrettyPrinter)this.context).append("'");
        return null;
    }

    public Object visitTupleLiteralExp(TupleLiteralExp object) {
        ((PrettyPrinter)this.context).append("Tuple");
        ((PrettyPrinter)this.context).push("{", "");
        String prefix = "";
        for (TupleLiteralPart part : object.getPart()) {
            ((PrettyPrinter)this.context).append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        ((PrettyPrinter)this.context).exdent("", "}", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    public Object visitTupleLiteralPart(TupleLiteralPart object) {
        ((PrettyPrinter)this.context).appendName(object);
        ((PrettyPrinter)this.context).append(" = ");
        this.safeVisit(object.getInitExpression());
        return null;
    }

    public Object visitTypeExp(TypeExp object) {
        ((PrettyPrinter)this.context).appendQualifiedType(object.getReferredType());
        return null;
    }

    public Object visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp object) {
        BigInteger symbol = object.getUnlimitedNaturalSymbol();
        if (symbol.signum() < 0) {
            ((PrettyPrinter)this.context).append("*");
        } else {
            ((PrettyPrinter)this.context).append(symbol);
        }
        return null;
    }

    public Object visitVariable(Variable object) {
        OCLExpression initExpression;
        ((PrettyPrinter)this.context).appendName(object);
        Type type = object.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendQualifiedType(type);
        }
        if ((initExpression = object.getInitExpression()) != null) {
            ((PrettyPrinter)this.context).append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    public Object visitVariableExp(VariableExp object) {
        VariableDeclaration referredVariable = object.getReferredVariable();
        if (referredVariable != null && "self".equals(referredVariable.getName())) {
            ((PrettyPrinter)this.context).appendName(referredVariable, null);
        } else {
            ((PrettyPrinter)this.context).appendName(referredVariable);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory
    implements PrettyPrinter.Factory {
        private Factory() {
            PrettyPrinter.addFactory(PivotPackage.eINSTANCE, this);
        }

        @Override
        public AbstractVisitor<Object, PrettyPrinter> createPrettyPrintVisitor(PrettyPrinter printer) {
            return new EssentialOCLPrettyPrintVisitor(printer);
        }
    }
}

