/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.util.Visitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPivotSaver {
    private static Map<EPackage, Factory> factoryMap = new HashMap<EPackage, Factory>();
    private Map<EPackage, LocateVisitor> locateVisitors = new HashMap<EPackage, LocateVisitor>();
    private Map<EPackage, ResolveVisitor> resolveVisitors = new HashMap<EPackage, ResolveVisitor>();

    public static void addFactory(Factory factory) {
        factoryMap.put(factory.getEPackage(), factory);
    }

    public abstract void addSpecializingElement(Element var1);

    public abstract boolean addSpecializingElement(Element var1, Operation var2);

    public abstract boolean addSpecializingElement(Element var1, Type var2);

    protected LocateVisitor getLocateVisitor(EObject eObject) {
        EPackage ePackage = eObject.eClass().getEPackage();
        LocateVisitor locateVisitor = this.locateVisitors.get(ePackage);
        if (locateVisitor == null) {
            Factory factory = factoryMap.get(ePackage);
            locateVisitor = factory.createLocateVisitor(this);
            this.locateVisitors.put(ePackage, locateVisitor);
        }
        return locateVisitor;
    }

    protected ResolveVisitor getResolveVisitor(EObject eObject) {
        EPackage ePackage = eObject.eClass().getEPackage();
        ResolveVisitor resolveVisitor = this.resolveVisitors.get(ePackage);
        if (resolveVisitor == null) {
            Factory factory = factoryMap.get(ePackage);
            resolveVisitor = factory.createResolveVisitor(this);
            this.resolveVisitors.put(ePackage, resolveVisitor);
        }
        return resolveVisitor;
    }

    public abstract <T extends Operation> T resolveOperation(T var1);

    public abstract <T extends Type> T resolveType(T var1);

    public static interface Factory {
        public LocateVisitor createLocateVisitor(AbstractPivotSaver var1);

        public ResolveVisitor createResolveVisitor(AbstractPivotSaver var1);

        public EPackage getEPackage();
    }

    public static interface LocateVisitor {
        public Object safeVisit(Visitable var1);
    }

    public static interface ResolveVisitor {
        public Object safeVisit(Visitable var1);
    }
}

