/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ResourceValidatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotResourceValidator
extends ResourceValidatorImpl {
    private static final Logger log = Logger.getLogger(PivotResourceValidator.class);

    protected ValidationDiagnostic createDefaultDiagnostic(Diagnostician diagnostician, EObject pivotObject) {
        return new ValidationDiagnostic();
    }

    protected void issueFromDiagnostics(IAcceptor<Issue> acceptor, ValidationDiagnostic diagnostic) {
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            this.issueFromEValidatorDiagnostic(childDiagnostic, acceptor);
        }
    }

    protected void performValidation(IAcceptor<Issue> acceptor, Resource pivotResource, CancelIndicator monitor) {
        Diagnostician diagnostician = this.getDiagnostician();
        Map context = diagnostician.createDefaultContext();
        for (Resource pResource : pivotResource.getResourceSet().getResources()) {
            this.removeValidationDiagnostics((List<Resource.Diagnostic>)pResource.getErrors());
            this.removeValidationDiagnostics((List<Resource.Diagnostic>)pResource.getWarnings());
            for (EObject pObject : pResource.getContents()) {
                try {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    ValidationDiagnostic diagnostic = this.createDefaultDiagnostic(diagnostician, pObject);
                    diagnostician.validate(pObject, (DiagnosticChain)diagnostic, context);
                    if (diagnostic.getChildren().isEmpty()) continue;
                    if (diagnostic.getSeverity() == 4) {
                        pResource.getErrors().add((Object)diagnostic);
                    } else if (diagnostic.getSeverity() == 2) {
                        pResource.getWarnings().add((Object)diagnostic);
                    }
                    this.issueFromDiagnostics(acceptor, diagnostic);
                }
                catch (RuntimeException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void removeValidationDiagnostics(List<Resource.Diagnostic> diagnostics) {
        int i = diagnostics.size() - 1;
        while (i >= 0) {
            Resource.Diagnostic diagnostic = diagnostics.get(i);
            if (diagnostic instanceof ValidationDiagnostic) {
                diagnostics.remove(i);
            }
            --i;
        }
    }

    protected void reuseValidation(IAcceptor<Issue> acceptor, Resource pivotResource, CancelIndicator monitor) {
        for (Resource pResource : pivotResource.getResourceSet().getResources()) {
            for (Resource.Diagnostic diagnostic : pResource.getErrors()) {
                if (!(diagnostic instanceof ValidationDiagnostic)) continue;
                this.issueFromDiagnostics(acceptor, (ValidationDiagnostic)diagnostic);
            }
            for (Resource.Diagnostic diagnostic : pResource.getWarnings()) {
                if (!(diagnostic instanceof ValidationDiagnostic)) continue;
                this.issueFromDiagnostics(acceptor, (ValidationDiagnostic)diagnostic);
            }
        }
    }

    public List<Issue> validate(Resource csResource, CheckMode mode, CancelIndicator monitor) {
        Resource pivotResource;
        CS2PivotResourceAdapter cs2pivotAdapter;
        List issues = super.validate(csResource, mode, monitor);
        if (!monitor.isCanceled() && csResource instanceof BaseCSResource && (cs2pivotAdapter = CS2PivotResourceAdapter.findAdapter((BaseCSResource)csResource)) != null && (pivotResource = cs2pivotAdapter.getPivotResource(csResource)) != null) {
            IAcceptor acceptor = this.createAcceptor(issues);
            if (mode.shouldCheck(CheckType.EXPENSIVE)) {
                this.performValidation((IAcceptor<Issue>)acceptor, pivotResource, monitor);
            } else {
                this.reuseValidation((IAcceptor<Issue>)acceptor, pivotResource, monitor);
            }
            if (monitor.isCanceled()) {
                return null;
            }
        }
        return issues;
    }

    public static class ValidationDiagnostic
    extends BasicDiagnostic
    implements Resource.Diagnostic {
        private ValidationDiagnostic() {
            super("org.eclipse.emf.ecore", 0, "", null);
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return 0;
        }

        public String getLocation() {
            return null;
        }

        public Integer getOffset() {
            return null;
        }

        public Integer getLength() {
            return 10;
        }
    }
}

