/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.pivot2cs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.common.utils.ClassUtils;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.PivotSwitch;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class CompleteOCLSplitter {
    public static Resource separate(MetaModelManager metaModelManager, Resource resource) {
        ArrayList<Constraint> allConstraints = new ArrayList<Constraint>();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof Constraint) {
                allConstraints.add((Constraint)eObject);
                continue;
            }
            if (!(eObject instanceof Annotation)) continue;
            tit.prune();
        }
        if (allConstraints.isEmpty()) {
            return null;
        }
        URI uri = resource.getURI();
        URI oclURI = uri.trimFileExtension().appendFileExtension("ocl.pivot");
        Resource oclResource = resource.getResourceSet().createResource(oclURI);
        Separator separator = new Separator(metaModelManager, oclResource);
        for (Constraint constraint : allConstraints) {
            separator.doSwitch((EObject)constraint);
        }
        return oclResource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Separator
    extends PivotSwitch<EObject> {
        protected final MetaModelManager metaModelManager;
        protected final Resource separateResource;
        private final Map<NamedElement, NamedElement> map = new HashMap<NamedElement, NamedElement>();

        public Separator(MetaModelManager metaModelManager, Resource separateResource) {
            this.metaModelManager = metaModelManager;
            this.separateResource = separateResource;
        }

        public EObject caseConstraint(Constraint object) {
            NamedElement parent = (NamedElement)object.eContainer();
            NamedElement separateParent = this.getSeparate(parent);
            EList separateSiblings = separateParent.getOwnedRule();
            separateSiblings.add(object);
            return object;
        }

        public EObject caseOperation(Operation object) {
            Type parent = object.getOwningType();
            Type separateParent = this.getSeparate(parent);
            EList separateSiblings = separateParent.getOwnedOperation();
            EcoreUtil.Copier copier = new EcoreUtil.Copier(false, true){

                protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
                    if (eReference == PivotPackage.Literals.OPERATION__OWNED_PARAMETER) {
                        super.copyContainment(eReference, eObject, copyEObject);
                    }
                }
            };
            Operation clone = (Operation)copier.copy((EObject)object);
            copier.copyReferences();
            separateSiblings.add(clone);
            return clone;
        }

        public EObject casePackage(Package object) {
            Package separateObject;
            String name = object.getName();
            EObject container = object.eContainer();
            if (container instanceof Package) {
                EList separateSiblings;
                Package parent = (Package)container;
                Package separateParent = (Package)this.map.get(parent);
                if (separateParent == null) {
                    separateParent = (Package)this.doSwitch((EObject)parent);
                    this.map.put((NamedElement)parent, (NamedElement)separateParent);
                    this.metaModelManager.addPackage(separateParent);
                }
                if ((separateObject = (Package)PivotUtil.getNamedElement((Iterable)(separateSiblings = separateParent.getNestedPackage()), (String)name)) == null) {
                    separateObject = (Package)object.eClass().getEPackage().getEFactoryInstance().create(object.eClass());
                    separateObject.setName(name);
                    separateObject.setNsURI(object.getNsURI());
                    separateObject.setNsPrefix(object.getNsPrefix());
                    separateSiblings.add(separateObject);
                    this.metaModelManager.addPackage(separateObject);
                }
            } else {
                EList separateSiblings = this.separateResource.getContents();
                separateObject = (Package)this.getElementByName((Iterable<? extends EObject>)separateSiblings, name);
                if (separateObject == null) {
                    separateObject = (Package)object.eClass().getEPackage().getEFactoryInstance().create(object.eClass());
                    separateObject.setName(name);
                    separateObject.setNsURI(object.getNsURI());
                    separateObject.setNsPrefix(object.getNsPrefix());
                    separateSiblings.add(separateObject);
                    this.metaModelManager.addPackage(separateObject);
                }
            }
            return separateObject;
        }

        protected Package getSeparatePackage(Package element) {
            Package separate = (Package)this.map.get(element);
            if (separate == null) {
                separate = (Package)this.doSwitch((EObject)element);
                this.map.put((NamedElement)element, (NamedElement)separate);
                this.metaModelManager.addPackage(separate);
            }
            return separate;
        }

        public EObject caseProperty(Property object) {
            Type parent = object.getOwningType();
            Type separateParent = this.getSeparate(parent);
            EList separateSiblings = separateParent.getOwnedAttribute();
            EcoreUtil.Copier copier = new EcoreUtil.Copier(false, true){

                protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
                }
            };
            Property clone = (Property)copier.copy((EObject)object);
            copier.copyReferences();
            separateSiblings.add(clone);
            return clone;
        }

        public EObject caseType(Type object) {
            Package parent = object.getPackage();
            Package separateParent = this.getSeparate(parent);
            EList separateSiblings = separateParent.getOwnedType();
            return this.cloneNamedElement((List)separateSiblings, (NamedElement)object);
        }

        protected <T extends NamedElement> T cloneNamedElement(List<T> separateSiblings, T object) {
            String name = object.getName();
            NamedElement separateObject = PivotUtil.getNamedElement(separateSiblings, (String)name);
            if (separateObject == null) {
                NamedElement castObject;
                separateObject = castObject = (NamedElement)object.eClass().getEPackage().getEFactoryInstance().create(object.eClass());
                separateObject.setName(name);
                separateSiblings.add(separateObject);
            }
            return (T)separateObject;
        }

        public NamedElement getElementByName(Iterable<? extends EObject> elements, String name) {
            if (elements == null) {
                return null;
            }
            for (EObject eObject : elements) {
                if (!(eObject instanceof NamedElement) || !ClassUtils.equals((Object)name, (Object)((NamedElement)eObject).getName())) continue;
                return (NamedElement)eObject;
            }
            return null;
        }

        protected <T extends NamedElement> T getSeparate(T element) {
            NamedElement separate = this.map.get(element);
            if (separate == null) {
                separate = (NamedElement)this.doSwitch((EObject)element);
                this.map.put(element, separate);
            }
            NamedElement castSeparate = separate;
            return (T)castSeparate;
        }
    }
}

