/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.console;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueImpl;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.context.EClassContext;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.evaluation.PivotEvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.examples.xtext.console.ColorManager;
import org.eclipse.ocl.examples.xtext.console.ModelingLevel;
import org.eclipse.ocl.examples.xtext.console.OCLConsole;
import org.eclipse.ocl.examples.xtext.console.XtextConsolePlugin;
import org.eclipse.ocl.examples.xtext.console.actions.CloseAction;
import org.eclipse.ocl.examples.xtext.console.actions.LoadExpressionAction;
import org.eclipse.ocl.examples.xtext.console.actions.SaveExpressionAction;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.ocl.examples.xtext.console.xtfo.EmbeddedXtextEditor;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.model.BaseDocument;
import org.eclipse.ocl.examples.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.EStructuralFeatureNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OCLConsolePage
extends Page {
    private final OCLConsole console;
    private Composite page;
    private ModelingLevel modelingLevel = ModelingLevel.M2;
    private ITextViewer output;
    private ColorManager colorManager;
    private SourceViewer input;
    private EmbeddedXtextEditor editor;
    private String lastOCLExpression;
    private ISelectionService selectionService;
    private ISelectionListener selectionListener;
    private EObject contextObject;
    private EClassContext eClassContext;
    private MetaModelManager nullMetaModelManager = null;
    private DomainModelManager modelManager = null;

    OCLConsolePage(OCLConsole console) {
        this.console = console;
    }

    private void append(String text, Color color, boolean bold) {
        IDocument doc = this.getDocument();
        try {
            int offset = doc.getLength();
            int length = text.length();
            text = String.valueOf(text) + '\n';
            if (offset > 0) {
                doc.replace(offset, 0, text);
            } else {
                doc.set(text);
            }
            StyleRange style = new StyleRange();
            style.start = offset;
            style.length = length;
            style.foreground = color;
            if (bold) {
                style.fontStyle = 1;
            }
            this.output.getTextWidget().setStyleRange(style);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, XtextConsolePlugin.getPluginId(), 1, ConsoleMessages.Output_Exception, (Throwable)e);
            XtextConsolePlugin.getInstance().getLog().log((IStatus)status);
        }
    }

    public void createControl(Composite parent) {
        this.page = new SashForm(parent, 0x2000200);
        this.output = new TextViewer(this.page, 2818);
        this.output.getTextWidget().setLayoutData((Object)new GridData(1808));
        this.output.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.output.setEditable(false);
        this.output.setDocument((IDocument)new Document());
        this.colorManager = new ColorManager();
        this.createEditor(this.page);
        this.input = this.editor.getViewer();
        this.input.getTextWidget().addKeyListener((KeyListener)new InputKeyListener());
        this.input.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
                OutlinePage outlinePage;
                IXtextDocument xtextDocument;
                Element pivotElement;
                ContentOutline contentOutline;
                IPage currentPage;
                IConsole console;
                if (part instanceof IConsoleView && (console = ((IConsoleView)part).getConsole()) instanceof OCLConsole) {
                    return;
                }
                if (part instanceof ContentOutline && (currentPage = (contentOutline = (ContentOutline)part).getCurrentPage()) instanceof OutlinePage && (pivotElement = (Element)(xtextDocument = (outlinePage = (OutlinePage)currentPage).getXtextDocument()).readOnly((IUnitOfWork)new IUnitOfWork<Element, XtextResource>(){

                    public Element exec(XtextResource state) throws Exception {
                        Element pivotObject;
                        EObjectNode eObjectNode;
                        URI uri;
                        EObject csObject;
                        Object selectedObject;
                        IStructuredSelection structuredSelection;
                        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (selectedObject = structuredSelection.getFirstElement()) instanceof EObjectNode && (csObject = state.getEObject((uri = (eObjectNode = (EObjectNode)selectedObject).getEObjectURI()).fragment())) instanceof Pivotable && (pivotObject = ((Pivotable)csObject).getPivot()) != null) {
                            return pivotObject;
                        }
                        return null;
                    }
                })) != null) {
                    OCLConsolePage.this.selectionChanged((ISelection)new StructuredSelection((Object)pivotElement));
                    return;
                }
                OCLConsolePage.this.selectionChanged(selection);
            }
        };
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionService.addPostSelectionListener(this.selectionListener);
        ISelection selection = this.getActiveSelection();
        this.selectionChanged(selection);
        ((SashForm)this.page).setWeights(new int[]{2, 1});
        ClearOutputAction clear = new ClearOutputAction(this.output);
        CloseAction close = new CloseAction();
        SaveExpressionAction saveExpression = new SaveExpressionAction(this);
        LoadExpressionAction loadExpression = new LoadExpressionAction(this);
        IMenuManager menu = this.getSite().getActionBars().getMenuManager();
        menu.add((IAction)loadExpression);
        menu.add((IAction)saveExpression);
        menu.add((IAction)clear);
        menu.add((IAction)close);
        IToolBarManager toolbar = this.getSite().getActionBars().getToolBarManager();
        toolbar.appendToGroup("outputGroup", (IAction)loadExpression);
        toolbar.appendToGroup("outputGroup", (IAction)saveExpression);
        toolbar.appendToGroup("outputGroup", (IAction)clear);
        toolbar.appendToGroup("outputGroup", (IAction)close);
    }

    private int convertHeightInCharsToPixels(int i) {
        GC gc = new GC((Drawable)Display.getDefault());
        gc.setFont(this.editor.getViewer().getTextWidget().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int ret = (fontMetrics.getHeight() + fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading()) * i;
        gc.dispose();
        return ret;
    }

    private void createEditor(Composite s1) {
        Composite client = s1;
        Injector injector = XtextConsolePlugin.getInstance().getInjector("org.eclipse.ocl.examples.xtext.essentialocl.EssentialOCL");
        Composite editorComposite = client;
        this.editor = new EmbeddedXtextEditor(editorComposite, injector, 770);
        this.editor.getViewer().getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if ((e.keyCode == 0x1000050 || e.keyCode == 13) && (e.stateMask & 0x60000) == 0) {
                    e.doit = false;
                }
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        editorComposite.setLayoutData((Object)data);
    }

    public void dispose() {
        this.colorManager.dispose();
        this.selectionService.removePostSelectionListener(this.selectionListener);
        super.dispose();
    }

    private void error(String message) {
        this.append(message, this.colorManager.getColor(ColorManager.OUTPUT_ERROR), false);
        this.scrollText();
    }

    boolean evaluate(final String expression) {
        if (expression == null || expression.trim().length() <= 0) {
            this.error(ConsoleMessages.Result_NoExpression);
            return false;
        }
        boolean result = true;
        try {
            IDocument doc = this.getDocument();
            Color defaultColor = this.colorManager.getColor(ColorManager.DEFAULT);
            Color resultsColor = this.colorManager.getColor(ColorManager.OUTPUT_RESULTS);
            Color errorColor = this.colorManager.getColor(ColorManager.OUTPUT_ERROR);
            if (doc.getLength() > 0) {
                this.append("", defaultColor, false);
            }
            this.append(ConsoleMessages.Heading_Evaluating, defaultColor, true);
            this.append(expression, defaultColor, false);
            this.append(ConsoleMessages.Heading_Results, defaultColor, true);
            switch (this.modelingLevel) {
                case M2: {
                    BaseDocument editorDocument = this.getEditorDocument();
                    Value value = null;
                    try {
                        value = (Value)editorDocument.readOnly((IUnitOfWork)new IUnitOfWork<Value, XtextResource>(){

                            public Value exec(XtextResource state) throws Exception {
                                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                                EvaluationRunnable runnable = new EvaluationRunnable((BaseResource)state, expression);
                                progressService.busyCursorWhile((IRunnableWithProgress)runnable);
                                return runnable.getValue();
                            }
                        });
                    }
                    catch (Exception e) {
                        this.append(e.getMessage(), errorColor, false);
                    }
                    if (value instanceof ExceptionValue) {
                        this.append(((ExceptionValue)value).getMessage(), errorColor, true);
                        this.append(String.valueOf(value), errorColor, false);
                    } else if (value != null && value.isCollectionValue() != null) {
                        for (Value elementValue : value.isCollectionValue()) {
                            this.append(String.valueOf(elementValue), resultsColor, false);
                        }
                    } else if (value != null) {
                        this.append(String.valueOf(value), resultsColor, false);
                    } else {
                        this.append(String.valueOf(value), errorColor, false);
                    }
                    this.scrollText();
                    break;
                }
                case M1: {
                    this.append(ConsoleMessages.Result_Parsed, resultsColor, false);
                    this.scrollText();
                }
            }
            this.lastOCLExpression = expression;
        }
        catch (Exception e) {
            result = false;
            this.error(e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage());
        }
        return result;
    }

    protected ISelection getActiveSelection() {
        ISelectionProvider selectionProvider;
        block13: {
            IEditorSite editorSite;
            block12: {
                IEditorPart activeEditor;
                block11: {
                    IWorkbenchPage activePage;
                    block10: {
                        IWorkbenchWindow workbenchWindow;
                        block9: {
                            IPageSite site;
                            block8: {
                                try {
                                    site = this.getSite();
                                    if (site != null) break block8;
                                    return null;
                                }
                                catch (Exception e) {
                                    return null;
                                }
                            }
                            workbenchWindow = site.getWorkbenchWindow();
                            if (workbenchWindow != null) break block9;
                            return null;
                        }
                        activePage = workbenchWindow.getActivePage();
                        if (activePage != null) break block10;
                        return null;
                    }
                    activeEditor = activePage.getActiveEditor();
                    if (activeEditor != null) break block11;
                    return null;
                }
                editorSite = activeEditor.getEditorSite();
                if (editorSite != null) break block12;
                return null;
            }
            selectionProvider = editorSite.getSelectionProvider();
            if (selectionProvider != null) break block13;
            return null;
        }
        return selectionProvider.getSelection();
    }

    public Control getControl() {
        return this.page;
    }

    private IDocument getDocument() {
        return this.output.getDocument();
    }

    public IXtextDocument getDocument(URI trimFragment) {
        return this.getEditorDocument();
    }

    public BaseDocument getEditorDocument() {
        return (BaseDocument)this.editor.getDocument();
    }

    public String getLastOCLExpression() {
        return this.lastOCLExpression;
    }

    public MetaModelManager getMetaModelManager(EObject contextObject) {
        MetaModelManager metaModelManager = ElementUtil.findMetaModelManager((EObject)contextObject);
        if (metaModelManager != null) {
            return metaModelManager;
        }
        if (this.nullMetaModelManager == null) {
            this.nullMetaModelManager = new MetaModelManager();
        }
        return this.nullMetaModelManager;
    }

    protected void refreshSelection(final Object selected) {
        final BaseDocument editorDocument = this.getEditorDocument();
        editorDocument.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Value exec(XtextResource resource) throws Exception {
                EClass contextClassifier = null;
                Object selectedObject = selected;
                if (selectedObject instanceof IOutlineNode) {
                    if (selectedObject instanceof EObjectNode) {
                        EObjectNode selectedObjectNode = (EObjectNode)selectedObject;
                        URI eObjectURI = selectedObjectNode.getEObjectURI();
                        OCLConsolePage.this.contextObject = null;
                        contextClassifier = selectedObjectNode.getEClass();
                    } else if (selectedObject instanceof EStructuralFeatureNode) {
                        OCLConsolePage.this.contextObject = null;
                        contextClassifier = ((EStructuralFeatureNode)selectedObject).getEStructuralFeature().getEContainingClass();
                    } else {
                        OCLConsolePage.this.contextObject = null;
                        contextClassifier = null;
                    }
                } else {
                    if (selectedObject instanceof IAdaptable) {
                        selectedObject = ((IAdaptable)selectedObject).getAdapter(EObject.class);
                    }
                    if (selectedObject instanceof EObject) {
                        OCLConsolePage.this.contextObject = (EObject)selectedObject;
                        contextClassifier = OCLConsolePage.this.contextObject.eClass();
                    } else {
                        OCLConsolePage.this.contextObject = null;
                        contextClassifier = null;
                    }
                }
                MetaModelManager metaModelManager = OCLConsolePage.this.getMetaModelManager(OCLConsolePage.this.contextObject);
                if (OCLConsolePage.this.contextObject != null) {
                    CS2PivotResourceAdapter.getAdapter((Resource)resource, (MetaModelManager)metaModelManager);
                }
                MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)OCLConsolePage.this.editor.getResourceSet(), (MetaModelManager)metaModelManager);
                editorDocument.setContext((EssentialOCLCSResource)resource, (EClassifier)contextClassifier, null);
                OCLConsolePage.this.console.setSelection((EClassifier)contextClassifier, OCLConsolePage.this.contextObject);
                OCLConsolePage.this.eClassContext = contextClassifier != null ? new EClassContext(metaModelManager, null, (EClassifier)contextClassifier) : null;
                return null;
            }
        });
    }

    private void scrollText() {
        this.output.revealRange(this.getDocument().getLength(), 0);
    }

    private void selectionChanged(ISelection sel) {
        IStructuredSelection ssel;
        Object selectedObject = null;
        if (sel instanceof IStructuredSelection && !(ssel = (IStructuredSelection)sel).isEmpty()) {
            selectedObject = ssel.getFirstElement();
        }
        this.refreshSelection(selectedObject);
    }

    public void setFocus() {
        this.input.getTextWidget().setFocus();
    }

    protected static class CancelableEvaluationVisitor
    extends EvaluationVisitorImpl {
        private final IProgressMonitor monitor;

        protected CancelableEvaluationVisitor(IProgressMonitor monitor, Environment env, EvaluationEnvironment evalEnv, DomainModelManager modelManager) {
            super(env, evalEnv, modelManager);
            this.monitor = monitor;
        }

        public EvaluationVisitor createNestedEvaluator() {
            EnvironmentFactory factory = this.environment.getFactory();
            EvaluationEnvironment nestedEvalEnv = factory.createEvaluationEnvironment(this.evaluationEnvironment);
            return new CancelableEvaluationVisitor(this.monitor, this.environment, nestedEvalEnv, this.modelManager);
        }

        protected EvaluationVisitor getUndecoratedVisitor() {
            this.getValueFactory();
            return super.getUndecoratedVisitor();
        }

        public ValueFactory getValueFactory() {
            if (this.monitor.isCanceled()) {
                this.setCanceled(true);
            }
            return super.getValueFactory();
        }
    }

    private class EvaluationRunnable
    implements IRunnableWithProgress {
        private final BaseResource resource;
        private final String expression;
        private Value value = null;

        public EvaluationRunnable(BaseResource resource, String expression) {
            this.resource = resource;
            this.expression = expression;
        }

        public Value getValue() {
            return this.value;
        }

        public void run(IProgressMonitor monitor) {
            ExpressionInOCL expressionInOCL;
            monitor.beginTask(NLS.bind((String)ConsoleMessages.Progress_Title, (Object)this.expression), 10);
            monitor.subTask(ConsoleMessages.Progress_Synchronising);
            monitor.worked(1);
            MetaModelManager metaModelManager = OCLConsolePage.this.getMetaModelManager(OCLConsolePage.this.contextObject);
            ValueFactory valueFactory = metaModelManager.getValueFactory();
            try {
                PivotUtil.checkResourceErrors(null, (Resource)this.resource);
                expressionInOCL = OCLConsolePage.this.eClassContext.getExpression(this.resource);
            }
            catch (ParserException e) {
                this.value = new ExceptionValue(valueFactory, ConsoleMessages.Result_ParsingFailure, (Exception)((Object)e));
                return;
            }
            monitor.subTask(ConsoleMessages.Progress_Extent);
            PivotEnvironmentFactory envFactory = new PivotEnvironmentFactory(null, metaModelManager);
            PivotEnvironment environment = envFactory.createEnvironment();
            PivotEvaluationEnvironment evaluationEnvironment = envFactory.createEvaluationEnvironment();
            Value contextValue = valueFactory.valueOf((Object)OCLConsolePage.this.contextObject);
            evaluationEnvironment.add((DomainTypedElement)expressionInOCL.getContextVariable(), contextValue);
            OCLConsolePage.this.modelManager = evaluationEnvironment.createModelManager((Object)OCLConsolePage.this.contextObject);
            monitor.worked(2);
            monitor.subTask(ConsoleMessages.Progress_Evaluating);
            try {
                CancelableEvaluationVisitor evaluationVisitor = new CancelableEvaluationVisitor(monitor, (Environment)environment, (EvaluationEnvironment)evaluationEnvironment, OCLConsolePage.this.modelManager);
                this.value = (Value)evaluationVisitor.visitExpressionInOCL(expressionInOCL);
            }
            catch (EvaluationHaltedException e) {
                this.value = new ExceptionValue(valueFactory, ConsoleMessages.Result_EvaluationTerminated, null);
            }
            catch (InvalidEvaluationException e) {
                this.value = new ExceptionValue(valueFactory, ConsoleMessages.Result_EvaluationFailure, (Exception)((Object)e));
            }
            monitor.worked(4);
        }
    }

    protected static class ExceptionValue
    extends InvalidValueImpl {
        private final String message;
        private final Exception exception;

        protected ExceptionValue(ValueFactory valueFactory, String message, Exception exception) {
            super(valueFactory);
            this.message = message;
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            Throwable t = this.exception;
            while (t != null) {
                s.append(t.getMessage());
                if (t.getCause() != null) {
                    s.append("\n");
                }
                t = t.getCause();
            }
            return s.toString();
        }
    }

    private class InputKeyListener
    implements KeyListener {
        private boolean evaluationSuccess = false;
        private List<String> history = new ArrayList<String>();
        private int currentHistoryPointer = 0;

        private InputKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    String text = OCLConsolePage.this.getEditorDocument().get();
                    this.evaluationSuccess = OCLConsolePage.this.evaluate(text.trim());
                    break;
                }
                case 0x1000005: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    if (this.currentHistoryPointer == 0 && this.history.size() > 0) {
                        if (this.history.size() > 0 && this.history.get(0).length() == 0) {
                            this.history.remove(0);
                        }
                        this.history.add(0, OCLConsolePage.this.getEditorDocument().get().trim());
                        this.currentHistoryPointer = 1;
                        this.setTextFromHistory();
                        break;
                    }
                    if (this.currentHistoryPointer >= this.history.size() - 1) break;
                    ++this.currentHistoryPointer;
                    this.setTextFromHistory();
                    break;
                }
                case 0x1000006: {
                    if ((e.stateMask & 0x60000) != 0 || this.currentHistoryPointer <= 0) break;
                    --this.currentHistoryPointer;
                    this.setTextFromHistory();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    if (this.evaluationSuccess) {
                        OCLConsolePage.this.getEditorDocument().set("");
                        if (this.history.size() > 0 && this.history.get(0).trim().length() == 0) {
                            this.history.remove(0);
                        }
                        if (this.history.size() == 0 || !this.history.get(0).equals(OCLConsolePage.this.lastOCLExpression.trim())) {
                            this.history.add(0, OCLConsolePage.this.lastOCLExpression.trim());
                        }
                        this.currentHistoryPointer = 0;
                    }
                    this.evaluationSuccess = false;
                }
            }
        }

        protected void setTextFromHistory() {
            String newText = this.history.get(this.currentHistoryPointer);
            OCLConsolePage.this.getEditorDocument().set(newText);
            OCLConsolePage.this.input.setSelectedRange(newText.length(), 0);
        }
    }
}

