/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.AbstractAttribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.util.Nameable;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.scoping.BaseScopeView;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ContextCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.OperationFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationRole;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;

public class InvocationExpCSAttribution
extends AbstractAttribution {
    public static final InvocationExpCSAttribution INSTANCE = new InvocationExpCSAttribution();

    public ScopeView computeLookup(EObject target, EnvironmentView environmentView, ScopeView scopeView) {
        OCLExpression source;
        ExpCS csSource;
        OperatorCS csOperator;
        InvocationExpCS targetElement = (InvocationExpCS)target;
        EObject fromArgument = scopeView.getChild();
        if (fromArgument instanceof NavigatingArgCS) {
            CallExp pivot;
            if (((NavigatingArgCS)fromArgument).getRole() == NavigationRole.EXPRESSION) {
                NavigationOperatorCS csNavigationOperator;
                ExpCS csSource2;
                OCLExpression source2;
                OperatorCS csParent;
                pivot = (CallExp)PivotUtil.getPivot(CallExp.class, (Pivotable)targetElement);
                if (pivot instanceof LoopExp) {
                    for (Variable iterator : ((LoopExp)pivot).getIterator()) {
                        if (iterator.isImplicit()) {
                            environmentView.addElementsOfScope((Element)iterator.getType(), scopeView);
                        } else {
                            environmentView.addNamedElement((Nameable)iterator);
                        }
                        if (!environmentView.hasFinalResult()) continue;
                        return null;
                    }
                    if (pivot instanceof IterateExp) {
                        Variable result = ((IterateExp)pivot).getResult();
                        if (result.isImplicit()) {
                            environmentView.addElementsOfScope((Element)result.getType(), scopeView);
                        } else {
                            environmentView.addNamedElement((Nameable)result);
                        }
                        if (environmentView.hasFinalResult()) {
                            return null;
                        }
                    }
                } else if (pivot == null && (csParent = targetElement.getParent()) instanceof NavigationOperatorCS && (source2 = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)(csSource2 = (csNavigationOperator = (NavigationOperatorCS)csParent).getSource()))) != null) {
                    Type type = source2.getType();
                    if (csNavigationOperator.getName().equals("->") && type instanceof CollectionType) {
                        environmentView.addElementsOfScope((Element)((CollectionType)type).getElementType(), scopeView);
                    }
                }
            } else if (((NavigatingArgCS)fromArgument).getRole() == NavigationRole.ITERATOR) {
                pivot = (CallExp)PivotUtil.getPivot(CallExp.class, (Pivotable)targetElement);
                if (pivot instanceof LoopExp) {
                    environmentView.addNamedElements((Iterable)((LoopExp)pivot).getIterator());
                }
            } else if (((NavigatingArgCS)fromArgument).getRole() == NavigationRole.ACCUMULATOR && (pivot = (CallExp)PivotUtil.getPivot(CallExp.class, (Pivotable)targetElement)) instanceof IterateExp) {
                environmentView.addNamedElement((Nameable)((IterateExp)pivot).getResult());
            }
            ContextCSAttribution.NoImplicitProperties filter = ContextCSAttribution.NoImplicitProperties.INSTANCE;
            try {
                environmentView.addFilter((ScopeFilter)filter);
                ElementCS parent = targetElement.getLogicalParent();
                BaseScopeView.computeLookups((EnvironmentView)environmentView, (ElementCS)parent, (EObject)target, (EStructuralFeature)PivotPackage.Literals.OPERATION_CALL_EXP__ARGUMENT, null);
                return null;
            }
            finally {
                environmentView.removeFilter((ScopeFilter)filter);
            }
        }
        ExpCS explicitSource = null;
        Object scopeTarget = null;
        if (target.eContainer() instanceof InfixExpCS && (csOperator = targetElement.getParent()) != null && (csSource = csOperator.getSource()) != target) {
            scopeTarget = csOperator;
            explicitSource = csSource;
        }
        if (scopeTarget == null) {
            scopeTarget = targetElement.getLogicalParent();
        }
        Type type = null;
        if (explicitSource != null && (source = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, explicitSource)) != null) {
            type = source.getType();
        }
        ScopeFilter filter = this.createInvocationFilter(environmentView.getMetaModelManager(), targetElement, type);
        try {
            environmentView.addFilter(filter);
            BaseScopeView.computeLookups((EnvironmentView)environmentView, (ElementCS)scopeTarget, (EObject)target, (EStructuralFeature)PivotPackage.Literals.OPERATION_CALL_EXP__REFERRED_OPERATION, null);
            return null;
        }
        finally {
            environmentView.removeFilter(filter);
        }
    }

    protected ScopeFilter createInvocationFilter(MetaModelManager metaModelManager, InvocationExpCS targetElement, Type type) {
        return new OperationFilter(metaModelManager, type, targetElement);
    }
}

