/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.ui;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.customization.properties.Activator;
import org.eclipse.papyrus.customization.properties.messages.Messages;
import org.eclipse.papyrus.customization.properties.ui.CopyContextAction;
import org.eclipse.papyrus.customization.properties.ui.EditContextAction;
import org.eclipse.papyrus.customization.properties.ui.RemoveContextAction;
import org.eclipse.papyrus.infra.widgets.editors.InputDialog;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class CustomizationDialog
extends TrayDialog
implements SelectionListener {
    private List availableContexts;
    private ListViewer availableContextsViewer;
    private Button copyContext;
    private Button editContext;
    private Button removeContext;

    public CustomizationDialog(Shell shell) {
        super(shell);
    }

    public void create() {
        super.create();
        super.getShell().setText(Messages.CustomizationDialog_customization);
        super.getShell().setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
        Composite contents = new Composite(this.getDialogArea(), 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(contents, 0);
        label.setText(Messages.CustomizationDialog_selectContextToEdit);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Collection contexts = ConfigurationManager.instance.getContexts();
        this.availableContexts = new List(contents, 2816);
        this.availableContexts.setLayoutData((Object)new GridData(4, 4, true, true));
        this.availableContextsViewer = new ListViewer(this.availableContexts);
        this.availableContextsViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.availableContextsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof Context) {
                    Context context = (Context)element;
                    return String.valueOf(context.getName()) + (ConfigurationManager.instance.isPlugin(context) ? Messages.CustomizationDialog_plugin : "");
                }
                return super.getText(element);
            }
        });
        this.availableContextsViewer.setInput((Object)contexts);
        this.availableContexts.addSelectionListener((SelectionListener)this);
        Composite controls = new Composite(contents, 0);
        controls.setLayout((Layout)new FillLayout(512));
        this.copyContext = new Button(controls, 8);
        this.copyContext.setText(Messages.CustomizationDialog_copy);
        this.copyContext.setToolTipText(Messages.CustomizationDialog_createNewCopyByCopy);
        this.copyContext.setEnabled(false);
        this.copyContext.addSelectionListener((SelectionListener)this);
        this.editContext = new Button(controls, 8);
        this.editContext.setText(Messages.CustomizationDialog_edit);
        this.editContext.setToolTipText(Messages.CustomizationDialog_editSelectedContext);
        this.editContext.setEnabled(false);
        this.editContext.addSelectionListener((SelectionListener)this);
        this.removeContext = new Button(controls, 8);
        this.removeContext.setText(Messages.CustomizationDialog_delete);
        this.removeContext.setToolTipText(Messages.CustomizationDialog_removeSelectedContext);
        this.removeContext.setEnabled(false);
        this.removeContext.addSelectionListener((SelectionListener)this);
        this.availableContextsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                boolean activate = false;
                if (!selection.isEmpty()) {
                    Context context = (Context)selection.getFirstElement();
                    activate = !ConfigurationManager.instance.isPlugin(context);
                }
                CustomizationDialog.this.editContext.setEnabled(activate);
                CustomizationDialog.this.copyContext.setEnabled(!selection.isEmpty());
                CustomizationDialog.this.removeContext.setEnabled(activate);
            }
        });
        this.getShell().pack();
    }

    protected void editAction() {
        EditContextAction action = new EditContextAction();
        IStructuredSelection selection = (IStructuredSelection)this.availableContextsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        if (element instanceof Context) {
            Context sourceContext = (Context)element;
            try {
                action.openEditor(sourceContext);
                this.close();
            }
            catch (Exception ex) {
                Activator.log.error("An error occured while initializing the customization editor", (Throwable)ex);
                return;
            }
        }
    }

    protected void copyAction() {
        CopyContextAction action = new CopyContextAction();
        IStructuredSelection selection = (IStructuredSelection)this.availableContextsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        if (element instanceof Context) {
            Context sourceContext = (Context)element;
            try {
                InputDialog dialog = new InputDialog(this.getShell(), Messages.CustomizationDialog_enterConfigurationName, Messages.CustomizationDialog_enterConfigurationName, String.valueOf(Messages.CustomizationDialog_copyOf) + sourceContext.getName(), new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.trim().equals("")) {
                            return Messages.CustomizationDialog_configurationNameNotEmpty;
                        }
                        if (ConfigurationManager.instance.getContext(newText) != null) {
                            return Messages.CustomizationDialog_configurationWithSameNameExists;
                        }
                        return null;
                    }
                });
                dialog.setTitle(Messages.CustomizationDialog_configurationName);
                int result = dialog.open();
                if (result == 0) {
                    String targetName = dialog.getText();
                    action.copy(sourceContext, targetName, false);
                    this.availableContextsViewer.setInput((Object)ConfigurationManager.instance.getContexts());
                }
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    protected void deleteAction() {
        RemoveContextAction action = new RemoveContextAction();
        IStructuredSelection selection = (IStructuredSelection)this.availableContextsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        if (element instanceof Context) {
            Context sourceContext = (Context)element;
            if (ConfigurationManager.instance.isPlugin(sourceContext)) {
                Activator.log.warn(Messages.CustomizationDialog_cannotDeletePluginContext);
                return;
            }
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.CustomizationDialog_deleteContext, null, String.valueOf(Messages.CustomizationDialog_deleteContextConfirmation1) + sourceContext.getName() + Messages.CustomizationDialog_deleteContextConfirmation2, 5, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int result = dialog.open();
            if (result == 0) {
                action.removeContext(sourceContext);
                this.availableContextsViewer.setInput((Object)ConfigurationManager.instance.getContexts());
            }
        }
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.editContext) {
            this.editAction();
        } else if (e.widget == this.removeContext) {
            this.deleteAction();
        } else if (e.widget == this.copyContext) {
            this.copyAction();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        IStructuredSelection selection;
        if (e.widget == this.availableContexts && !(selection = (IStructuredSelection)this.availableContextsViewer.getSelection()).isEmpty()) {
            Context context = (Context)selection.getFirstElement();
            if (ConfigurationManager.instance.isPlugin(context)) {
                this.copyAction();
            } else {
                this.editAction();
            }
        }
    }
}

