/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IComponentPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IMultiPageEditorPart;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sasheditor.editor.SashTabDecorationSynchronizer;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IMultiEditorManager;
import org.eclipse.papyrus.infra.core.sasheditor.internal.SashWindowsContainer;
import org.eclipse.papyrus.infra.core.sasheditor.internal.eclipsecopy.MultiPageSelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractMultiPageSashEditor
extends EditorPart
implements IMultiPageEditorPart,
IMultiEditorManager {
    private ISashWindowsContentProvider pageProvider;
    private SashWindowsContainer sashContainer;
    private SashTabDecorationSynchronizer tabsSynchronizer;

    protected ISashWindowsContentProvider getContentProvider() {
        if (this.pageProvider == null) {
            this.pageProvider = this.createPageProvider();
        }
        return this.pageProvider;
    }

    protected void setContentProvider(ISashWindowsContentProvider contentProvider) {
        if (this.pageProvider == null) {
            this.pageProvider = contentProvider;
        }
    }

    protected abstract ISashWindowsContentProvider createPageProvider();

    protected void handlePropertyChange(int propertyId) {
        this.firePropertyChange(propertyId);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider(this));
    }

    public void createPartControl(Composite parent) {
        this.sashContainer = new SashWindowsContainer(this);
        this.sashContainer.setContentProvider(this.getContentProvider());
        this.sashContainer.createPartControl(parent);
        this.activate();
    }

    protected void activate() {
        this.tabsSynchronizer = new SashTabDecorationSynchronizer(this.sashContainer);
    }

    protected void deactivate() {
        this.tabsSynchronizer.dispose();
    }

    public void dispose() {
        this.deactivate();
        super.dispose();
    }

    protected void refreshTabs() {
        if (this.sashContainer != null) {
            this.sashContainer.refreshTabs();
        }
    }

    public Object getAdapter(Class adapter) {
        IEditorPart innerEditor;
        if (ISashWindowsContentProvider.class == adapter) {
            return this.getContentProvider();
        }
        if (ISashWindowsContainer.class == adapter) {
            return this.sashContainer;
        }
        Object result = super.getAdapter(adapter);
        if (result == null && Display.getCurrent() != null && (innerEditor = this.getActiveEditor()) != null && innerEditor != this) {
            result = Util.getAdapter((Object)innerEditor, (Class)adapter);
        }
        return result;
    }

    public IEditorPart getActiveEditor() {
        if (this.sashContainer.isDisposed()) {
            return null;
        }
        return this.sashContainer.getActiveEditor();
    }

    public ISashWindowsContainer getISashWindowsContainer() {
        return this.sashContainer;
    }

    public void setFocus() {
        this.sashContainer.setFocus();
    }

    public boolean isDirty() {
        EditorVisitor visitor = new EditorVisitor();
        this.sashContainer.visit(visitor);
        for (IEditorPart editorPart : visitor.getPages()) {
            if (!editorPart.isDirty()) continue;
            return true;
        }
        return false;
    }

    protected void markSaveLocation() {
        EditorVisitor visitor = new EditorVisitor();
        this.sashContainer.visit(visitor);
        for (IEditorPart editorPart : visitor.getPages()) {
            editorPart.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        this.firePropertyChange(257);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EditorVisitor
    implements IPageVisitor {
        private List<IEditorPart> pages = new ArrayList<IEditorPart>();

        protected EditorVisitor() {
        }

        public List<IEditorPart> getPages() {
            return this.pages;
        }

        @Override
        public void accept(IComponentPage page) {
        }

        @Override
        public void accept(IEditorPage page) {
            IEditorPart editor = page.getIEditorPart();
            this.pages.add(editor);
        }
    }
}

